/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.item;

import com.lothrazar.simpletomb.ConfigTomb;
import com.lothrazar.simpletomb.ModTomb;
import com.lothrazar.simpletomb.TombRegistry;
import com.lothrazar.simpletomb.data.LocationBlockPos;
import com.lothrazar.simpletomb.data.MessageType;
import com.lothrazar.simpletomb.helper.NBTHelper;
import com.lothrazar.simpletomb.helper.WorldHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemGraveKey
extends Item {
    private static final String TOMB_POS = "tombPos";

    public ItemGraveKey(Item.Properties properties) {
        super(properties.func_200917_a(1));
    }

    @OnlyIn(value=Dist.CLIENT)
    public ITextComponent func_200296_o() {
        return new TranslationTextComponent(this.func_77658_a(), new Object[0]).func_211708_a(TextFormatting.GOLD);
    }

    public void onUsingTick(ItemStack stack, LivingEntity entity, int timeLeft) {
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            LocationBlockPos location = this.getTombPos(stack);
            if (location == null || location.isOrigin() || !location.dim.equalsIgnoreCase(WorldHelper.dimensionToString(player.field_70170_p))) {
                return;
            }
            double distance = location.getDistance(player.func_180425_c());
            boolean canTp = false;
            if (player.func_184812_l_()) {
                canTp = (Boolean)ConfigTomb.TpCreative.get();
            } else {
                boolean bl = canTp = (Integer)ConfigTomb.TpSurvival.get() > 0 && distance < (double)((Integer)ConfigTomb.TpSurvival.get()).intValue() || (Integer)ConfigTomb.TpSurvival.get() == -1;
            }
            if (canTp) {
                if (timeLeft <= 1) {
                    BlockPos pos = location.toBlockPos();
                    player.func_70634_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                } else if (entity.field_70170_p.field_72995_K) {
                    ModTomb.proxy.produceParticleCasting(entity, p -> !p.func_184587_cr());
                }
            }
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 86;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        playerIn.func_184598_c(handIn);
        return ActionResult.func_226248_a_((Object)itemstack);
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (Screen.hasShiftDown()) {
            LocationBlockPos location = this.getTombPos(stack);
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player != null && !location.isOrigin()) {
                BlockPos pos = player.func_180425_c();
                int distance = (int)location.getDistance(pos);
                list.add(new TranslationTextComponent(MessageType.MESSAGE_DISTANCE.getKey(), new Object[]{distance, location.x, location.y, location.z, location.dim}).func_211708_a(TextFormatting.DARK_PURPLE));
            }
        }
        super.func_77624_a(stack, world, list, flag);
    }

    public boolean setTombPos(ItemStack stack, LocationBlockPos location) {
        if (stack.func_77973_b() == this && !location.isOrigin()) {
            NBTHelper.setLocation(stack, TOMB_POS, location);
            return true;
        }
        return false;
    }

    public LocationBlockPos getTombPos(ItemStack stack) {
        return stack.func_77973_b() == this ? NBTHelper.getLocation(stack, TOMB_POS) : LocationBlockPos.ORIGIN;
    }

    public boolean removeKeyForGraveInInventory(PlayerEntity player, LocationBlockPos graveLoc) {
        IItemHandler itemHandler = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElse(null);
        if (itemHandler != null) {
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack stack = itemHandler.getStackInSlot(i);
                if (stack.func_77973_b() != TombRegistry.grave_key || !TombRegistry.grave_key.getTombPos(stack).equals(graveLoc)) continue;
                itemHandler.extractItem(i, 1, false);
                return true;
            }
        }
        return false;
    }

    public int countKeyInInventory(PlayerEntity player) {
        return (int)player.field_71071_by.field_70462_a.stream().filter(stack -> stack.func_77973_b() == TombRegistry.grave_key).count();
    }
}

