/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import mezz.jei.config.forge.Config;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="simpletomb")
@Config(modid="simpletomb", name="simpletomb", category="")
public class ConfigTomb {
    private static final ForgeConfigSpec.Builder CFG = new ForgeConfigSpec.Builder();
    private static ForgeConfigSpec COMMON_CONFIG;
    public static ForgeConfigSpec.BooleanValue TombEnabled;
    public static ForgeConfigSpec.BooleanValue TombLogMessage;
    public static ForgeConfigSpec.BooleanValue KeyGiven;
    public static ForgeConfigSpec.BooleanValue KeyNamed;
    public static ForgeConfigSpec.IntValue TombExtraItems;
    public static ForgeConfigSpec.IntValue TpSurvival;
    public static ForgeConfigSpec.BooleanValue TpCreative;

    public static void setup(Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        COMMON_CONFIG.setConfig((CommentedConfig)configData);
    }

    private static void initConfig() {
        CFG.comment("Simple Tomb config").push("simpletomb");
        String category = "tomb.";
        TombEnabled = CFG.comment("Whether to handle player death at all (false will disable almost the entire mod)").define(category + "enabled", true);
        TombLogMessage = CFG.comment("Whether to give a Grave Key item to the player on death.  Grave can be opened without they key, but the key will help the player locate the grave").define(category + "log_message", true);
        TombExtraItems = CFG.comment("The radius in which extra bonus items should be hunted for and collected when a grave is spawned; set to zero (0) to disable").defineInRange(category + "extra_items", 2, 0, 16);
        category = "key.";
        KeyGiven = CFG.comment("Whether to give a Grave Key item to the player on death.  Grave can be opened without they key, but the key will help the player locate the grave").define(category + "given", true);
        KeyNamed = CFG.comment("If a key is being dropped, will the player's display name be added to the tomb key item name").define(category + "named", true);
        category = "teleport.";
        TpSurvival = CFG.comment("When survival player is within this (straight line calculated) distance from the tomb, they can teleport to the tomb.  Set as zero (0) to disable survival TP feature.   Set as negative one (-1) to allow survival teleportation always and ignore the distance (within dimension) ").defineInRange(category + "survival", 16, -1, 128);
        TpCreative = CFG.comment("If creative mode players can teleport to the tomb with the key, ignoring distance").define(category + "creative", true);
        CFG.pop();
        COMMON_CONFIG = CFG.build();
    }

    static {
        ConfigTomb.initConfig();
    }
}

