/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.event;

import com.lothrazar.simpletomb.ConfigTomb;
import com.lothrazar.simpletomb.ModTomb;
import com.lothrazar.simpletomb.TombRegistry;
import com.lothrazar.simpletomb.block.BlockTomb;
import com.lothrazar.simpletomb.block.TileEntityTomb;
import com.lothrazar.simpletomb.data.LocationBlockPos;
import com.lothrazar.simpletomb.data.MessageType;
import com.lothrazar.simpletomb.helper.EntityHelper;
import com.lothrazar.simpletomb.helper.WorldHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.logging.log4j.Level;

public class PlayerTombEvents {
    private static final String TB_SOULBOUND_STACKS = "tb_soulbound_stacks";

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPlayerLogged(PlayerEvent.PlayerLoggedInEvent event) {
        if (EntityHelper.isValidPlayerMP((Entity)event.getPlayer())) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            assert (player.func_184102_h() != null);
            CompoundNBT playerData = player.getPersistentData();
            if (playerData.func_74764_b("PlayerPersisted")) {
                CompoundNBT persistantData = playerData.func_74775_l("PlayerPersisted");
            } else {
                CompoundNBT persistantData = new CompoundNBT();
                playerData.func_218657_a("PlayerPersisted", (INBT)persistantData);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDetonate(ExplosionEvent.Detonate event) {
        event.getAffectedBlocks().removeIf(blockPos -> event.getWorld().func_180495_p(blockPos).func_177230_c() instanceof BlockTomb);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        PlayerEntity player = event.getPlayer();
        if (EntityHelper.isValidPlayerMP((Entity)player) && !player.func_175149_v()) {
            CompoundNBT persistentTag = EntityHelper.getPersistentTag(player);
            ListNBT stackList = persistentTag.func_150295_c(TB_SOULBOUND_STACKS, 10);
            for (int i = 0; i < stackList.size(); ++i) {
                ItemStack stack = ItemStack.func_199557_a((CompoundNBT)stackList.func_150305_b(i));
                if (stack.func_190926_b()) continue;
                ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)stack);
            }
            persistentTag.func_82580_o(TB_SOULBOUND_STACKS);
            player.field_71069_bz.func_75142_b();
        }
    }

    private void storeSoulboundsOnBody(PlayerEntity player, List<ItemStack> keys) {
        CompoundNBT persistentTag = EntityHelper.getPersistentTag(player);
        ListNBT stackList = new ListNBT();
        persistentTag.func_218657_a(TB_SOULBOUND_STACKS, (INBT)stackList);
        for (ItemStack key : keys) {
            stackList.add((Object)key.serializeNBT());
        }
        keys.clear();
    }

    private void storeIntegerStorageMap(PlayerEntity player) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
        }
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        if (!((Boolean)ConfigTomb.TombEnabled.get()).booleanValue()) {
            return;
        }
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            this.storeIntegerStorageMap(player);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void onPlayerDrops(LivingDropsEvent event) {
        boolean hasDrop;
        if (!((Boolean)ConfigTomb.TombEnabled.get()).booleanValue()) {
            return;
        }
        if (!EntityHelper.isValidPlayer((Entity)event.getEntityLiving()) || WorldHelper.isRuleKeepInventory((PlayerEntity)event.getEntityLiving())) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.getEntityLiving();
        ServerWorld world = player.func_71121_q();
        Iterator it = event.getDrops().iterator();
        ArrayList<ItemStack> keys = new ArrayList<ItemStack>();
        while (it.hasNext()) {
            ItemStack stack;
            ItemEntity entityItem = (ItemEntity)it.next();
            if (entityItem == null || entityItem.func_92059_d().func_190926_b() || (stack = entityItem.func_92059_d()).func_77973_b() != TombRegistry.grave_key) continue;
            keys.add(stack.func_77946_l());
            it.remove();
        }
        List<ItemEntity> itemsPickedUpFromGround = this.pickupFromGround((PlayerEntity)player, keys);
        this.storeSoulboundsOnBody((PlayerEntity)player, keys);
        boolean bl = hasDrop = event.getDrops().size() > 0 || itemsPickedUpFromGround.size() > 0;
        if (!hasDrop) {
            MessageType.MESSAGE_NO_LOOT_FOR_GRAVE.sendSpecialMessage((PlayerEntity)player, new Object[0]);
            return;
        }
        BlockPos initPos = WorldHelper.getCloserValidPos((World)world, new BlockPos((Vector3i)player.func_233580_cy_()));
        LocationBlockPos spawnPos = WorldHelper.findGraveSpawn((PlayerEntity)player, initPos);
        if (spawnPos == null) {
            MessageType.MESSAGE_NO_PLACE_FOR_GRAVE.sendSpecialMessage((PlayerEntity)player, new Object[0]);
            ModTomb.LOGGER.log(Level.INFO, MessageType.MESSAGE_NO_PLACE_FOR_GRAVE.getTranslation(new Object[0]));
            return;
        }
        Direction facing = player.func_174811_aO().func_176734_d();
        BlockTomb[] graves = new BlockTomb[]{TombRegistry.grave_simple, TombRegistry.grave_normal, TombRegistry.grave_cross, TombRegistry.tombstone};
        BlockState state = graves[world.field_73012_v.nextInt(graves.length)].func_176223_P();
        state = (BlockState)state.func_206870_a(BlockTomb.FACING, (Comparable)facing);
        state = (BlockState)state.func_206870_a((Property)BlockTomb.MODEL_TEXTURE, (Comparable)Integer.valueOf(world.field_73012_v.nextInt(2)));
        WorldHelper.placeNoEvent((World)world, spawnPos.toBlockPos(), state);
        TileEntity tile = world.func_175625_s(spawnPos.toBlockPos());
        if (!(tile instanceof TileEntityTomb)) {
            MessageType.MESSAGE_FAIL_TO_PLACE_GRAVE.sendSpecialMessage((PlayerEntity)player, new Object[0]);
            ModTomb.LOGGER.log(Level.INFO, MessageType.MESSAGE_FAIL_TO_PLACE_GRAVE.getTranslation(new Object[0]));
            return;
        }
        TileEntityTomb grave = (TileEntityTomb)tile;
        grave.initTombstoneOwner((PlayerEntity)player);
        ModTomb.LOGGER.log(Level.INFO, MessageType.MESSAGE_NEW_GRAVE.getTranslation(new Object[0]));
        MessageType.MESSAGE_NEW_GRAVE.sendSpecialMessage((PlayerEntity)player, new Object[0]);
        MessageType.MESSAGE_JOURNEYMAP.sendSpecialMessage((PlayerEntity)player, spawnPos.x, spawnPos.y, spawnPos.z, spawnPos.dim);
        if (((Boolean)ConfigTomb.KeyGiven.get()).booleanValue()) {
            ItemStack key = new ItemStack((IItemProvider)TombRegistry.grave_key);
            TombRegistry.grave_key.setTombPos(key, spawnPos);
            if (((Boolean)ConfigTomb.KeyNamed.get()).booleanValue()) {
                TranslationTextComponent text = new TranslationTextComponent(player.func_200200_C_().getString());
                text.func_230529_a_((ITextComponent)new TranslationTextComponent(" "));
                text.func_230529_a_(key.func_200301_q());
                text.func_240699_a_(TextFormatting.GOLD);
                key.func_200302_a((ITextComponent)text);
            }
            keys.add(key);
        }
        this.storeSoulboundsOnBody((PlayerEntity)player, keys);
        IItemHandler itemHandler = (IItemHandler)grave.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElse(null);
        for (ItemEntity entityItem : event.getDrops()) {
            if (entityItem.func_92059_d().func_190926_b()) continue;
            ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)entityItem.func_92059_d().func_77946_l(), (boolean)false);
            entityItem.func_92058_a(ItemStack.field_190927_a);
        }
        for (ItemEntity entityItem : itemsPickedUpFromGround) {
            ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)entityItem.func_92059_d(), (boolean)false);
            entityItem.func_92058_a(ItemStack.field_190927_a);
        }
        world.func_184138_a(spawnPos.toBlockPos(), Blocks.field_150350_a.func_176223_P(), state, 2);
    }

    private List<ItemEntity> pickupFromGround(PlayerEntity player, ArrayList<ItemStack> keys) {
        double range = ((Integer)ConfigTomb.TombExtraItems.get()).intValue();
        if (range == 0.0) {
            return new ArrayList<ItemEntity>();
        }
        int posX = player.func_233580_cy_().func_177958_n();
        int posY = player.func_233580_cy_().func_177956_o();
        int posZ = player.func_233580_cy_().func_177952_p();
        return player.field_70170_p.func_217357_a(ItemEntity.class, new AxisAlignedBB((double)posX - range, (double)posY - range, (double)posZ - range, (double)posX + range, (double)posY + range, (double)posZ + range));
    }
}

