/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.helper;

import com.lothrazar.simpletomb.data.LocationBlockPos;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;

public class WorldHelper {
    public static float getRandom(Random rand, double min, double max) {
        return (float)(rand.nextDouble() * (max - min) + min);
    }

    public static String dimensionToString(World w) {
        return w.func_234923_W_().func_240901_a_().toString();
    }

    public static LocationBlockPos findGraveSpawn(PlayerEntity player, BlockPos initPos) {
        int xRange = 8;
        int yRange = 6;
        int zRange = 8;
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (int x = initPos.func_177958_n() - xRange; x < initPos.func_177958_n() + xRange; ++x) {
            for (int y = initPos.func_177956_o() - yRange; y < initPos.func_177956_o() + yRange; ++y) {
                for (int z = initPos.func_177952_p() - zRange; z < initPos.func_177952_p() + zRange; ++z) {
                    positions.add(new BlockPos(x, y, z));
                }
            }
        }
        positions.sort((pos0, pos1) -> {
            double dist0 = Math.sqrt(pos0.func_177951_i((Vector3i)initPos));
            double dist1 = Math.sqrt(pos1.func_177951_i((Vector3i)initPos));
            return Double.valueOf(dist0).compareTo(dist1);
        });
        BlockPos found = null;
        for (BlockPos pos : positions) {
            if (player.field_70170_p.func_180495_p(pos).func_177230_c() != Blocks.field_150350_a) continue;
            found = pos;
            break;
        }
        return found == null ? null : new LocationBlockPos(found, player.field_70170_p);
    }

    public static BlockPos getCloserValidPos(World world, BlockPos pos) {
        boolean validY;
        WorldBorder border = world.func_175723_af();
        boolean validXZ = border.func_177746_a(pos);
        boolean bl = validY = !World.func_189509_E((BlockPos)pos);
        if (validXZ && validY) {
            return pos;
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (!validXZ) {
            x = Math.min(Math.max(pos.func_177958_n(), (int)border.func_177726_b()), (int)border.func_177728_d());
            z = Math.min(Math.max(pos.func_177952_p(), (int)border.func_177736_c()), (int)border.func_177733_e());
        }
        if (!validY) {
            y = Math.max(Math.min(pos.func_177956_o(), world.func_217301_I()), 0);
        }
        return new BlockPos(x, y, z);
    }

    public static boolean isValidPos(World world, BlockPos pos) {
        return world.func_175723_af().func_177746_a(pos) && !World.func_189509_E((BlockPos)pos);
    }

    public static boolean isValidDimension(int dim) {
        return true;
    }

    public static boolean isRuleKeepInventory(PlayerEntity player) {
        return WorldHelper.isRuleKeepInventory(player.field_70170_p);
    }

    public static boolean isRuleKeepInventory(World world) {
        return world.func_82736_K().func_223586_b(GameRules.field_223600_c);
    }

    public static void removeNoEvent(World world, BlockPos pos) {
        WorldHelper.placeNoEvent(world, pos, Blocks.field_150350_a.func_176223_P());
    }

    public static void placeNoEvent(World world, BlockPos pos, BlockState state) {
        world.func_180501_a(pos, state, 3);
    }

    public static boolean isNight(World world) {
        float angle = world.func_72826_c(0.0f);
        return angle >= 0.245f && angle <= 0.755f;
    }

    public static float[] getRGBColor3F(int color) {
        return new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
    }

    public static float[] getHSBtoRGBF(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f};
    }
}

