/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.event;

import com.lothrazar.simpletomb.TombRegistry;
import com.lothrazar.simpletomb.data.LocationBlockPos;
import com.lothrazar.simpletomb.helper.WorldHelper;
import com.lothrazar.simpletomb.particle.ParticleGraveSmoke;
import com.lothrazar.simpletomb.particle.ParticleGraveSoul;
import com.lothrazar.simpletomb.particle.ParticleRotatingSmoke;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="simpletomb", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
@OnlyIn(value=Dist.CLIENT)
public class ClientEvents {
    @SubscribeEvent(priority=EventPriority.LOW)
    public static void registerParticleFactories(ParticleFactoryRegisterEvent event) {
        ParticleManager r = Minecraft.func_71410_x().field_71452_i;
        r.func_215234_a((ParticleType)TombRegistry.GRAVE_SMOKE, ParticleGraveSmoke.Factory::new);
        r.func_215234_a((ParticleType)TombRegistry.ROTATING_SMOKE, ParticleRotatingSmoke.Factory::new);
        r.func_215234_a((ParticleType)TombRegistry.SOUL, ParticleGraveSoul.Factory::new);
    }

    @SubscribeEvent
    public void render(RenderWorldLastEvent event) {
        LocationBlockPos location;
        ItemStack stack;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && player.field_70170_p != null && (stack = player.func_184614_ca()).func_77973_b() == TombRegistry.grave_key && (location = TombRegistry.grave_key.getTombPos(stack)) != null && !location.isOrigin() && location.dim.equalsIgnoreCase(WorldHelper.dimensionToString(player.field_70170_p)) && World.func_175701_a((BlockPos)location.toBlockPos())) {
            ClientEvents.createBox(event.getMatrixStack(), location.x, location.y, location.z, 1.0);
        }
    }

    private static void createBox(MatrixStack matrixStack, double x, double y, double z, double offset) {
        Minecraft mc = Minecraft.func_71410_x();
        RenderSystem.disableTexture();
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
        RenderSystem.pushMatrix();
        Vector3d viewPosition = mc.field_71460_t.func_215316_n().func_216785_c();
        long c = System.currentTimeMillis() / 15L % 360L;
        float[] color = WorldHelper.getHSBtoRGBF((float)c / 360.0f, 1.0f, 1.0f);
        matrixStack.func_227860_a_();
        Vector3d vec = new Vector3d(x, y, z).func_178788_d(viewPosition);
        if (vec.func_72438_d(Vector3d.field_186680_a) > 200.0) {
            vec = vec.func_72432_b().func_186678_a(200.0);
            x += vec.field_72450_a;
            y += vec.field_72448_b;
            z += vec.field_72449_c;
        }
        x -= viewPosition.func_82615_a();
        y -= viewPosition.func_82617_b();
        z -= viewPosition.func_82616_c();
        RenderSystem.multMatrix((Matrix4f)matrixStack.func_227866_c_().func_227870_a_());
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder renderer = tessellator.func_178180_c();
        renderer.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        RenderSystem.color4f((float)color[0], (float)color[1], (float)color[2], (float)1.0f);
        RenderSystem.lineWidth((float)2.5f);
        renderer.func_225582_a_(x, y, z).func_181675_d();
        renderer.func_225582_a_(x + offset, y, z).func_181675_d();
        renderer.func_225582_a_(x, y, z).func_181675_d();
        renderer.func_225582_a_(x, y + offset, z).func_181675_d();
        renderer.func_225582_a_(x, y, z).func_181675_d();
        renderer.func_225582_a_(x, y, z + offset).func_181675_d();
        renderer.func_225582_a_(x + offset, y + offset, z + offset).func_181675_d();
        renderer.func_225582_a_(x, y + offset, z + offset).func_181675_d();
        renderer.func_225582_a_(x + offset, y + offset, z + offset).func_181675_d();
        renderer.func_225582_a_(x + offset, y, z + offset).func_181675_d();
        renderer.func_225582_a_(x + offset, y + offset, z + offset).func_181675_d();
        renderer.func_225582_a_(x + offset, y + offset, z).func_181675_d();
        renderer.func_225582_a_(x, y + offset, z).func_181675_d();
        renderer.func_225582_a_(x, y + offset, z + offset).func_181675_d();
        renderer.func_225582_a_(x, y + offset, z).func_181675_d();
        renderer.func_225582_a_(x + offset, y + offset, z).func_181675_d();
        renderer.func_225582_a_(x + offset, y, z).func_181675_d();
        renderer.func_225582_a_(x + offset, y, z + offset).func_181675_d();
        renderer.func_225582_a_(x + offset, y, z).func_181675_d();
        renderer.func_225582_a_(x + offset, y + offset, z).func_181675_d();
        renderer.func_225582_a_(x, y, z + offset).func_181675_d();
        renderer.func_225582_a_(x + offset, y, z + offset).func_181675_d();
        renderer.func_225582_a_(x, y, z + offset).func_181675_d();
        renderer.func_225582_a_(x, y + offset, z + offset).func_181675_d();
        tessellator.func_78381_a();
        matrixStack.func_227865_b_();
        RenderSystem.popMatrix();
        RenderSystem.lineWidth((float)1.0f);
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.enableTexture();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

