/*
 * Decompiled with CFR 0.152.
 */
package at.nuxnux.skinnedlanterns.blocks;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public class SkinnedLanternBlock
extends Block
implements IWaterLoggable {
    private static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty HANGING = BlockStateProperties.field_222514_j;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final VoxelShape SHAPE = VoxelShapes.func_197878_a((VoxelShape)Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), (VoxelShape)Block.func_208617_a((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0), (IBooleanFunction)IBooleanFunction.field_223244_o_);
    private static final VoxelShape SHAPE_HANGING = VoxelShapes.func_197878_a((VoxelShape)Block.func_208617_a((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0), (VoxelShape)Block.func_208617_a((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0), (IBooleanFunction)IBooleanFunction.field_223244_o_);

    public SkinnedLanternBlock(boolean soul) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_235861_h_().func_200943_b(3.5f).func_200947_a(SoundType.field_222475_v).func_235838_a_(p_235447_0_ -> {
            if (soul) {
                return 10;
            }
            return 15;
        }).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)HANGING, (Comparable)Boolean.FALSE)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (Boolean)state.func_177229_b((Property)HANGING) != false ? SHAPE_HANGING : SHAPE;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        for (Direction direction : context.func_196009_e()) {
            BlockState blockstate;
            if (direction.func_176740_k() != Direction.Axis.Y || !(blockstate = (BlockState)this.func_176223_P().func_206870_a((Property)HANGING, (Comparable)Boolean.valueOf(direction == Direction.UP))).func_196955_c((IWorldReader)context.func_195991_k(), context.func_195995_a())) continue;
            return (BlockState)((BlockState)blockstate.func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a));
        }
        return null;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        Direction direction = SkinnedLanternBlock.func_220277_j(state).func_176734_d();
        return Block.func_220055_a((IWorldReader)worldIn, (BlockPos)pos.func_177972_a(direction), (Direction)direction.func_176734_d());
    }

    protected static Direction func_220277_j(BlockState p_220277_0_) {
        return (Boolean)p_220277_0_.func_177229_b((Property)HANGING) != false ? Direction.DOWN : Direction.UP;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return SkinnedLanternBlock.func_220277_j(stateIn).func_176734_d() == facing && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, HANGING, WATERLOGGED});
    }

    public float func_220080_a(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 1.0f;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }
}

