/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.client.gui;

import com.cazsius.solcarrot.SOLCarrotConfig;
import com.cazsius.solcarrot.client.FoodItems;
import com.cazsius.solcarrot.client.gui.FoodBookScreen;
import com.cazsius.solcarrot.client.gui.FoodData;
import com.cazsius.solcarrot.client.gui.Page;
import com.cazsius.solcarrot.client.gui.elements.UIElement;
import com.cazsius.solcarrot.client.gui.elements.UIImage;
import com.cazsius.solcarrot.lib.Localization;
import com.cazsius.solcarrot.tracking.FoodInstance;
import java.awt.Rectangle;

final class ConfigInfoPage
extends Page {
    ConfigInfoPage(FoodData foodData, Rectangle frame) {
        super(frame, Localization.localized("gui", "food_book.config", new Object[0]));
        int totalFoods = FoodItems.getAllFoods().size();
        int validFoods = foodData.validFoods.size();
        int cheapFoods = totalFoods - validFoods;
        int eatenCheapFoods = (int)foodData.foodList.getEatenFoods().stream().map(FoodInstance::getItem).filter(food -> SOLCarrotConfig.isAllowed(food) && !SOLCarrotConfig.isHearty(food)).count();
        UIImage drumstickIcon = this.icon(FoodBookScreen.drumstickImage);
        int minValue = SOLCarrotConfig.getMinimumFoodValue();
        String minValueDesc = "" + minValue / 2;
        if (minValue % 2 == 1) {
            minValueDesc = minValueDesc + ".5";
        }
        UIElement minValueStat = this.statWithIcon(drumstickIcon, minValueDesc, Localization.localized("gui", "food_book.config.minimum_food_value", new Object[0]));
        minValueStat.tooltip = Localization.localized("gui", "food_book.config.tooltip.minimum_food_value", new Object[0]);
        this.mainStack.addChild(minValueStat);
        UIImage cheapIcon = this.icon(FoodBookScreen.spiderEyeImage);
        cheapIcon.setWidth(12);
        UIElement cheapStat = this.statWithIcon(cheapIcon, this.fraction(eatenCheapFoods, cheapFoods), Localization.localized("gui", "food_book.config.eaten_cheap_foods", new Object[0]));
        cheapStat.tooltip = Localization.localized("gui", "food_book.config.tooltip.eaten_cheap_foods", cheapFoods, eatenCheapFoods);
        this.mainStack.addChild(cheapStat);
        this.mainStack.addChild(this.makeSeparatorLine());
        boolean hasWhitelist = SOLCarrotConfig.hasWhitelist();
        String listKey = hasWhitelist ? "whitelist" : "blacklist";
        UIImage listIcon = this.icon(hasWhitelist ? FoodBookScreen.whitelistImage : FoodBookScreen.blacklistImage);
        int allFoods = FoodItems.getAllFoodsIgnoringBlacklist().size();
        int allowedFoods = FoodItems.getAllFoods().size();
        String fraction = hasWhitelist ? this.fraction(allowedFoods, allFoods) : this.fraction(allFoods - allowedFoods, allFoods);
        UIElement listStat = this.statWithIcon(listIcon, fraction, Localization.localized("gui", "food_book.config." + listKey, new Object[0]));
        listStat.tooltip = Localization.localized("gui", "food_book.config.tooltip." + listKey, new Object[0]);
        this.mainStack.addChild(listStat);
        this.mainStack.addChild(this.makeSeparatorLine());
        this.updateMainStack();
    }
}

