/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.client.gui;

import com.cazsius.solcarrot.SOLCarrotConfig;
import com.cazsius.solcarrot.client.gui.FoodBookScreen;
import com.cazsius.solcarrot.client.gui.FoodData;
import com.cazsius.solcarrot.client.gui.Page;
import com.cazsius.solcarrot.client.gui.ProgressGraph;
import com.cazsius.solcarrot.client.gui.elements.UIBox;
import com.cazsius.solcarrot.lib.Localization;
import com.cazsius.solcarrot.tracking.ProgressInfo;
import java.awt.Color;
import java.awt.Rectangle;

final class StatListPage
extends Page {
    StatListPage(FoodData foodData, Rectangle frame) {
        super(frame, Localization.localized("gui", "food_book.stats", new Object[0]));
        ProgressInfo progressInfo = foodData.progressInfo;
        ProgressGraph progressGraph = new ProgressGraph(foodData, this.getCenterX(), (int)this.mainStack.frame.getMinY() + 43);
        this.children.add(progressGraph);
        this.mainStack.addChild(new UIBox(progressGraph.frame, new Color(0, 0, 0, 0)));
        this.mainStack.addChild(this.makeSeparatorLine());
        String foodsTasted = SOLCarrotConfig.shouldShowUneatenFoods() ? this.fraction(progressInfo.foodsEaten, foodData.validFoods.size()) : "" + progressInfo.foodsEaten;
        this.mainStack.addChild(this.statWithIcon(this.icon(FoodBookScreen.carrotImage), foodsTasted, Localization.localized("gui", "food_book.stats.foods_tasted", new Object[0])));
        this.mainStack.addChild(this.makeSeparatorLine());
        int heartsPerMilestone = SOLCarrotConfig.getHeartsPerMilestone();
        String heartsGained = this.fraction(heartsPerMilestone * progressInfo.milestonesAchieved(), heartsPerMilestone * SOLCarrotConfig.getMilestoneCount());
        this.mainStack.addChild(this.statWithIcon(this.icon(FoodBookScreen.heartImage), heartsGained, Localization.localized("gui", "food_book.stats.hearts_gained", new Object[0])));
        this.mainStack.addChild(this.makeSeparatorLine());
        this.updateMainStack();
    }
}

