/*
 * Decompiled with CFR 0.152.
 */
package com.kingrunes.somnia;

import com.kingrunes.somnia.api.capability.CapabilityFatigue;
import com.kingrunes.somnia.common.PacketHandler;
import com.kingrunes.somnia.common.PlayerSleepTickHandler;
import com.kingrunes.somnia.common.SomniaConfig;
import com.kingrunes.somnia.common.compat.CompatModule;
import com.kingrunes.somnia.common.util.TimePeriod;
import com.kingrunes.somnia.server.ForgeEventHandler;
import com.kingrunes.somnia.server.ServerTickHandler;
import com.kingrunes.somnia.server.SomniaCommand;
import com.kingrunes.somnia.setup.IProxy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import org.apache.logging.log4j.Logger;

@Mod(modid="somnia", name="Somnia", dependencies="after:railcraft; after:baubles", acceptedMinecraftVersions="[1.12.2]")
public class Somnia {
    public static final String MOD_ID = "somnia";
    public static final String NAME = "Somnia";
    public final List<ServerTickHandler> tickHandlers = new ArrayList<ServerTickHandler>();
    public final List<WeakReference<EntityPlayerMP>> ignoreList = new ArrayList<WeakReference<EntityPlayerMP>>();
    @Mod.Instance(value="somnia")
    public static Somnia instance;
    @SidedProxy(serverSide="com.kingrunes.somnia.setup.ServerProxy", clientSide="com.kingrunes.somnia.setup.ClientProxy")
    public static IProxy proxy;
    public static Logger logger;
    public static FMLEventChannel eventChannel;
    public static TimePeriod enterSleepPeriod;
    public static TimePeriod validSleepPeriod;
    public static ForgeEventHandler forgeEventHandler;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        logger.info("------ Pre-Init -----");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        logger.info("------ Init -----");
        eventChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(MOD_ID);
        eventChannel.register((Object)new PacketHandler());
        proxy.register();
        MinecraftForge.EVENT_BUS.register((Object)new PlayerSleepTickHandler());
        forgeEventHandler = new ForgeEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)forgeEventHandler);
        CapabilityFatigue.register();
        CompatModule.registerCoffees();
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new SomniaCommand());
    }

    static {
        enterSleepPeriod = new TimePeriod(SomniaConfig.TIMINGS.enterSleepStart, SomniaConfig.TIMINGS.enterSleepEnd);
        validSleepPeriod = new TimePeriod(SomniaConfig.TIMINGS.validSleepStart, SomniaConfig.TIMINGS.validSleepEnd);
    }
}

