/*
 * Decompiled with CFR 0.152.
 */
package com.kingrunes.somnia.asm;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class SClassTransformer
implements IClassTransformer {
    private static final List<String> transformedClasses = Lists.newArrayList((Object[])new String[]{"net.minecraft.client.renderer.EntityRenderer", "net.minecraft.world.WorldServer", "net.minecraft.world.chunk.Chunk", "net.minecraft.server.MinecraftServer", "net.minecraft.entity.player.EntityPlayer"});

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        int index = transformedClasses.indexOf(transformedName);
        boolean obf = !name.equals(transformedName);
        String[] split = transformedName.split("\\.");
        return index > -1 ? this.transform(index, bytes, obf, split[split.length - 1]) : bytes;
    }

    private byte[] transform(int index, byte[] bytes, boolean obf, String className) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        System.out.println("[Somnia Core] Patching class " + className);
        switch (index) {
            case 0: {
                this.patchEntityRenderer(classNode, obf);
                break;
            }
            case 1: {
                this.patchWorldServer(classNode, obf);
                break;
            }
            case 2: {
                this.patchChunk(classNode, obf);
                break;
            }
            case 3: {
                this.patchMinecraftServer(classNode);
                break;
            }
            case 4: {
                this.patchEntityPlayer(classNode, obf);
            }
        }
        ClassWriter cw = new ClassWriter(3);
        classNode.accept((ClassVisitor)cw);
        System.out.println("[Somnia Core] Successfully patched class " + className);
        return cw.toByteArray();
    }

    private void patchEntityPlayer(ClassNode classNode, boolean obf) {
        String methodName = obf ? "a" : "wakeUpPlayer";
        for (MethodNode m : classNode.methods) {
            if (!m.name.equals(methodName) || !m.desc.equals("(ZZZ)V")) continue;
            InsnList insnList = new InsnList();
            LabelNode label9 = new LabelNode();
            insnList.add((AbstractInsnNode)label9);
            insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
            insnList.add((AbstractInsnNode)new MethodInsnNode(184, "com/kingrunes/somnia/common/util/SomniaUtil", "shouldResetSpawn", "(Lnet/minecraft/entity/player/EntityPlayer;)Z", false));
            insnList.add((AbstractInsnNode)new VarInsnNode(54, 3));
            m.instructions.insertBefore(m.instructions.get(0), insnList);
            break;
        }
    }

    private void patchEntityRenderer(ClassNode classNode, boolean obf) {
        String methodName = obf ? "a" : "updateCameraAndRender";
        String methodName2 = obf ? "b" : "renderWorld";
        for (MethodNode m : classNode.methods) {
            if (!m.name.equals(methodName) || !m.desc.equals("(FJ)V")) continue;
            for (AbstractInsnNode ain : m.instructions) {
                if (!(ain instanceof MethodInsnNode)) continue;
                MethodInsnNode min = (MethodInsnNode)ain;
                if (!min.name.equals(methodName2) || !min.desc.equalsIgnoreCase("(FJ)V") || min.getOpcode() != 182) continue;
                min.setOpcode(184);
                min.name = "renderWorld";
                min.owner = "com/kingrunes/somnia/common/util/SomniaUtil";
                VarInsnNode vin = (VarInsnNode)m.instructions.get(m.instructions.indexOf((AbstractInsnNode)min) - 5);
                m.instructions.remove((AbstractInsnNode)vin);
            }
        }
    }

    private void patchWorldServer(ClassNode classNode, boolean obf) {
        String methodTick = obf ? "d" : "tick";
        String methodGetGameRule = obf ? "b" : "getBoolean";
        block0: for (MethodNode m : classNode.methods) {
            if (!m.name.equals(methodTick) || !m.desc.equals("()V")) continue;
            for (AbstractInsnNode ain : m.instructions) {
                if (!(ain instanceof MethodInsnNode)) continue;
                MethodInsnNode min = (MethodInsnNode)ain;
                if (!min.name.equals(methodGetGameRule) || !min.desc.equals("(Ljava/lang/String;)Z")) continue;
                int index = m.instructions.indexOf((AbstractInsnNode)min);
                LdcInsnNode lin = (LdcInsnNode)m.instructions.get(index - 1);
                if (!lin.cst.equals("doMobSpawning")) continue;
                min.setOpcode(184);
                min.desc = "(Lnet/minecraft/world/WorldServer;)Z";
                min.name = "doMobSpawning";
                min.owner = "com/kingrunes/somnia/common/util/SomniaUtil";
                m.instructions.remove((AbstractInsnNode)lin);
                m.instructions.remove(m.instructions.get(index - 2));
                break block0;
            }
        }
    }

    private void patchChunk(ClassNode classNode, boolean obf) {
        String methodName = obf ? "b" : "onTick";
        String methodName2 = obf ? "o" : "checkLight";
        for (MethodNode m : classNode.methods) {
            if (!m.name.equals(methodName) || !m.desc.equals("(Z)V")) continue;
            for (AbstractInsnNode ain : m.instructions) {
                if (!(ain instanceof MethodInsnNode)) continue;
                MethodInsnNode min = (MethodInsnNode)ain;
                if (!min.name.equals(methodName2)) continue;
                min.setOpcode(184);
                min.desc = "(Lnet/minecraft/world/chunk/Chunk;)V";
                min.name = "chunkLightCheck";
                min.owner = "com/kingrunes/somnia/common/util/SomniaUtil";
            }
        }
    }

    private void patchMinecraftServer(ClassNode classNode) {
        for (MethodNode m : classNode.methods) {
            if (!m.name.equals("C") && !m.name.equals("tick") || !m.desc.equals("()V")) continue;
            AbstractInsnNode aInsnNode = null;
            for (AbstractInsnNode ain : m.instructions) {
                if (!(ain instanceof InsnNode) || ain.getOpcode() != 177) continue;
                aInsnNode = ain;
            }
            if (aInsnNode == null) break;
            InsnList toInject = new InsnList();
            toInject.add((AbstractInsnNode)new MethodInsnNode(184, "com/kingrunes/somnia/common/util/SomniaUtil", "tick", "()V", false));
            m.instructions.insertBefore(aInsnNode, toInject);
            break;
        }
    }
}

