/*
 * Decompiled with CFR 0.152.
 */
package com.kingrunes.somnia.client;

import com.kingrunes.somnia.Somnia;
import com.kingrunes.somnia.api.capability.CapabilityFatigue;
import com.kingrunes.somnia.api.capability.IFatigue;
import com.kingrunes.somnia.common.PacketHandler;
import com.kingrunes.somnia.common.SomniaConfig;
import com.kingrunes.somnia.common.StreamUtils;
import com.kingrunes.somnia.common.util.SomniaUtil;
import com.kingrunes.somnia.setup.ClientProxy;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiIngameMenu;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.opengl.GL11;

public class ClientTickHandler {
    private final Minecraft mc = Minecraft.func_71410_x();
    public static final String COLOR = new String(new char[]{'\u00a7'});
    public static final String WHITE = COLOR + "f";
    public static final String RED = COLOR + "c";
    public static final String DARK_RED = COLOR + "4";
    public static final String GOLD = COLOR + "6";
    public static final String TRANSLATION_FORMAT = "somnia.status.%s";
    public static final String SPEED_FORMAT = "%sx%s";
    public static final String ETA_FORMAT = WHITE + "(%s:%s)";
    private static final String FATIGUE_FORMAT = WHITE + "Fatigue: %.2f";
    private boolean moddedFOV = false;
    private float fov = -1.0f;
    private boolean muted = false;
    private float defVol;
    private final ItemStack clockItemStack = new ItemStack(Items.field_151113_aN);
    public long startTicks = -1L;
    public double speed = 0.0;
    private final List<Double> speedValues = new ArrayList<Double>();
    public String status = "Waiting...";

    public ClientTickHandler() {
        NBTTagCompound clockNbt = new NBTTagCompound();
        clockNbt.func_74757_a("quark:clock_calculated", true);
        this.clockItemStack.func_77982_d(clockNbt);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.tickEnd();
        }
    }

    public void readField(DataInputStream in) throws IOException {
        switch (in.readByte()) {
            case 0: {
                this.speed = in.readDouble();
                this.speedValues.add(this.speed);
                if (this.speedValues.size() <= 5) break;
                this.speedValues.remove(0);
                break;
            }
            case 1: {
                String str = StreamUtils.readString(in);
                this.status = str.startsWith("f:") ? new TextComponentTranslation(String.format(TRANSLATION_FORMAT, str.substring(2).toLowerCase()), new Object[0]).func_150261_e() : str;
            }
        }
    }

    public void tickEnd() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            return;
        }
        GameSettings gameSettings = Minecraft.func_71410_x().field_71474_y;
        if (mc.field_71439_g.func_70608_bn()) {
            if (SomniaConfig.OPTIONS.vanillaBugFixes && !this.moddedFOV) {
                this.moddedFOV = true;
                if ((double)gameSettings.field_74334_X >= 0.75352114) {
                    this.fov = gameSettings.field_74334_X;
                    gameSettings.field_74334_X = 0.7253521f;
                }
            }
        } else if (this.moddedFOV) {
            this.moddedFOV = false;
            if (this.fov > 0.0f) {
                Minecraft.func_71410_x().field_71474_y.field_74334_X = this.fov;
            }
        }
        if (mc.field_71439_g.func_70608_bn()) {
            if (SomniaConfig.OPTIONS.muteSoundWhenSleeping && !this.muted) {
                this.muted = true;
                this.defVol = gameSettings.func_186711_a(SoundCategory.MASTER);
                gameSettings.func_186712_a(SoundCategory.MASTER, 0.0f);
            }
        } else if (this.muted) {
            this.muted = false;
            gameSettings.func_186712_a(SoundCategory.MASTER, this.defVol);
        }
        if (ClientProxy.clientAutoWakeTime > -1L && mc.field_71439_g.func_70608_bn() && mc.field_71441_e.func_82737_E() >= ClientProxy.clientAutoWakeTime) {
            ClientProxy.clientAutoWakeTime = -1L;
            Somnia.eventChannel.sendToServer(PacketHandler.buildWakePacket());
        }
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (!(this.mc.field_71462_r == null || this.mc.field_71462_r instanceof GuiIngameMenu || this.mc.field_71439_g != null && this.mc.field_71439_g.func_70608_bn())) {
            return;
        }
        FontRenderer fontRenderer = this.mc.field_71466_p;
        ScaledResolution scaledResolution = new ScaledResolution(this.mc);
        if (event.phase == TickEvent.Phase.END && !this.mc.field_71439_g.field_71075_bZ.field_75098_d && !this.mc.field_71439_g.func_175149_v()) {
            int y;
            int x;
            String param;
            if (!this.mc.field_71439_g.func_70608_bn() && !SomniaConfig.FATIGUE.fatigueSideEffects && ClientProxy.playerFatigue > SomniaConfig.FATIGUE.minimumFatigueToSleep) {
                return;
            }
            IFatigue props = (IFatigue)this.mc.field_71439_g.getCapability(CapabilityFatigue.FATIGUE_CAPABILITY, null);
            String str = SomniaConfig.FATIGUE.simpleFatigueDisplay && props != null ? WHITE + SomniaUtil.translate("somnia.side_effect." + this.getSideEffectStage(ClientProxy.playerFatigue)) : String.format(FATIGUE_FORMAT, ClientProxy.playerFatigue);
            int stringWidth = fontRenderer.func_78256_a(str);
            switch (param = this.mc.field_71439_g.func_70608_bn() ? "br" : SomniaConfig.FATIGUE.displayFatigue.toLowerCase()) {
                case "tc": {
                    x = scaledResolution.func_78326_a() / 2 - stringWidth / 2;
                    y = fontRenderer.field_78288_b;
                    break;
                }
                case "tl": {
                    x = 10;
                    y = fontRenderer.field_78288_b;
                    break;
                }
                case "tr": {
                    x = scaledResolution.func_78326_a() - stringWidth - 10;
                    y = fontRenderer.field_78288_b;
                    break;
                }
                case "bc": {
                    x = scaledResolution.func_78326_a() / 2 - stringWidth / 2;
                    y = scaledResolution.func_78328_b() - fontRenderer.field_78288_b - 45;
                    break;
                }
                case "bl": {
                    x = 10;
                    y = scaledResolution.func_78328_b() - fontRenderer.field_78288_b - 10;
                    break;
                }
                case "br": {
                    x = scaledResolution.func_78326_a() - stringWidth - 10;
                    y = scaledResolution.func_78328_b() - fontRenderer.field_78288_b - 10;
                    break;
                }
                default: {
                    return;
                }
            }
            fontRenderer.func_78276_b(str, x, y, Integer.MIN_VALUE);
        }
        if (this.mc.field_71439_g.func_70608_bn() && SomniaConfig.OPTIONS.somniaGui && ClientProxy.playerFatigue != -1.0) {
            this.renderSleepGui(scaledResolution);
        } else if (this.startTicks != -1L || this.speed != 0.0) {
            this.startTicks = -1L;
            this.speed = 0.0;
        }
    }

    private int getSideEffectStage(double fatigue) {
        if (fatigue < (double)SomniaConfig.SIDE_EFFECTS.sideEffectStage1) {
            return 0;
        }
        if (fatigue < (double)SomniaConfig.SIDE_EFFECTS.sideEffectStage2) {
            return 1;
        }
        if (fatigue < (double)SomniaConfig.SIDE_EFFECTS.sideEffectStage3) {
            return 2;
        }
        if (fatigue < (double)SomniaConfig.SIDE_EFFECTS.sideEffectStage4) {
            return 3;
        }
        return 4;
    }

    private void renderSleepGui(ScaledResolution scaledResolution) {
        boolean currentlySleeping;
        boolean bl = currentlySleeping = this.speed != 0.0;
        if (currentlySleeping) {
            if (this.startTicks == -1L) {
                this.startTicks = this.mc.field_71441_e.func_82737_E();
            }
        } else {
            this.startTicks = -1L;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        if (this.startTicks != -1L && ClientProxy.clientAutoWakeTime != -1L) {
            this.mc.func_110434_K().func_110577_a(Gui.field_110324_m);
            double rel = this.mc.field_71441_e.func_82737_E() - this.startTicks;
            double diff = ClientProxy.clientAutoWakeTime - this.startTicks;
            double progress = rel / diff;
            int x = 20;
            int maxWidth = scaledResolution.func_78326_a() - x * 2;
            GL11.glEnable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
            this.renderProgressBar(x, 10, maxWidth, 1.0);
            GL11.glDisable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.renderProgressBar(x, 10, maxWidth, progress);
            int offsetX = SomniaConfig.FATIGUE.displayETASleep.equals("center") ? scaledResolution.func_78326_a() / 2 - 80 : (SomniaConfig.FATIGUE.displayETASleep.equals("right") ? maxWidth - 160 : 0);
            this.renderScaledString(x + offsetX, 20, 1.5f, SPEED_FORMAT, ClientTickHandler.getColorStringForSpeed(this.speed), this.speed);
            double average = this.speedValues.stream().filter(Objects::nonNull).mapToDouble(Double::doubleValue).summaryStatistics().getAverage();
            long etaTotalSeconds = Math.round((diff - rel) / (average * 20.0));
            long etaSeconds = etaTotalSeconds % 60L;
            long etaMinutes = (etaTotalSeconds - etaSeconds) / 60L;
            this.renderScaledString(x + 50 + 10 + offsetX, 20, 1.5f, ETA_FORMAT, (etaMinutes < 10L ? "0" : "") + etaMinutes, (etaSeconds < 10L ? "0" : "") + etaSeconds);
            this.renderClock(maxWidth - 40, 30, 4.0f);
        }
    }

    private void renderProgressBar(int x, int y, int maxWidth, double progress) {
        int amount = (int)(progress * (double)maxWidth);
        while (amount > 0) {
            if (this.mc.field_71462_r != null) {
                this.mc.field_71462_r.func_73729_b(x, y, 0, 69, Math.min(amount, 180), 5);
            }
            amount -= 180;
            x += 180;
        }
    }

    private void renderScaledString(int x, int y, float scale, String format, Object ... args) {
        if (this.mc.field_71462_r == null) {
            return;
        }
        String str = String.format(format, args);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)20.0f, (float)0.0f);
        GL11.glScalef((float)scale, (float)scale, (float)1.0f);
        this.mc.field_71462_r.func_73731_b(this.mc.field_71466_p, str, 0, 0, Integer.MIN_VALUE);
        GL11.glPopMatrix();
    }

    private void renderClock(int x, int y, float scale) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glScalef((float)scale, (float)scale, (float)1.0f);
        this.mc.func_175599_af().func_184391_a((EntityLivingBase)this.mc.field_71439_g, this.clockItemStack, 0, 0);
        GL11.glPopMatrix();
    }

    public static String getColorStringForSpeed(double speed) {
        if (speed < 8.0) {
            return WHITE;
        }
        if (speed < 20.0) {
            return DARK_RED;
        }
        if (speed < 30.0) {
            return RED;
        }
        return GOLD;
    }
}

