/*
 * Decompiled with CFR 0.152.
 */
package com.kingrunes.somnia.common;

import com.kingrunes.somnia.Somnia;
import com.kingrunes.somnia.api.capability.CapabilityFatigue;
import com.kingrunes.somnia.api.capability.IFatigue;
import com.kingrunes.somnia.common.StreamUtils;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;

public class PacketHandler {
    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        if (event.getPacket().channel().equals("somnia")) {
            this.onPacket(event.getPacket(), ((NetHandlerPlayServer)event.getHandler()).field_147369_b);
        }
    }

    @SubscribeEvent
    public void onClientPacket(FMLNetworkEvent.ClientCustomPacketEvent event) {
        if (event.getPacket().channel().equals("somnia")) {
            this.onPacket(event.getPacket(), null);
        }
    }

    public void onPacket(FMLProxyPacket packet, EntityPlayerMP player) {
        DataInputStream in = new DataInputStream((InputStream)new ByteBufInputStream(packet.payload()));
        try {
            byte id = in.readByte();
            switch (id) {
                case 0: {
                    this.handleGUIOpenPacket();
                    break;
                }
                case 1: {
                    this.handleWakePacket(player, in);
                    break;
                }
                case 2: {
                    this.handlePropUpdatePacket(in, player);
                    break;
                }
                case 3: {
                    this.handleRightClickBlockPacket(player, in);
                    break;
                }
                case 4: {
                    this.handleRideEntityPacket(player, in);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void handleGUIOpenPacket() {
        Somnia.proxy.handleGUIOpenPacket();
    }

    private void handlePropUpdatePacket(DataInputStream in, @Nullable EntityPlayerMP player) throws IOException {
        if (player == null || player.field_70170_p.field_72995_K) {
            Somnia.proxy.handlePropUpdatePacket(in);
            return;
        }
        byte target = in.readByte();
        IFatigue props = (IFatigue)player.getCapability(CapabilityFatigue.FATIGUE_CAPABILITY, null);
        if (target == 1 && props != null) {
            int b = in.readInt();
            for (int a = 0; a < b; ++a) {
                byte val = in.readByte();
                if (val != 1) continue;
                props.setResetSpawn(in.readBoolean());
            }
        }
    }

    private void handleWakePacket(EntityPlayerMP player, DataInputStream in) {
        Somnia.proxy.handleWakePacket(player);
    }

    private void handleRightClickBlockPacket(EntityPlayerMP player, DataInputStream in) throws IOException {
        BlockPos pos = new BlockPos(in.readInt(), in.readInt(), in.readInt());
        EnumFacing facing = EnumFacing.values()[in.readByte()];
        IBlockState state = player.field_70170_p.func_180495_p(pos);
        state.func_177230_c().func_180639_a(player.field_70170_p, pos, state, (EntityPlayer)player, EnumHand.MAIN_HAND, facing, in.readFloat(), in.readFloat(), in.readFloat());
    }

    private void handleRideEntityPacket(EntityPlayerMP player, DataInputStream in) throws IOException {
        Entity entity = player.field_70170_p.func_73045_a(in.readInt());
        if (entity == null) {
            return;
        }
        player.func_184205_a(entity, true);
    }

    public static FMLProxyPacket buildGUIOpenPacket() {
        return PacketHandler.doBuildGUIOpenPacket();
    }

    private static FMLProxyPacket doBuildGUIOpenPacket() {
        PacketBuffer buffer = PacketHandler.unpooled();
        buffer.writeByte(0);
        return new FMLProxyPacket(buffer, "somnia");
    }

    public static FMLProxyPacket buildWakePacket() {
        return PacketHandler.doBuildWakePacket();
    }

    public static FMLProxyPacket doBuildWakePacket() {
        PacketBuffer buffer = PacketHandler.unpooled();
        buffer.writeByte(1);
        return new FMLProxyPacket(buffer, "somnia");
    }

    public static FMLProxyPacket buildPropUpdatePacket(int target, Object ... fields) {
        PacketBuffer buffer = PacketHandler.unpooled();
        buffer.writeByte(2);
        buffer.writeByte(target);
        buffer.writeInt(fields.length / 2);
        for (int i = 0; i < fields.length; ++i) {
            buffer.writeByte(((Integer)fields[i]).intValue());
            StreamUtils.writeObject(fields[++i], buffer);
        }
        return new FMLProxyPacket(buffer, "somnia");
    }

    public static FMLProxyPacket buildRightClickBlockPacket(BlockPos pos, EnumFacing side, float x, float y, float z) {
        PacketBuffer buffer = PacketHandler.unpooled();
        buffer.writeByte(3);
        buffer.writeInt(pos.func_177958_n());
        buffer.writeInt(pos.func_177956_o());
        buffer.writeInt(pos.func_177952_p());
        buffer.writeByte(side.ordinal());
        buffer.writeFloat(x);
        buffer.writeFloat(y);
        buffer.writeFloat(z);
        return new FMLProxyPacket(buffer, "somnia");
    }

    public static FMLProxyPacket buildRideEntityPacket(Entity entity) {
        PacketBuffer buffer = PacketHandler.unpooled();
        buffer.writeByte(4);
        buffer.writeInt(entity.func_145782_y());
        return new FMLProxyPacket(buffer, "somnia");
    }

    private static PacketBuffer unpooled() {
        return new PacketBuffer(Unpooled.buffer());
    }
}

