/*
 * Decompiled with CFR 0.152.
 */
package com.kingrunes.somnia.common;

import com.kingrunes.somnia.api.capability.CapabilityFatigue;
import com.kingrunes.somnia.api.capability.IFatigue;
import com.kingrunes.somnia.common.SomniaConfig;
import com.kingrunes.somnia.common.compat.CompatModule;
import com.kingrunes.somnia.common.util.InvUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class PlayerSleepTickHandler {
    public static State clientState = new State();
    public static State serverState = new State();

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        State state;
        State state2 = state = event.side == Side.CLIENT ? clientState : serverState;
        if (event.phase == TickEvent.Phase.START) {
            this.tickStart(state, event.player);
        } else {
            this.tickEnd(state, event.player);
        }
    }

    public void tickStart(State state, EntityPlayer player) {
        if (player.func_70608_bn()) {
            IFatigue props;
            BlockPos pos = player.field_71081_bT;
            if (player.field_71076_b > 99 && Loader.isModLoaded((String)"darkutils") && InvUtil.hasItem(player, CompatModule.CHARM_SLEEP)) {
                player.field_71076_b = 100;
                state.sleepOverride = false;
                return;
            }
            if (player.hasCapability(CapabilityFatigue.FATIGUE_CAPABILITY, null) && (props = (IFatigue)player.getCapability(CapabilityFatigue.FATIGUE_CAPABILITY, null)).shouldSleepNormally()) {
                state.sleepOverride = false;
                return;
            }
            if (!CompatModule.checkBed(player, pos)) {
                state.sleepOverride = false;
                return;
            }
            state.sleepOverride = true;
            player.field_71083_bS = false;
            if (player.field_70170_p.field_72995_K && SomniaConfig.OPTIONS.fading) {
                int sleepTimer = player.func_71060_bI() + 1;
                if (sleepTimer >= 99) {
                    sleepTimer = 98;
                }
                player.field_71076_b = sleepTimer;
            }
        }
    }

    public void tickEnd(State state, EntityPlayer player) {
        if (state.sleepOverride) {
            player.field_71083_bS = true;
            state.sleepOverride = false;
        }
    }

    public static class State {
        public boolean sleepOverride = false;
    }
}

