/*
 * Decompiled with CFR 0.152.
 */
package com.kingrunes.somnia.common;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="somnia", category="")
@Config.LangKey(value="somnia.config.title")
@Mod.EventBusSubscriber(modid="somnia")
public class SomniaConfig {
    @Config.LangKey(value="somnia.config.fatigue")
    public static final Fatigue FATIGUE = new Fatigue();
    @Config.Comment(value={"Fatigue levels to enter each side effect stage, their potion IDs, amplifiers and duration (ticks)"})
    @Config.LangKey(value="somnia.config.sideEffects")
    public static final SideEffects SIDE_EFFECTS = new SideEffects();
    @Config.LangKey(value="somnia.config.logic")
    public static final Logic LOGIC = new Logic();
    @Config.LangKey(value="somnia.config.options")
    public static final Options OPTIONS = new Options();
    @Config.LangKey(value="somnia.config.performance")
    public static final Performance PERFORMANCE = new Performance();
    @Config.LangKey(value="somnia.config.timings")
    public static final Timings TIMINGS = new Timings();

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("somnia")) {
            ConfigManager.sync((String)"somnia", (Config.Type)Config.Type.INSTANCE);
        }
    }

    public static class Timings {
        @Config.Comment(value={"Specifies the start of the period in which the player can enter sleep"})
        public int enterSleepStart = 0;
        @Config.Comment(value={"Specifies the end of the period in which the player can enter sleep"})
        public int enterSleepEnd = 24000;
        @Config.Comment(value={"Specifies the start of the valid sleep period"})
        public int validSleepStart = 0;
        @Config.Comment(value={"Specifies the end of the valid sleep period"})
        public int validSleepEnd = 24000;
    }

    public static class Performance {
        @Config.Comment(value={"Disables mob spawning while you sleep"})
        public boolean disableCreatureSpawning = false;
        @Config.Comment(value={"Disabled chunk light checking from being called every tick while you sleep"})
        public boolean disableMoodSoundAndLightCheck = false;
        @Config.Comment(value={"Disable rendering while you're asleep"})
        public boolean disableRendering = false;
    }

    public static class Options {
        @Config.Comment(value={"Slightly slower sleep end"})
        public boolean fading = true;
        @Config.Comment(value={"Let the player sleep even when there are monsters nearby"})
        public boolean ignoreMonsters = false;
        @Config.Comment(value={"Deafens you while you're asleep. Mob sounds are confusing with the world sped up"})
        public boolean muteSoundWhenSleeping = false;
        @Config.Comment(value={"Allows you to sleep with armor equipped"})
        public boolean sleepWithArmor = false;
        @Config.Comment(value={"Provides an enhances sleeping gui"})
        public boolean somniaGui = true;
        @Config.Comment(value={"Applies a very small FOV while sleeping, because a vanilla bug makes you face in a wrong direction when your bed doesn't face north"})
        public boolean vanillaBugFixes = true;
        @Config.Comment(value={"Item used to select wake time"})
        public String wakeTimeSelectItem = "minecraft:clock";
    }

    public static class Logic {
        @Config.RangeDouble(min=1.0, max=50.0)
        @Config.Comment(value={"If the time difference (mc) between multiplied ticking is greater than this, the simulation multiplier is lowered. Otherwise, it's increased. Lowering this number might slow down simulation and improve performance. Don't mess around with it if you don't know what you're doing."})
        public double delta = 50.0;
        @Config.Comment(value={"Minimum tick speed multiplier, activated during sleep"})
        public double baseMultiplier = 1.0;
        @Config.Comment(value={"Maximum tick speed multiplier, activated during sleep"})
        public double multiplierCap = 100.0;
    }

    public static class SideEffects {
        @Config.Comment(value={"Amount of fatigue required to enter the first side effect stage"})
        public int sideEffectStage1 = 70;
        @Config.Comment(value={"Potion effect ID of the first stage"})
        public int sideEffectStage1Potion = 9;
        @Config.Comment(value={"Effect duration of the first stage"})
        public int sideEffectStage1Duration = 150;
        @Config.Comment(value={"Potion effect amplifier of the first stage"})
        public int sideEffectStage1Amplifier = 0;
        @Config.Comment(value={"Amount of fatigue required to enter the second side effect stage"})
        public int sideEffectStage2 = 80;
        @Config.Comment(value={"Potion effect ID of the second stage"})
        public int sideEffectStage2Potion = 2;
        @Config.Comment(value={"Effect duration of the second stage"})
        public int sideEffectStage2Duration = 300;
        @Config.Comment(value={"Potion effect amplifier of the second stage"})
        public int sideEffectStage2Amplifier = 2;
        @Config.Comment(value={"Amount of fatigue required to enter the third side effect stage"})
        public int sideEffectStage3 = 90;
        @Config.Comment(value={"Potion effect ID of the third stage"})
        public int sideEffectStage3Potion = 19;
        @Config.Comment(value={"Effect duration of the third stage"})
        public int sideEffectStage3Duration = 200;
        @Config.Comment(value={"Potion effect amplifier of the third stage"})
        public int sideEffectStage3Amplifier = 1;
        @Config.Comment(value={"Amount of fatigue required to enter the fourth side effect stage"})
        public int sideEffectStage4 = 95;
        @Config.Comment(value={"Potion effect ID of the fourth stage"})
        public int sideEffectStage4Potion = 2;
        @Config.Comment(value={"Potion effect amplifier of the fourth stage"})
        public int sideEffectStage4Amplifier = 3;
    }

    public static class Fatigue {
        @Config.Comment(value={"The fatigue counter's position. Accepted values: tc (top center), tl (top left), tr (top right), bc (bottom center), bl (bottom left), br (bottom right)"})
        public String displayFatigue = "br";
        @Config.Comment(value={"Simplifies the numerical fatigue counter to words"})
        public boolean simpleFatigueDisplay = false;
        @Config.Comment(value={"The ETA and multiplier display position in somnia's sleep gui. Accepted values: right, center, left"})
        public String displayETASleep = "left";
        @Config.Comment(value={"Fatigue is incremented by this number every tick"})
        public double fatigueRate = 0.00208;
        @Config.Comment(value={"Fatigue is decreased by this number while you sleep (every tick)"})
        public double fatigueReplenishRate = 0.00833;
        @Config.Comment(value={"Enables fatigue side effects"})
        public boolean fatigueSideEffects = true;
        @Config.Comment(value={"The required amount of fatigue to sleep"})
        public double minimumFatigueToSleep = 20.0;
    }
}

