/*
 * Decompiled with CFR 0.152.
 */
package com.kingrunes.somnia.common.compat;

import com.kingrunes.somnia.Somnia;
import com.kingrunes.somnia.api.SomniaAPI;
import com.kingrunes.somnia.common.compat.RailcraftPlugin;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class CompatModule {
    public static final ResourceLocation CHARM_SLEEP = new ResourceLocation("darkutils", "charm_sleep");
    public static final ResourceLocation CRYO_CHAMBER = new ResourceLocation("galacticraftplanets", "mars_machine");
    public static final ResourceLocation SLEEPING_BAG = new ResourceLocation("openblocks", "sleeping_bag");

    public static boolean checkBed(EntityPlayer player, BlockPos pos) {
        Entity riding = player.func_184187_bx();
        if (riding != null && RailcraftPlugin.isBedCart(riding)) {
            return true;
        }
        if (pos == null) {
            return false;
        }
        IBlockState state = player.field_70170_p.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block.getRegistryName().equals((Object)CRYO_CHAMBER)) {
            return false;
        }
        ItemStack chest = (ItemStack)player.field_71071_by.field_70460_b.get(2);
        ItemStack currentStack = player.field_71071_by.func_70448_g();
        if (!chest.func_190926_b() && chest.func_77973_b().getRegistryName().equals((Object)SLEEPING_BAG) || !currentStack.func_190926_b() && currentStack.func_77973_b().getRegistryName().equals((Object)SLEEPING_BAG)) {
            return true;
        }
        return block.isBed(state, (IBlockAccess)player.field_70170_p, pos, (Entity)player);
    }

    public static void registerCoffees() {
        Somnia.logger.info("Adding support for various coffees from other mods");
        if (Loader.isModLoaded((String)"coffeespawner")) {
            SomniaAPI.addCoffee(CompatModule.getModItem("coffeespawner", "coffee"), 10.0);
            SomniaAPI.addCoffee(CompatModule.getModItem("coffeespawner", "coffee_milk"), 10.0);
            SomniaAPI.addCoffee(CompatModule.getModItem("coffeespawner", "coffee_sugar"), 15.0);
            SomniaAPI.addCoffee(CompatModule.getModItem("coffeespawner", "coffee_milk_sugar"), 15.0);
        }
        if (Loader.isModLoaded((String)"harvestcraft")) {
            SomniaAPI.addCoffee(CompatModule.getModItem("harvestcraft", "coffeeitem"), 5.0);
            SomniaAPI.addCoffee(CompatModule.getModItem("harvestcraft", "coffeeconlecheitem"), 15.0);
            SomniaAPI.addCoffee(CompatModule.getModItem("harvestcraft", "espressoitem"), 15.0);
        }
        if (Loader.isModLoaded((String)"coffeework")) {
            SomniaAPI.addCoffee(CompatModule.getModItem("coffeework", "coffee_instant"), 10.0);
            SomniaAPI.addCoffee(CompatModule.getModItem("coffeework", "coffee_instant_cup"), 10.0);
            SomniaAPI.addCoffee(CompatModule.getModItem("coffeework", "espresso"), 15.0);
        }
        if (Loader.isModLoaded((String)"ic2")) {
            SomniaAPI.addCoffee(CompatModule.getModItem("ic2", "mug", 1), 5.0);
            SomniaAPI.addCoffee(CompatModule.getModItem("ic2", "mug", 2), 15.0);
            SomniaAPI.addCoffee(CompatModule.getModItem("ic2", "mug", 3), 10.0);
        }
        if (Loader.isModLoaded((String)"actuallyadditions")) {
            SomniaAPI.addCoffee(CompatModule.getModItem("actuallyadditions", "item_coffee"), 10.0);
        }
    }

    public static ItemStack getModItem(String modid, String name) {
        return CompatModule.getModItem(modid, name, 0);
    }

    public static ItemStack getModItem(String modid, String name, int meta) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(modid, name));
        if (item != null) {
            return new ItemStack(item, 1, meta);
        }
        return ItemStack.field_190927_a;
    }
}

