/*
 * Decompiled with CFR 0.152.
 */
package com.kingrunes.somnia.common.util;

import com.kingrunes.somnia.Somnia;
import com.kingrunes.somnia.api.capability.CapabilityFatigue;
import com.kingrunes.somnia.api.capability.IFatigue;
import com.kingrunes.somnia.common.util.ListUtils;
import com.kingrunes.somnia.server.ServerTickHandler;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public enum SomniaState {
    IDLE,
    ACTIVE,
    WAITING_PLAYERS,
    EXPIRED,
    NOT_NOW,
    COOLDOWN;


    public static SomniaState getState(ServerTickHandler handler) {
        long totalWorldTime = handler.worldServer.func_82737_E();
        if (!Somnia.validSleepPeriod.isTimeWithin(totalWorldTime % 24000L)) {
            return NOT_NOW;
        }
        if (handler.worldServer.field_73010_i.isEmpty()) {
            return IDLE;
        }
        List players = handler.worldServer.field_73010_i;
        boolean anySleeping = false;
        boolean allSleeping = true;
        int somniaSleep = 0;
        int normalSleep = 0;
        for (EntityPlayer entityPlayer : players) {
            EntityPlayerMP player = (EntityPlayerMP)entityPlayer;
            boolean sleeping = player.func_70608_bn() || ListUtils.containsRef(player, Somnia.instance.ignoreList);
            anySleeping |= sleeping;
            allSleeping &= sleeping;
            IFatigue props = (IFatigue)player.getCapability(CapabilityFatigue.FATIGUE_CAPABILITY, null);
            if (props != null && props.shouldSleepNormally()) {
                ++normalSleep;
                continue;
            }
            ++somniaSleep;
        }
        if (allSleeping) {
            if (somniaSleep >= normalSleep) {
                return ACTIVE;
            }
        } else if (anySleeping) {
            return WAITING_PLAYERS;
        }
        return IDLE;
    }
}

