/*
 * Decompiled with CFR 0.152.
 */
package com.kingrunes.somnia.common.util;

import com.kingrunes.somnia.Somnia;
import com.kingrunes.somnia.api.capability.CapabilityFatigue;
import com.kingrunes.somnia.api.capability.IFatigue;
import com.kingrunes.somnia.common.SomniaConfig;
import com.kingrunes.somnia.common.compat.CompatModule;
import com.kingrunes.somnia.common.util.SomniaState;
import com.kingrunes.somnia.server.ServerTickHandler;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class SomniaUtil {
    public static String timeStringForWorldTime(long time) {
        time += 6000L;
        int hours = (int)Math.floor((double)(time %= 24000L) / 1000.0);
        int minutes = (int)((double)(time % 1000L) / 1000.0 * 60.0);
        String lsHours = String.valueOf(hours);
        String lsMinutes = String.valueOf(minutes);
        if (lsHours.length() == 1) {
            lsHours = "0" + lsHours;
        }
        if (lsMinutes.length() == 1) {
            lsMinutes = "0" + lsMinutes;
        }
        return lsHours + ":" + lsMinutes;
    }

    public static boolean doesPlayHaveAnyArmor(EntityPlayer player) {
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            if (stack.func_190926_b()) continue;
            return !Loader.isModLoaded((String)"openblocks") || !stack.func_77973_b().getRegistryName().equals((Object)CompatModule.SLEEPING_BAG);
        }
        return false;
    }

    public static long calculateWakeTime(long totalWorldTime, int i) {
        long timeInDay = totalWorldTime % 24000L;
        long l = totalWorldTime - timeInDay + (long)i;
        if (timeInDay > (long)i) {
            l += 24000L;
        }
        return l;
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderWorld(float par1, long par2) {
        if (Minecraft.func_71410_x().field_71439_g.func_70608_bn() && SomniaConfig.PERFORMANCE.disableRendering) {
            GL11.glClear((int)16640);
            return;
        }
        Minecraft.func_71410_x().field_71460_t.func_78471_a(par1, par2);
    }

    public static boolean doMobSpawning(WorldServer par1WorldServer) {
        boolean defValue = par1WorldServer.func_82736_K().func_82766_b("doMobSpawning");
        if (!SomniaConfig.PERFORMANCE.disableCreatureSpawning || !defValue) {
            return defValue;
        }
        for (ServerTickHandler serverTickHandler : Somnia.instance.tickHandlers) {
            if (serverTickHandler.worldServer != par1WorldServer) continue;
            return serverTickHandler.currentState != SomniaState.ACTIVE;
        }
        throw new IllegalStateException("tickHandlers doesn't contain match for given world server");
    }

    public static void chunkLightCheck(Chunk chunk) {
        if (!SomniaConfig.PERFORMANCE.disableMoodSoundAndLightCheck) {
            chunk.func_150809_p();
        }
        for (ServerTickHandler serverTickHandler : Somnia.instance.tickHandlers) {
            if (serverTickHandler.worldServer != chunk.func_177412_p()) continue;
            if (serverTickHandler.currentState != SomniaState.ACTIVE) {
                chunk.func_150809_p();
            }
            return;
        }
        chunk.func_150809_p();
    }

    public static String translate(String key) {
        return I18n.func_74838_a((String)key);
    }

    public static boolean checkFatigue(EntityPlayer player) {
        IFatigue fatigue = (IFatigue)player.getCapability(CapabilityFatigue.FATIGUE_CAPABILITY, null);
        return player.field_71075_bZ.field_75098_d || fatigue == null || fatigue.getFatigue() >= SomniaConfig.FATIGUE.minimumFatigueToSleep;
    }

    public static boolean shouldResetSpawn(EntityPlayer player) {
        IFatigue props = (IFatigue)player.getCapability(CapabilityFatigue.FATIGUE_CAPABILITY, null);
        if (props != null) {
            return props.shouldResetSpawn();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tick() {
        List<ServerTickHandler> list = Somnia.instance.tickHandlers;
        synchronized (list) {
            for (ServerTickHandler serverTickHandler : Somnia.instance.tickHandlers) {
                serverTickHandler.tickStart();
            }
        }
    }

    public static double calculateFatigueToReplenish(EntityPlayer player) {
        long worldTime = player.field_70170_p.func_82737_E();
        long wakeTime = SomniaUtil.calculateWakeTime(worldTime, 0);
        return SomniaConfig.FATIGUE.fatigueReplenishRate * (double)(wakeTime - worldTime);
    }
}

