/*
 * Decompiled with CFR 0.152.
 */
package com.kingrunes.somnia.server;

import com.kingrunes.somnia.Somnia;
import com.kingrunes.somnia.api.SomniaAPI;
import com.kingrunes.somnia.api.capability.CapabilityFatigue;
import com.kingrunes.somnia.api.capability.FatigueCapabilityProvider;
import com.kingrunes.somnia.api.capability.IFatigue;
import com.kingrunes.somnia.client.gui.GuiSelectWakeTime;
import com.kingrunes.somnia.common.PacketHandler;
import com.kingrunes.somnia.common.PlayerSleepTickHandler;
import com.kingrunes.somnia.common.SomniaConfig;
import com.kingrunes.somnia.common.compat.CompatModule;
import com.kingrunes.somnia.common.compat.RailcraftPlugin;
import com.kingrunes.somnia.common.util.InvUtil;
import com.kingrunes.somnia.common.util.SomniaUtil;
import com.kingrunes.somnia.server.ServerTickHandler;
import com.kingrunes.somnia.setup.ClientProxy;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.lang3.tuple.Pair;

public class ForgeEventHandler {
    @SubscribeEvent
    public void onEntityCapabilityAttach(AttachCapabilitiesEvent<Entity> event) {
        event.addCapability(new ResourceLocation("somnia", "fatigue"), (ICapabilityProvider)new FatigueCapabilityProvider());
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        boolean isSleeping;
        if (event.phase != TickEvent.Phase.START || event.player.field_70170_p.field_72995_K || (event.player.field_71075_bZ.field_75098_d || event.player.func_175149_v()) && !event.player.func_70608_bn()) {
            return;
        }
        EntityPlayer player = event.player;
        if (!player.hasCapability(CapabilityFatigue.FATIGUE_CAPABILITY, null)) {
            return;
        }
        IFatigue props = (IFatigue)player.getCapability(CapabilityFatigue.FATIGUE_CAPABILITY, null);
        double fatigue = props.getFatigue();
        boolean bl = isSleeping = PlayerSleepTickHandler.serverState.sleepOverride || player.func_70608_bn();
        fatigue = isSleeping ? (fatigue -= SomniaConfig.FATIGUE.fatigueReplenishRate) : (fatigue += SomniaConfig.FATIGUE.fatigueRate);
        if (fatigue > 100.0) {
            fatigue = 100.0;
        } else if (fatigue < 0.0) {
            fatigue = 0.0;
        }
        props.setFatigue(fatigue);
        if (props.updateFatigueCounter() >= 100) {
            props.resetFatigueCounter();
            Somnia.eventChannel.sendTo(PacketHandler.buildPropUpdatePacket(1, 0, fatigue), (EntityPlayerMP)player);
            if (SomniaConfig.FATIGUE.fatigueSideEffects) {
                int lastSideEffectStage = props.getSideEffectStage();
                if (fatigue > (double)SomniaConfig.SIDE_EFFECTS.sideEffectStage1 && lastSideEffectStage < SomniaConfig.SIDE_EFFECTS.sideEffectStage1) {
                    props.setSideEffectStage(SomniaConfig.SIDE_EFFECTS.sideEffectStage1);
                    player.func_70690_d(new PotionEffect(Potion.func_188412_a((int)SomniaConfig.SIDE_EFFECTS.sideEffectStage1Potion), SomniaConfig.SIDE_EFFECTS.sideEffectStage1Duration, SomniaConfig.SIDE_EFFECTS.sideEffectStage1Amplifier));
                } else if (fatigue > (double)SomniaConfig.SIDE_EFFECTS.sideEffectStage2 && lastSideEffectStage < SomniaConfig.SIDE_EFFECTS.sideEffectStage2) {
                    props.setSideEffectStage(SomniaConfig.SIDE_EFFECTS.sideEffectStage2);
                    player.func_70690_d(new PotionEffect(Potion.func_188412_a((int)SomniaConfig.SIDE_EFFECTS.sideEffectStage2Potion), SomniaConfig.SIDE_EFFECTS.sideEffectStage2Duration, SomniaConfig.SIDE_EFFECTS.sideEffectStage2Amplifier));
                } else if (fatigue > (double)SomniaConfig.SIDE_EFFECTS.sideEffectStage3 && lastSideEffectStage < SomniaConfig.SIDE_EFFECTS.sideEffectStage3) {
                    props.setSideEffectStage(SomniaConfig.SIDE_EFFECTS.sideEffectStage3);
                    player.func_70690_d(new PotionEffect(Potion.func_188412_a((int)SomniaConfig.SIDE_EFFECTS.sideEffectStage3Potion), SomniaConfig.SIDE_EFFECTS.sideEffectStage3Duration, SomniaConfig.SIDE_EFFECTS.sideEffectStage3Amplifier));
                } else if (fatigue > (double)SomniaConfig.SIDE_EFFECTS.sideEffectStage4) {
                    player.func_70690_d(new PotionEffect(Potion.func_188412_a((int)SomniaConfig.SIDE_EFFECTS.sideEffectStage4Potion), 150, SomniaConfig.SIDE_EFFECTS.sideEffectStage4Amplifier));
                } else if (fatigue < (double)SomniaConfig.SIDE_EFFECTS.sideEffectStage1) {
                    props.setSideEffectStage(-1);
                    if (lastSideEffectStage < SomniaConfig.SIDE_EFFECTS.sideEffectStage2) {
                        player.func_184589_d(Potion.func_188412_a((int)SomniaConfig.SIDE_EFFECTS.sideEffectStage2Potion));
                    } else if (lastSideEffectStage < SomniaConfig.SIDE_EFFECTS.sideEffectStage3) {
                        player.func_184589_d(Potion.func_188412_a((int)SomniaConfig.SIDE_EFFECTS.sideEffectStage3Potion));
                    } else if (lastSideEffectStage < SomniaConfig.SIDE_EFFECTS.sideEffectStage4) {
                        player.func_184589_d(Potion.func_188412_a((int)SomniaConfig.SIDE_EFFECTS.sideEffectStage4Potion));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onWakeUp(PlayerWakeUpEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        IFatigue props = (IFatigue)player.getCapability(CapabilityFatigue.FATIGUE_CAPABILITY, null);
        if (props != null) {
            if (props.shouldSleepNormally() && player.field_71076_b == 100) {
                props.setFatigue(props.getFatigue() - SomniaUtil.calculateFatigueToReplenish(player));
            }
            props.maxFatigueCounter();
            props.setResetSpawn(true);
            props.setSleepNormally(false);
        }
        if (player.field_70170_p.field_72995_K) {
            ClientProxy.clientAutoWakeTime = -1L;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSleep(PlayerSleepInBedEvent event) {
        IFatigue props;
        if (event.getResultStatus() == EntityPlayer.SleepResult.OTHER_PROBLEM) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        BlockPos pos = event.getPos();
        IBlockState state = player.field_70170_p.func_175667_e(pos) ? player.field_70170_p.func_180495_p(pos) : null;
        boolean isBed = state != null && state.func_177230_c().isBed(state, (IBlockAccess)player.field_70170_p, pos, (Entity)player);
        EnumFacing enumfacing = isBed && state.func_177230_c() instanceof BlockHorizontal ? (EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D) : null;
        boolean sleepCharm = Loader.isModLoaded((String)"darkutils") && InvUtil.hasItem(player, CompatModule.CHARM_SLEEP);
        boolean sleepNormally = player.func_70093_af();
        if (!player.field_70170_p.field_72995_K) {
            if (player.func_70608_bn() || !player.func_70089_S()) {
                event.setResult(EntityPlayer.SleepResult.OTHER_PROBLEM);
                return;
            }
            if (!player.field_70170_p.field_73011_w.func_76569_d()) {
                event.setResult(EntityPlayer.SleepResult.NOT_POSSIBLE_HERE);
                return;
            }
            if (sleepNormally || sleepCharm) {
                if (!ForgeEventFactory.fireSleepingTimeCheck((EntityPlayer)player, (BlockPos)pos)) {
                    event.setResult(EntityPlayer.SleepResult.NOT_POSSIBLE_NOW);
                    return;
                }
            } else if (!Somnia.enterSleepPeriod.isTimeWithin(24000L)) {
                event.setResult(EntityPlayer.SleepResult.NOT_POSSIBLE_NOW);
                return;
            }
            if (!player.func_190774_a(pos, enumfacing)) {
                event.setResult(EntityPlayer.SleepResult.TOO_FAR_AWAY);
            }
            if (!SomniaUtil.checkFatigue(player)) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("somnia.status.cooldown", new Object[0]), true);
                event.setResult(EntityPlayer.SleepResult.OTHER_PROBLEM);
                return;
            }
            if (!SomniaConfig.OPTIONS.sleepWithArmor && !player.field_71075_bZ.field_75098_d && SomniaUtil.doesPlayHaveAnyArmor(player)) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("somnia.status.armor", new Object[0]), true);
                event.setResult(EntityPlayer.SleepResult.OTHER_PROBLEM);
                return;
            }
            double d0 = 8.0;
            double d1 = 5.0;
            List list = player.field_70170_p.func_175647_a(EntityMob.class, new AxisAlignedBB((double)pos.func_177958_n() - d0, (double)pos.func_177956_o() - d1, (double)pos.func_177952_p() - d0, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d0), m -> m != null && m.func_191990_c(player));
            if (!(list.isEmpty() || SomniaConfig.OPTIONS.ignoreMonsters || player.field_71075_bZ.field_75098_d)) {
                event.setResult(EntityPlayer.SleepResult.NOT_SAFE);
                return;
            }
        }
        if ((props = (IFatigue)player.getCapability(CapabilityFatigue.FATIGUE_CAPABILITY, null)) != null) {
            if (sleepCharm) {
                props.setFatigue(props.getFatigue() - SomniaUtil.calculateFatigueToReplenish(player));
            } else if (sleepNormally) {
                props.setSleepNormally(true);
            }
        }
        if (player.func_184218_aH() && !RailcraftPlugin.isBedCart(player.func_184187_bx())) {
            player.func_184210_p();
        }
        player.func_192030_dh();
        player.func_70105_a(0.2f, 0.2f);
        if (enumfacing != null) {
            float f1 = 0.5f + (float)enumfacing.func_82601_c() * 0.4f;
            float f = 0.5f + (float)enumfacing.func_82599_e() * 0.4f;
            player.func_175139_a(enumfacing);
            player.func_70107_b((double)((float)pos.func_177958_n() + f1), (double)((float)pos.func_177956_o() + 0.6875f), (double)((float)pos.func_177952_p() + f));
        } else {
            player.func_70107_b((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.6875f), (double)((float)pos.func_177952_p() + 0.5f));
        }
        player.field_71083_bS = true;
        player.field_71076_b = 0;
        player.field_71081_bT = pos;
        player.field_70159_w = 0.0;
        player.field_70181_x = 0.0;
        player.field_70179_y = 0.0;
        if (!player.field_70170_p.field_72995_K) {
            player.field_70170_p.func_72854_c();
        }
        Somnia.proxy.updateWakeTime(player);
        event.setResult(EntityPlayer.SleepResult.OK);
    }

    @SubscribeEvent
    public void worldLoadHook(WorldEvent.Load event) {
        if (event.getWorld() instanceof WorldServer) {
            WorldServer worldServer = (WorldServer)event.getWorld();
            Somnia.instance.tickHandlers.add(new ServerTickHandler(worldServer));
            Somnia.logger.info("Registering tick handler for loading world!");
        }
    }

    @SubscribeEvent
    public void worldUnloadHook(WorldEvent.Unload event) {
        if (event.getWorld() instanceof WorldServer) {
            WorldServer worldServer = (WorldServer)event.getWorld();
            Iterator<ServerTickHandler> iter = Somnia.instance.tickHandlers.iterator();
            while (iter.hasNext()) {
                ServerTickHandler serverTickHandler = iter.next();
                if (serverTickHandler.worldServer != worldServer) continue;
                Somnia.logger.info("Removing tick handler for unloading world!");
                iter.remove();
                break;
            }
        }
    }

    @SubscribeEvent
    public void interactHook(PlayerInteractEvent event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        EntityPlayer player = event.getEntityPlayer();
        if ((event instanceof PlayerInteractEvent.RightClickBlock && CompatModule.checkBed(player, pos) || event instanceof PlayerInteractEvent.EntityInteractSpecific && RailcraftPlugin.isBedCart(((PlayerInteractEvent.EntityInteractSpecific)event).getTarget())) && player.func_190774_a(pos, null)) {
            ItemStack currentItem = player.field_71071_by.func_70448_g();
            ResourceLocation registryName = currentItem.func_77973_b().getRegistryName();
            if (!currentItem.func_190926_b() && registryName != null && registryName.toString().equals(SomniaConfig.OPTIONS.wakeTimeSelectItem)) {
                if (world.field_72995_K) {
                    Minecraft minecraft = Minecraft.func_71410_x();
                    if (minecraft.field_71462_r instanceof GuiSelectWakeTime) {
                        return;
                    }
                } else {
                    Somnia.eventChannel.sendTo(PacketHandler.buildGUIOpenPacket(), (EntityPlayerMP)player);
                }
                event.setCancellationResult(EnumActionResult.SUCCESS);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onLivingEntityUseItem(LivingEntityUseItemEvent.Finish event) {
        ItemStack stack = event.getItem();
        if (stack.func_77975_n() == EnumAction.DRINK) {
            for (Pair<ItemStack, Double> pair : SomniaAPI.getCoffeeList()) {
                EntityLivingBase entity;
                IFatigue props;
                if (!((ItemStack)pair.getLeft()).func_77969_a(stack) || (props = (IFatigue)(entity = event.getEntityLiving()).getCapability(CapabilityFatigue.FATIGUE_CAPABILITY, null)) == null) continue;
                props.setFatigue(props.getFatigue() - (Double)pair.getRight());
                props.maxFatigueCounter();
            }
        }
    }

    @SubscribeEvent
    public void onPlayerDamage(LivingHurtEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayerMP) {
            if (!event.getEntityLiving().func_70608_bn()) {
                return;
            }
            Somnia.eventChannel.sendTo(PacketHandler.buildWakePacket(), (EntityPlayerMP)event.getEntityLiving());
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        NBTTagCompound old = (NBTTagCompound)((IFatigue)event.getOriginal().getCapability(CapabilityFatigue.FATIGUE_CAPABILITY, null)).serializeNBT();
        ((IFatigue)event.getEntityPlayer().getCapability(CapabilityFatigue.FATIGUE_CAPABILITY, null)).deserializeNBT((NBTBase)old);
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        this.sync(event.player);
    }

    @SubscribeEvent
    public void onPlayerDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        this.sync(event.player);
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        this.sync(event.player);
    }

    private void sync(EntityPlayer player) {
        if (!player.hasCapability(CapabilityFatigue.FATIGUE_CAPABILITY, null) || !(player instanceof EntityPlayerMP)) {
            return;
        }
        Somnia.eventChannel.sendTo(PacketHandler.buildPropUpdatePacket(1, 0, ((IFatigue)player.getCapability(CapabilityFatigue.FATIGUE_CAPABILITY, null)).getFatigue()), (EntityPlayerMP)player);
    }
}

