/*
 * Decompiled with CFR 0.152.
 */
package com.kingrunes.somnia.server;

import com.kingrunes.somnia.Somnia;
import com.kingrunes.somnia.common.PacketHandler;
import com.kingrunes.somnia.common.SomniaConfig;
import com.kingrunes.somnia.common.util.SomniaState;
import com.kingrunes.somnia.common.util.SomniaUtil;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketTimeUpdate;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;

public class ServerTickHandler {
    public static final String TRANSLATION_FORMAT = "somnia.status.%s";
    private static int activeTickHandlers = 0;
    public WorldServer worldServer;
    public SomniaState currentState;
    public long lastSleepStart;
    public long currentSleepPeriod;
    public long checkTimer = 0L;
    public long lastTpsMillis = 0L;
    public long liTps = 0L;
    public long tps = 0L;
    private double multiplier;
    private double overflow;

    public ServerTickHandler(WorldServer worldServer) {
        this.multiplier = SomniaConfig.LOGIC.baseMultiplier;
        this.overflow = 0.0;
        this.worldServer = worldServer;
    }

    public void tickStart() {
        if (++this.checkTimer == 10L) {
            this.checkTimer = 0L;
            SomniaState prevState = this.currentState;
            this.currentState = SomniaState.getState(this);
            if (prevState != this.currentState) {
                this.currentSleepPeriod = 0L;
                if (this.currentState == SomniaState.ACTIVE) {
                    this.lastSleepStart = this.worldServer.func_82737_E();
                    ++activeTickHandlers;
                } else if (prevState == SomniaState.ACTIVE) {
                    --activeTickHandlers;
                    if (this.currentState == SomniaState.EXPIRED || this.currentState == SomniaState.NOT_NOW) {
                        this.closeGuiWithMessage(this.currentState.toString());
                    }
                }
            }
            if (this.currentState == SomniaState.ACTIVE || this.currentState == SomniaState.WAITING_PLAYERS || this.currentState == SomniaState.COOLDOWN) {
                FMLProxyPacket packet = PacketHandler.buildPropUpdatePacket(0, 0, this.currentState == SomniaState.ACTIVE ? (double)this.tps / 20.0 : 0.0, 1, this.currentState == SomniaState.ACTIVE ? SomniaUtil.timeStringForWorldTime(this.worldServer.func_72820_D()) : "f:" + this.currentState.toString());
                Somnia.eventChannel.sendToDimension(packet, this.worldServer.field_73011_w.getDimension());
            }
        }
        if (this.currentState == SomniaState.ACTIVE) {
            this.doMultipliedTicking();
        }
    }

    private void closeGuiWithMessage(@Nullable String key) {
        FMLProxyPacket packet = PacketHandler.buildWakePacket();
        for (EntityPlayer ep : this.worldServer.field_73010_i) {
            if (!ep.func_70608_bn()) continue;
            Somnia.eventChannel.sendTo(packet, (EntityPlayerMP)ep);
            if (ep.func_70608_bn()) {
                ep.func_70999_a(false, true, true);
            }
            if (key == null) continue;
            ep.func_145747_a((ITextComponent)new TextComponentTranslation(String.format(TRANSLATION_FORMAT, key), new Object[0]));
        }
    }

    private void incrementCounters() {
        ++this.liTps;
        ++this.currentSleepPeriod;
    }

    private void doMultipliedTicking() {
        long currentTimeMillis;
        double target = this.multiplier + this.overflow;
        int liTarget = (int)Math.floor(target);
        this.overflow = target - (double)liTarget;
        long delta = System.currentTimeMillis();
        for (int i = 0; i < liTarget; ++i) {
            this.doMultipliedServerTicking();
        }
        delta = System.currentTimeMillis() - delta;
        MinecraftServer server = this.worldServer.func_73046_m();
        if (server == null) {
            return;
        }
        server.func_184103_al().func_148537_a((Packet)new SPacketTimeUpdate(this.worldServer.func_82737_E(), this.worldServer.func_72820_D(), this.worldServer.func_82736_K().func_82766_b("doDaylightCycle")), this.worldServer.field_73011_w.getDimension());
        this.multiplier = (double)delta > SomniaConfig.LOGIC.delta / (double)activeTickHandlers ? (this.multiplier -= 0.1) : (this.multiplier += 0.1);
        if (this.multiplier > SomniaConfig.LOGIC.multiplierCap) {
            this.multiplier = SomniaConfig.LOGIC.multiplierCap;
        }
        if (this.multiplier < SomniaConfig.LOGIC.baseMultiplier) {
            this.multiplier = SomniaConfig.LOGIC.baseMultiplier;
        }
        if ((currentTimeMillis = System.currentTimeMillis()) - this.lastTpsMillis > 1000L) {
            this.tps = this.liTps;
            this.liTps = 0L;
            this.lastTpsMillis = currentTimeMillis;
        }
    }

    private void doMultipliedServerTicking() {
        FMLCommonHandler.instance().onPreWorldTick((World)this.worldServer);
        this.worldServer.func_72835_b();
        this.worldServer.func_72939_s();
        this.worldServer.func_73039_n().func_72788_a();
        FMLCommonHandler.instance().onPostWorldTick((World)this.worldServer);
        for (Object obj : this.worldServer.field_73010_i) {
            Somnia.forgeEventHandler.onPlayerTick(new TickEvent.PlayerTickEvent(TickEvent.Phase.START, (EntityPlayer)obj));
        }
        this.incrementCounters();
    }
}

