/*
 * Decompiled with CFR 0.152.
 */
package com.kingrunes.somnia.server;

import com.kingrunes.somnia.Somnia;
import com.kingrunes.somnia.api.capability.CapabilityFatigue;
import com.kingrunes.somnia.api.capability.IFatigue;
import com.kingrunes.somnia.common.PacketHandler;
import com.kingrunes.somnia.common.util.ListUtils;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class SomniaCommand
extends CommandBase {
    private static final String COMMAND_NAME = "somnia";
    private static final String COMMAND_USAGE = "[override [add <player> | remove <player> | list]] [fatigue [set <amount> <player>]]";
    private static final String COMMAND_USAGE_CONSOLE = "[override [add [player]|remove [player]|list]] [fatigue [set [amount] [player]]]";
    private static final String COMMAND_USAGE_FORMAT = "/%s %s";

    public String func_71517_b() {
        return COMMAND_NAME;
    }

    public String func_71518_a(ICommandSender sender) {
        return String.format(COMMAND_USAGE_FORMAT, COMMAND_NAME, COMMAND_USAGE);
    }

    public int func_82362_a() {
        return 3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 2) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        if (args[0].equalsIgnoreCase("override")) {
            EntityPlayerMP player;
            if (args.length > 2) {
                player = sender.func_184102_h().func_184103_al().func_152612_a(args[2]);
            } else {
                if (!(sender instanceof EntityPlayerMP)) throw new WrongUsageException(String.format(COMMAND_USAGE_FORMAT, COMMAND_NAME, COMMAND_USAGE_CONSOLE), new Object[0]);
                player = (EntityPlayerMP)sender;
            }
            if (args[1].equalsIgnoreCase("add")) {
                if (ListUtils.containsRef(player, Somnia.instance.ignoreList)) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Override already exists"));
                    return;
                } else {
                    Somnia.instance.ignoreList.add(new WeakReference<EntityPlayerMP>(player));
                }
                return;
            } else if (args[1].equalsIgnoreCase("remove")) {
                Somnia.instance.ignoreList.remove(ListUtils.getWeakRef(player, Somnia.instance.ignoreList));
                return;
            } else {
                if (!args[1].equalsIgnoreCase("list")) throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
                List<EntityPlayerMP> players = ListUtils.extractRefs(Somnia.instance.ignoreList);
                Object[] astring = ListUtils.playersToStringArray(players);
                TextComponentString chatComponent = new TextComponentString(astring.length > 0 ? SomniaCommand.func_71527_a((Object[])astring) : "Nothing to see here...");
                sender.func_145747_a((ITextComponent)chatComponent);
            }
            return;
        } else {
            EntityPlayerMP player;
            if (!args[0].equalsIgnoreCase("fatigue")) return;
            if (args.length > 3) {
                player = sender.func_184102_h().func_184103_al().func_152612_a(args[3]);
            } else {
                if (!(sender instanceof EntityPlayerMP)) throw new WrongUsageException(String.format(COMMAND_USAGE_FORMAT, COMMAND_NAME, COMMAND_USAGE_CONSOLE), new Object[0]);
                player = (EntityPlayerMP)sender;
            }
            if (!args[1].equalsIgnoreCase("set")) throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            IFatigue props = (IFatigue)player.getCapability(CapabilityFatigue.FATIGUE_CAPABILITY, null);
            if (props != null) {
                try {
                    props.setFatigue(Double.parseDouble(args[2]));
                    Somnia.eventChannel.sendTo(PacketHandler.buildPropUpdatePacket(1, 0, props.getFatigue()), player);
                    return;
                }
                catch (NumberFormatException nfe) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Invalid double!"));
                }
                return;
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString("props = null! Weird..."));
            }
        }
    }

    @Nonnull
    private String getSecondLastWord(String[] arr) {
        if (arr.length <= 1) {
            return "";
        }
        return arr[arr.length - 2];
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        String arg = this.getSecondLastWord(args);
        if ("fatigue".equals(arg)) {
            return Collections.singletonList("set");
        }
        if ("override".equals(arg)) {
            return SomniaCommand.func_71530_a((String[])args, (String[])new String[]{"add", "remove", "list"});
        }
        if (args.length == 4 && !arg.equals("list")) {
            return SomniaCommand.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        return args.length < 2 ? SomniaCommand.func_71530_a((String[])args, (String[])new String[]{"fatigue", "override"}) : Collections.emptyList();
    }
}

