/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanshields.compat.jei;

import com.oblivioussp.spartanshields.compat.jei.SpartanShieldsPlugin;
import com.oblivioussp.spartanshields.item.crafting.ShieldBannerRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.BannerItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShieldRecipes;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class ShieldBannerRecipeCategory
implements IRecipeCategory<ShieldRecipes> {
    private static final ResourceLocation RECIPE_GUI_VANILLA = new ResourceLocation("jei", "textures/gui/gui_vanilla.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final String title;

    public ShieldBannerRecipeCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)Items.field_185159_cQ));
        this.background = guiHelper.createDrawable(RECIPE_GUI_VANILLA, 0, 60, 116, 54);
        this.title = I18n.func_135052_a((String)"gui.spartanshields.category.shield_banner", (Object[])new Object[0]);
    }

    public ResourceLocation getUid() {
        return SpartanShieldsPlugin.SHIELD_BANNER_UID;
    }

    public Class<? extends ShieldRecipes> getRecipeClass() {
        return ShieldRecipes.class;
    }

    public String getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(ShieldRecipes recipe, IIngredients ingredients) {
        ItemStack shield = new ItemStack((IItemProvider)Items.field_185159_cQ);
        List<ItemStack> banners = Arrays.asList(Ingredient.func_199805_a((ITag)ItemTags.field_202901_n).func_193365_a());
        if (recipe instanceof ShieldBannerRecipe) {
            ShieldBannerRecipe shieldRecipe = (ShieldBannerRecipe)recipe;
            shield = new ItemStack((IItemProvider)shieldRecipe.getShieldItem());
        }
        ArrayList<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();
        inputs.add(Collections.singletonList(shield));
        inputs.add(banners);
        ingredients.setInputLists(VanillaTypes.ITEM, inputs);
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        for (ItemStack banner : banners) {
            ItemStack banneredShield = shield.func_77946_l();
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74768_a("Base", ((BannerItem)banner.func_77973_b()).func_195948_b().func_196059_a());
            banneredShield.func_196082_o().func_218657_a("BlockEntityTag", (INBT)nbt);
            outputs.add(banneredShield);
        }
        ingredients.setOutputLists(VanillaTypes.ITEM, Collections.singletonList(outputs));
    }

    public void setRecipe(IRecipeLayout recipeLayout, ShieldRecipes recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, false, 94, 18);
        guiItemStacks.init(1, true, 18, 18);
        guiItemStacks.init(2, true, 36, 18);
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        guiItemStacks.set(1, (List)inputs.get(0));
        guiItemStacks.set(2, (List)inputs.get(1));
        guiItemStacks.set(0, (List)outputs.get(0));
        recipeLayout.setShapeless();
        IGuiItemStackGroup group = recipeLayout.getItemStacks();
        group.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (((List)outputs.get(0)).contains(ingredient)) {
                tooltip.add(new TranslationTextComponent("gui.spartanshields.tooltip.shield_banner.any_pattern").func_240701_a_(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.RED}));
            }
        });
    }
}

