/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanshields.enchantment;

import com.oblivioussp.spartanshields.enchantment.EnchantmentSS;
import com.oblivioussp.spartanshields.init.ModSounds;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;

public class PaybackEnchantment
extends EnchantmentSS {
    public static final String NBT_PAYBACK_DMG = "PaybackDamage";

    public PaybackEnchantment(Enchantment.Rarity rarityIn, EquipmentSlotType[] slots) {
        super(rarityIn, EnchantmentSS.TYPE_SHIELD, slots);
        this.setRegistryName("spartanshields", "payback");
    }

    public int func_77321_a(int enchantmentLevel) {
        return 15 + (enchantmentLevel - 1) * 7;
    }

    public int func_223551_b(int enchantmentLevel) {
        return super.func_77321_a(enchantmentLevel) + 50;
    }

    public int func_77325_b() {
        return 4;
    }

    @Override
    public void onUserAttacked(LivingEntity user, Entity attacker, float damage, int level) {
        ItemStack activeStack = user.func_184607_cu();
        if (!activeStack.func_190926_b()) {
            float currentDmg = activeStack.func_196082_o().func_74760_g(NBT_PAYBACK_DMG);
            float maxDmg = this.getMaxDamageCapacity(level);
            float absorbedDmg = damage * this.getAbsorbedDamageRatio();
            currentDmg = MathHelper.func_76131_a((float)(currentDmg + absorbedDmg), (float)0.0f, (float)maxDmg);
            activeStack.func_77978_p().func_74776_a(NBT_PAYBACK_DMG, currentDmg);
            if (currentDmg == maxDmg) {
                user.field_70170_p.func_184148_a((PlayerEntity)null, user.func_226277_ct_(), user.func_226278_cu_(), user.func_226281_cx_(), ModSounds.SHIELD_PAYBACK_CHARGE, user.func_184176_by(), 0.5f, 2.0f);
            }
        }
    }

    protected float getMaxDamageCapacity(int level) {
        return 2.0f * (float)level;
    }

    protected float getAbsorbedDamageRatio() {
        return 0.5f;
    }
}

