/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanshields.item;

import com.oblivioussp.spartanshields.client.ClientHelper;
import com.oblivioussp.spartanshields.item.ShieldBaseItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BannerItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShieldItem;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class BasicShieldItem
extends ShieldBaseItem {
    protected IItemTier material;

    public BasicShieldItem(String unlocName, IItemTier toolMaterial, int defaultMaxDamage, Item.Properties prop) {
        super(unlocName, defaultMaxDamage, prop);
        this.material = toolMaterial;
        if (FMLEnvironment.dist.isClient()) {
            ClientHelper.registerShieldPropertyOverrides(this);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.spartanshields.protection", new Object[]{this.getMaxDamage(stack)}));
        if (!stack.func_190926_b() && stack.func_77942_o() && stack.func_77978_p().func_74764_b("BlockEntityTag")) {
            DyeColor dyeColor = ShieldItem.func_195979_f((ItemStack)stack);
            tooltip.add((ITextComponent)new StringTextComponent(""));
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.spartanshields.has_patterns"));
            tooltip.add((ITextComponent)new TranslationTextComponent(String.format("block.minecraft.%s_banner", dyeColor.name().toLowerCase())).func_240701_a_(new TextFormatting[]{TextFormatting.BOLD, TextFormatting.GRAY}));
            BannerItem.func_185054_a((ItemStack)stack, tooltip);
        }
        this.addEffectsTooltip(stack, worldIn, tooltip, flagIn);
        this.addShieldBashTooltip(stack, worldIn, tooltip, flagIn);
    }

    public int func_77619_b() {
        return this.material.func_200927_e();
    }

    @Override
    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return this.material.func_200924_f().test(repair) || super.func_82789_a(toRepair, repair);
    }
}

