/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanshields.item;

import com.oblivioussp.spartanshields.client.ClientHelper;
import com.oblivioussp.spartanshields.item.IDamageShield;
import com.oblivioussp.spartanshields.item.IItemPoweredFE;
import com.oblivioussp.spartanshields.item.ShieldBaseItem;
import com.oblivioussp.spartanshields.util.Config;
import com.oblivioussp.spartanshields.util.EnergyCapabilityProviderItem;
import com.oblivioussp.spartanshields.util.PowerUnit;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class FEPoweredShieldItem
extends ShieldBaseItem
implements IDamageShield,
IItemPoweredFE {
    public static final String NBT_ENERGY = "Energy";
    protected int energyCapacity;
    protected int maxEnergyReceive;
    protected String modName;
    protected PowerUnit preferredEnergyUnit;

    public FEPoweredShieldItem(String unlocName, int capacity, int maxReceive, String modName, PowerUnit preferredUnit, Item.Properties prop) {
        super(unlocName, 0, prop);
        this.energyCapacity = capacity;
        this.maxEnergyReceive = maxReceive;
        this.modName = modName;
        this.preferredEnergyUnit = preferredUnit;
        if (FMLEnvironment.dist.isClient()) {
            ClientHelper.registerPoweredShieldPropertyOverrides(this);
        }
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(group)) {
            ItemStack fullShield = new ItemStack((IItemProvider)this);
            fullShield.func_196082_o().func_74768_a(NBT_ENERGY, this.energyCapacity);
            subItems.add((Object)new ItemStack((IItemProvider)this));
            subItems.add((Object)fullShield);
        }
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, 0);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        int energy = stack.func_196082_o().func_74762_e(NBT_ENERGY);
        return ((double)this.energyCapacity - (double)energy) / (double)this.energyCapacity;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 6927359;
    }

    @Override
    public int getMaxDamage(ItemStack stack) {
        return this.energyCapacity;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        int energy = stack.func_196082_o().func_74762_e(NBT_ENERGY);
        return energy < this.energyCapacity;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.spartanshields." + this.preferredEnergyUnit.getCapacityTranslationKey(), new Object[]{MathHelper.func_76141_d((float)((float)this.getFEStored(stack) * this.preferredEnergyUnit.getEnergyScaleToFE())), MathHelper.func_76141_d((float)((float)this.getFECapacity(stack) * this.preferredEnergyUnit.getEnergyScaleToFE()))}));
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.spartanshields." + this.preferredEnergyUnit.getEnergyChargeRateTranslationKey(), new Object[]{MathHelper.func_76141_d((float)((float)this.maxEnergyReceive * this.preferredEnergyUnit.getEnergyScaleToFE()))}));
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.spartanshields." + this.preferredEnergyUnit.getEnergyPerDamageTranslationKey(), new Object[]{MathHelper.func_76141_d((float)((float)((Integer)Config.INSTANCE.damageToFEMultiplier.get() * 2) * this.preferredEnergyUnit.getEnergyScaleToFE()))}));
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.spartanshields.fe_shield.desc"));
        this.addShieldBashTooltip(stack, worldIn, tooltip, flagIn);
    }

    public UseAction func_77661_b(ItemStack stack) {
        if (this.getFEStored(stack) > 0) {
            return UseAction.BLOCK;
        }
        return UseAction.NONE;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand hand) {
        playerIn.func_184598_c(hand);
        ItemStack stack = playerIn.func_184586_b(hand);
        if (this.getFEStored(stack) > 0) {
            return ActionResult.func_226249_b_((Object)stack);
        }
        if (worldIn.field_72995_K) {
            playerIn.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + I18n.func_135052_a((String)"message.spartanshields.powered_shield_block_fail", (Object[])new Object[]{stack.func_200301_q().getString()})), Util.field_240973_b_);
        }
        return ActionResult.func_226251_d_((Object)stack);
    }

    @Override
    public void damageShield(ItemStack shieldStack, PlayerEntity player, Entity attacker, float damage) {
        int energyToUse = MathHelper.func_76141_d((float)damage);
        int currentEnergy = shieldStack.func_196082_o().func_74762_e(NBT_ENERGY);
        int energyRemoved = Math.min(energyToUse, currentEnergy);
        shieldStack.func_77978_p().func_74768_a(NBT_ENERGY, currentEnergy -= energyRemoved);
        if (currentEnergy == 0) {
            player.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + player.field_70170_p.field_73012_v.nextFloat() * 0.4f);
        }
    }

    public FEPoweredShieldItem setCapacity(int capacity) {
        this.energyCapacity = capacity;
        return this;
    }

    public FEPoweredShieldItem setMaxReceive(int maxReceive) {
        this.maxEnergyReceive = maxReceive;
        return this;
    }

    @Override
    public int receiveFE(ItemStack container, int maxReceive, boolean simulate) {
        int energy = container.func_196082_o().func_74762_e(NBT_ENERGY);
        int energyReceived = Math.min(this.energyCapacity - energy, Math.min(this.maxEnergyReceive, maxReceive));
        if (!simulate) {
            container.func_77978_p().func_74768_a(NBT_ENERGY, energy += energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int extractFE(ItemStack container, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public int getFEStored(ItemStack container) {
        if (!container.func_196082_o().func_74764_b(NBT_ENERGY)) {
            return 0;
        }
        return container.func_77978_p().func_74762_e(NBT_ENERGY);
    }

    @Override
    public int getFECapacity(ItemStack container) {
        return this.energyCapacity;
    }

    @Override
    public boolean canExtractFE(ItemStack stack) {
        return false;
    }

    @Override
    public boolean canReceiveFE(ItemStack stack) {
        return true;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new EnergyCapabilityProviderItem(stack, this);
    }
}

