/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanshields.network;

import com.oblivioussp.spartanshields.init.ModEnchantments;
import com.oblivioussp.spartanshields.init.ModSounds;
import com.oblivioussp.spartanshields.item.ShieldBaseItem;
import com.oblivioussp.spartanshields.util.Config;
import java.util.function.Supplier;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.network.NetworkEvent;

public class ShieldBashPacket {
    protected Hand hand;
    protected int entityId;
    protected boolean attackEntity = false;

    public ShieldBashPacket(Hand handIn, int entityIdIn, boolean attackEntityIn) {
        this.hand = handIn;
        this.entityId = entityIdIn;
        this.attackEntity = attackEntityIn;
    }

    public static void encode(ShieldBashPacket packet, PacketBuffer buf) {
        buf.func_179249_a((Enum)packet.hand);
        buf.writeInt(packet.entityId);
        buf.writeBoolean(packet.attackEntity);
    }

    public static ShieldBashPacket decode(PacketBuffer buf) {
        return new ShieldBashPacket((Hand)buf.func_179257_a(Hand.class), buf.readInt(), buf.readBoolean());
    }

    public static class Handler {
        public static void handle(ShieldBashPacket packet, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ItemStack shieldStack;
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                Entity victim = player.field_70170_p.func_73045_a(packet.entityId);
                if (player.func_184585_cz() && !(shieldStack = player.func_184586_b(packet.hand)).func_190926_b() && !player.func_184811_cZ().func_185141_a(shieldStack.func_77973_b()) && shieldStack.func_77973_b() instanceof ShieldBaseItem) {
                    if (packet.attackEntity && victim != null && victim instanceof LivingEntity) {
                        int knockLvl = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180313_o, (ItemStack)shieldStack);
                        victim.field_70172_ad = 0;
                        ((LivingEntity)victim).func_233627_a_(1.0f + (float)knockLvl, (double)MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)))));
                        float bashDamage = 1.0f;
                        if (EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.payback, (ItemStack)shieldStack) != 0) {
                            bashDamage += shieldStack.func_196082_o().func_74760_g("PaybackDamage");
                            shieldStack.func_77978_p().func_74776_a("PaybackDamage", 0.0f);
                        }
                        victim.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), bashDamage);
                        shieldStack.func_222118_a(5, (LivingEntity)player, entity -> entity.func_213334_d(packet.hand));
                        int firebrandLvl = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.firebrand, (ItemStack)shieldStack);
                        if (firebrandLvl != 0) {
                            victim.func_70015_d(firebrandLvl == 2 ? 10 : 5);
                        }
                        player.field_70170_p.func_184148_a((PlayerEntity)null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), ModSounds.SHIELD_BASH_HIT, player.func_184176_by(), 1.0f, bashDamage == 1.0f ? 1.0f : 2.0f);
                        player.func_71009_b(victim);
                    } else {
                        player.field_70170_p.func_184148_a((PlayerEntity)null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), ModSounds.SHIELD_BASH_MISS, player.func_184176_by(), 0.5f, 0.01f);
                    }
                    player.func_184597_cx();
                    player.func_184609_a(packet.hand);
                    player.func_184811_cZ().func_185145_a(shieldStack.func_77973_b(), ((Integer)Config.INSTANCE.cooldownShieldBash.get()).intValue());
                }
            });
        }
    }
}

