/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanshields.util;

import com.oblivioussp.spartanshields.init.ModItems;
import com.oblivioussp.spartanshields.item.ShieldBaseItem;
import com.oblivioussp.spartanshields.util.Log;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    protected static boolean hasEventErrorOccured = false;
    public static final String categoryGeneral = "general";
    public static final String categoryVanilla = "vanilla";
    public static final String categoryModdedCommon = "moddedCommon";
    public static final String categoryThermalMods = "moddedThermal";
    public static final String categoryModdedBotania = "moddedBotania";
    public static final String categoryModdedAbyssalcraft = "moddedAbyssalcraft";
    public static final String categoryModdedBWM = "moddedBWM";
    public static final String categoryModdedMekanism = "moddedMekanism";
    public static final String categoryPowered = "moddedPowered";
    public static final Config INSTANCE;
    public static final ForgeConfigSpec CONFIG_SPEC;
    public ForgeConfigSpec.IntValue durabilityWoodShield;
    public ForgeConfigSpec.IntValue durabilityStoneShield;
    public ForgeConfigSpec.IntValue durabilityIronShield;
    public ForgeConfigSpec.IntValue durabilityGoldShield;
    public ForgeConfigSpec.IntValue durabilityDiamondShield;
    public ForgeConfigSpec.IntValue durabilityNetheriteShield;
    public ForgeConfigSpec.IntValue durabilityObsidianShield;
    public ForgeConfigSpec.IntValue durabilityCopperShield;
    public ForgeConfigSpec.IntValue durabilityTinShield;
    public ForgeConfigSpec.IntValue durabilityBronzeShield;
    public ForgeConfigSpec.IntValue durabilitySteelShield;
    public ForgeConfigSpec.IntValue durabilitySilverShield;
    public ForgeConfigSpec.IntValue durabilityLeadShield;
    public ForgeConfigSpec.IntValue durabilityNickelShield;
    public ForgeConfigSpec.IntValue durabilityInvarShield;
    public ForgeConfigSpec.IntValue durabilityConstantanShield;
    public ForgeConfigSpec.IntValue durabilityPlatinumShield;
    public ForgeConfigSpec.IntValue durabilityElectrumShield;
    public ForgeConfigSpec.IntValue durabilityManasteelShield;
    public ForgeConfigSpec.IntValue durabilityTerrasteelShield;
    public ForgeConfigSpec.IntValue durabilityElementiumShield;
    public ForgeConfigSpec.IntValue durabilityOsmiumShield;
    public ForgeConfigSpec.IntValue durabilityLapisLazuliShield;
    public ForgeConfigSpec.IntValue durabilityRefinedGlowstoneShield;
    public ForgeConfigSpec.IntValue durabilityRefinedObsidianShield;
    public ForgeConfigSpec.BooleanValue vanillaOnly;
    public ForgeConfigSpec.BooleanValue forceDisableUncraftableTooltips;
    public ForgeConfigSpec.IntValue cooldownShieldBash;
    public ForgeConfigSpec.BooleanValue disableShieldBash;
    public ForgeConfigSpec.IntValue damageToFEMultiplier;

    Config(ForgeConfigSpec.Builder builder) {
        builder.push(categoryGeneral);
        this.vanillaOnly = builder.comment("Set to true to have only Vanilla-based shields enabled. Note that this removes mod-based Shield recipes from the game!").translation("config.spartanshields.vanillaOnly").define("vanillaOnly", false);
        this.forceDisableUncraftableTooltips = builder.comment("Will force the uncraftable shield tooltip (highlighted in red) that show on some shields to not appear. Useful for modpack makers who wish to change recipes").translation("config.spartanshields.forceDisableUncraftableTooltips").define("forceDisableUncraftableTooltips", false);
        this.cooldownShieldBash = builder.comment("Cooldown period for Shield Bashes").translation("config.spartanshields.cooldownShieldBash").defineInRange("cooldownShieldBash", 30, 1, 1000);
        this.disableShieldBash = builder.comment("Set to true to disable the Shield Bash feature").translation("config.spartanshields.disableShieldBash").define("disableShieldBash", false);
        builder.pop();
        builder.push(categoryVanilla);
        this.durabilityWoodShield = builder.comment("Crude Wooden Shield Durability").translation("config.spartanshields.durabilityWoodShield").defineInRange("durabilityWoodShield", 104, 0, 100000);
        this.durabilityStoneShield = builder.comment("Stone Braced Shield Durability").translation("config.spartanshields.durabilityStoneShield").defineInRange("durabilityStoneShield", 230, 0, 100000);
        this.durabilityIronShield = builder.comment("Iron Plated Shield Durability").translation("config.spartanshields.durabilityIronShield").defineInRange("durabilityIronShield", 538, 0, 100000);
        this.durabilityGoldShield = builder.comment("Gold Gilded Shield Durability").translation("config.spartanshields.durabilityGoldShield").defineInRange("durabilityGoldShield", 192, 0, 100000);
        this.durabilityDiamondShield = builder.comment("Diamond Reinforced Shield Durability").translation("config.spartanshields.durabilityDiamondShield").defineInRange("durabilityDiamondShield", 2560, 0, 100000);
        this.durabilityNetheriteShield = builder.comment("Netherite Strengthened Shield Durability").translation("config.spartanshields.durabilityNetheriteShield").defineInRange("durabilityNetheriteShield", 3554, 0, 100000);
        this.durabilityObsidianShield = builder.comment("Bulky Obsidian Shield Durability").translation("config.spartanshields.durabilityObsidianShield").defineInRange("durabilityObsidianShield", 1600, 0, 100000);
        builder.pop();
        builder.push(categoryModdedCommon);
        this.durabilityCopperShield = builder.comment("Copper Braced Shield Durability").translation("config.spartanshields.durabilityCopperShield").defineInRange("durabilityCopperShield", 400, 0, 100000);
        this.durabilityTinShield = builder.comment("Tin Braced Shield Durability").translation("config.spartanshields.durabilityTinShield").defineInRange("durabilityTinShield", 320, 0, 100000);
        this.durabilityBronzeShield = builder.comment("Bronze Plated Shield Durability").translation("config.spartanshields.durabilityBronzeShield").defineInRange("durabilityBronzeShield", 680, 0, 100000);
        this.durabilitySteelShield = builder.comment("Steel Plated Shield Durability").translation("config.spartanshields.durabilitySteelShield").defineInRange("durabilitySteelShield", 800, 0, 100000);
        this.durabilitySilverShield = builder.comment("Silver Gilded Shield Durability").translation("config.spartanshields.durabilitySilverShield").defineInRange("durabilitySilverShield", 216, 0, 100000);
        this.durabilityLeadShield = builder.comment("Lead Plated Shield Durability").translation("config.spartanshields.durabilityLeadShield").defineInRange("durabilityLeadShield", 480, 0, 100000);
        this.durabilityNickelShield = builder.comment("Nickel Braced Shield Durability").translation("config.spartanshields.durabilityNickelShield").defineInRange("durabilityNickelShield", 420, 0, 100000);
        this.durabilityInvarShield = builder.comment("Invar Plated Shield Durability").translation("config.spartanshields.durabilityInvarShield").defineInRange("durabilityInvarShield", 720, 0, 100000);
        this.durabilityConstantanShield = builder.comment("Constantan Plated Shield Durability").translation("config.spartanshields.durabilityConstantanShield").defineInRange("durabilityConstantanShield", 640, 0, 100000);
        this.durabilityPlatinumShield = builder.comment("Platinum Plated Shield Durability").translation("config.spartanshields.durabilityPlatinumShield").defineInRange("durabilityPlatinumShield", 1536, 0, 100000);
        this.durabilityElectrumShield = builder.comment("Electrum Plated Shield Durability").translation("config.spartanshields.durabilityElectrumShield").defineInRange("durabilityElectrumShield", 320, 0, 100000);
        builder.pop();
        builder.push(categoryModdedBotania);
        this.durabilityManasteelShield = builder.comment("Manasteel Plated Shield Durability").translation("config.spartanshields.durabilityManasteelShield").defineInRange("durabilityManasteelShield", 450, 0, 100000);
        this.durabilityTerrasteelShield = builder.comment("Terrasteel Strengthened Shield Durability").translation("config.spartanshields.durabilityTerrasteelShield").defineInRange("durabilityTerrasteelShield", 2920, 0, 100000);
        this.durabilityElementiumShield = builder.comment("Elementium Plated Shield Durability").translation("config.spartanshields.durabilityElementiumShield").defineInRange("durabilityElementiumShield", 1080, 0, 100000);
        builder.pop();
        builder.push(categoryModdedMekanism);
        this.durabilityOsmiumShield = builder.comment("Osmium Plated Shield Durability").translation("config.spartanshields.durabilityOsmiumShield").defineInRange("durabilityOsmiumShield", 750, 0, 100000);
        this.durabilityLapisLazuliShield = builder.comment("Lapis Lazuli Gilded Shield Durability").translation("config.spartanshields.durabilityLapisLazuliShield").defineInRange("durabilityLapisLazuliShield", 300, 0, 100000);
        this.durabilityRefinedGlowstoneShield = builder.comment("Refined Glowstone Plated Shield Durability").translation("config.spartanshields.durabilityRefinedGlowstoneShield").defineInRange("durabilityRefinedGlowstoneShield", 450, 0, 100000);
        this.durabilityRefinedObsidianShield = builder.comment("Refined Obsidian Refined Shield Durability").translation("config.spartanshields.durabilityRefinedObsidianShield").defineInRange("durabilityRefinedObsidianShield", 3750, 0, 100000);
        builder.pop();
        builder.push(categoryPowered);
        this.damageToFEMultiplier = builder.comment("Damage to FE Multiplier").translation("config.spartanshields.damageToFEMultpier").defineInRange("damageToFEMultpier", 50, 0, 1000000);
        builder.pop();
    }

    @SubscribeEvent
    public static void onConfigLoad(ModConfig.ModConfigEvent ev) {
        Log.info("Loading config " + ev.getConfig().getFileName());
        if (ev.getConfig().getSpec() == CONFIG_SPEC) {
            if (ModItems.shieldWood == null) {
                Log.error("Cannot load durability values for Shields because the Event Bus was shut down before/during registration, preventing Spartan Shields from registering its items! Check your log to see which mod is causing this!");
                hasEventErrorOccured = true;
                return;
            }
            Log.debug("Reloading durability values for Shields!");
            Config.updateMaxDurability(ModItems.shieldWood, (Integer)Config.INSTANCE.durabilityWoodShield.get());
            Config.updateMaxDurability(ModItems.shieldStone, (Integer)Config.INSTANCE.durabilityStoneShield.get());
            Config.updateMaxDurability(ModItems.shieldIron, (Integer)Config.INSTANCE.durabilityIronShield.get());
            Config.updateMaxDurability(ModItems.shieldGold, (Integer)Config.INSTANCE.durabilityGoldShield.get());
            Config.updateMaxDurability(ModItems.shieldDiamond, (Integer)Config.INSTANCE.durabilityDiamondShield.get());
            Config.updateMaxDurability(ModItems.shieldNetherite, (Integer)Config.INSTANCE.durabilityNetheriteShield.get());
            Config.updateMaxDurability(ModItems.shieldObsidian, (Integer)Config.INSTANCE.durabilityObsidianShield.get());
            Config.updateMaxDurability(ModItems.shieldCopper, (Integer)Config.INSTANCE.durabilityCopperShield.get());
            Config.updateMaxDurability(ModItems.shieldTin, (Integer)Config.INSTANCE.durabilityTinShield.get());
            Config.updateMaxDurability(ModItems.shieldBronze, (Integer)Config.INSTANCE.durabilityBronzeShield.get());
            Config.updateMaxDurability(ModItems.shieldSteel, (Integer)Config.INSTANCE.durabilitySteelShield.get());
            Config.updateMaxDurability(ModItems.shieldSilver, (Integer)Config.INSTANCE.durabilitySilverShield.get());
            Config.updateMaxDurability(ModItems.shieldLead, (Integer)Config.INSTANCE.durabilityLeadShield.get());
            Config.updateMaxDurability(ModItems.shieldNickel, (Integer)Config.INSTANCE.durabilityNickelShield.get());
            Config.updateMaxDurability(ModItems.shieldInvar, (Integer)Config.INSTANCE.durabilityInvarShield.get());
            Config.updateMaxDurability(ModItems.shieldConstantan, (Integer)Config.INSTANCE.durabilityConstantanShield.get());
            Config.updateMaxDurability(ModItems.shieldPlatinum, (Integer)Config.INSTANCE.durabilityPlatinumShield.get());
            Config.updateMaxDurability(ModItems.shieldElectrum, (Integer)Config.INSTANCE.durabilityElectrumShield.get());
            Config.updateMaxDurability(ModItems.shieldTowerWood, (Integer)Config.INSTANCE.durabilityWoodShield.get());
            Config.updateMaxDurability(ModItems.shieldTowerStone, (Integer)Config.INSTANCE.durabilityStoneShield.get());
            Config.updateMaxDurability(ModItems.shieldTowerIron, (Integer)Config.INSTANCE.durabilityIronShield.get());
            Config.updateMaxDurability(ModItems.shieldTowerGold, (Integer)Config.INSTANCE.durabilityGoldShield.get());
            Config.updateMaxDurability(ModItems.shieldTowerDiamond, (Integer)Config.INSTANCE.durabilityDiamondShield.get());
            Config.updateMaxDurability(ModItems.shieldTowerObsidian, (Integer)Config.INSTANCE.durabilityObsidianShield.get());
            Config.updateMaxDurability(ModItems.shieldTowerCopper, (Integer)Config.INSTANCE.durabilityCopperShield.get());
            Config.updateMaxDurability(ModItems.shieldTowerTin, (Integer)Config.INSTANCE.durabilityTinShield.get());
            Config.updateMaxDurability(ModItems.shieldTowerBronze, (Integer)Config.INSTANCE.durabilityBronzeShield.get());
            Config.updateMaxDurability(ModItems.shieldTowerSteel, (Integer)Config.INSTANCE.durabilitySteelShield.get());
            Config.updateMaxDurability(ModItems.shieldTowerSilver, (Integer)Config.INSTANCE.durabilitySilverShield.get());
            Config.updateMaxDurability(ModItems.shieldTowerLead, (Integer)Config.INSTANCE.durabilityLeadShield.get());
            Config.updateMaxDurability(ModItems.shieldTowerNickel, (Integer)Config.INSTANCE.durabilityNickelShield.get());
            Config.updateMaxDurability(ModItems.shieldTowerInvar, (Integer)Config.INSTANCE.durabilityInvarShield.get());
            Config.updateMaxDurability(ModItems.shieldTowerConstantan, (Integer)Config.INSTANCE.durabilityConstantanShield.get());
            Config.updateMaxDurability(ModItems.shieldTowerPlatinum, (Integer)Config.INSTANCE.durabilityPlatinumShield.get());
            Config.updateMaxDurability(ModItems.shieldTowerElectrum, (Integer)Config.INSTANCE.durabilityElectrumShield.get());
        }
    }

    public static void updateMaxDurability(ShieldBaseItem item, int value) {
        if (item != null) {
            item.setMaxDamage(value);
        }
    }

    public static boolean hasEventErrorOccured() {
        return hasEventErrorOccured;
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
        CONFIG_SPEC = (ForgeConfigSpec)specPair.getRight();
        INSTANCE = (Config)specPair.getLeft();
    }
}

