/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanshields;

import com.oblivioussp.spartanshields.init.EnchantmentRegistry;
import com.oblivioussp.spartanshields.init.ItemRegistrySS;
import com.oblivioussp.spartanshields.init.RecipeRegistry;
import com.oblivioussp.spartanshields.proxy.CommonProxy;
import com.oblivioussp.spartanshields.util.ConfigHandler;
import com.oblivioussp.spartanshields.util.EventHandlerSS;
import com.oblivioussp.spartanshields.util.LogHelper;
import com.oblivioussp.spartanshields.util.MappingConverterEntry;
import com.oblivioussp.spartanshields.util.ModHelper;
import com.oblivioussp.spartanshields.util.Reference;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

@Mod(modid="spartanshields", name="Spartan Shields", version="1.3", dependencies="", acceptedMinecraftVersions="[1.11.2]", guiFactory="com.oblivioussp.spartanshields.client.gui.GuiFactorySS")
public class ModSpartanShields {
    @Mod.Instance(value="spartanshields")
    public static ModSpartanShields instance;
    @SidedProxy(clientSide="com.oblivioussp.spartanshields.proxy.ClientProxy", serverSide="com.oblivioussp.spartanshields.proxy.ServerProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent ev) {
        LogHelper.info("Starting up Spartan Shields!");
        ConfigHandler.init(ev.getSuggestedConfigurationFile());
        MinecraftForge.EVENT_BUS.register((Object)new ConfigHandler());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerSS());
        ItemRegistrySS.registerItems();
        proxy.preInit(ev);
        LogHelper.debug("Finished preInit phase!");
    }

    @Mod.EventHandler
    public static void init(FMLInitializationEvent ev) {
        RecipeRegistry.addRecipes();
        LogHelper.info("Registering enchantments...");
        EnchantmentRegistry.register();
        proxy.init(ev);
        LogHelper.debug("Finished init phase!");
    }

    @Mod.EventHandler
    public static void postInit(FMLPostInitializationEvent ev) {
        ModHelper.postInit();
        RecipeRegistry.addCompatRecipes();
        proxy.postInit(ev);
        LogHelper.debug("Finished postInit phase!");
    }

    @Mod.EventHandler
    public void missingMappingsEvent(FMLMissingMappingsEvent ev) {
        List mappings = ev.get();
        for (FMLMissingMappingsEvent.MissingMapping mapping : mappings) {
            LogHelper.info(String.format("Missing Mapping: %s - %s - %s", mapping.name, mapping.resourceLocation.toString(), mapping.type.toString()));
            for (MappingConverterEntry entry : Reference.mappings) {
                if (!mapping.name.equalsIgnoreCase(entry.getMappingName())) continue;
                mapping.remap(entry.getItemToConvertTo());
                LogHelper.info(String.format("Mapping: %s successfully converted to item %s", mapping.name, entry.getItemToConvertTo().getRegistryName()));
            }
        }
    }
}

