/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanshields.enchantment;

import com.oblivioussp.spartanshields.enchantment.EnchantmentSS;
import com.oblivioussp.spartanshields.init.EnchantmentRegistry;
import com.oblivioussp.spartanshields.item.ItemShieldBase;
import com.oblivioussp.spartanshields.util.Reference;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;

public class EnchantmentSpikes
extends EnchantmentSS {
    public EnchantmentSpikes(Enchantment.Rarity rarityIn, EntityEquipmentSlot ... slots) {
        super(rarityIn, EnumEnchantmentType.BREAKABLE, slots);
        this.func_77322_b("spikes");
        this.setRegistryName("ssEnchSpikes");
    }

    public int func_77321_a(int enchantmentLevel) {
        return 10 + 20 * (enchantmentLevel - 1);
    }

    public int func_77317_b(int enchantmentLevel) {
        return super.func_77321_a(enchantmentLevel) + 50;
    }

    public int func_77325_b() {
        return 3;
    }

    public boolean func_92089_a(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemShieldBase;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return this.func_92089_a(stack);
    }

    public String func_77320_a() {
        return String.format("enchantment.%s:%s", "spartanshields", this.field_77350_z);
    }

    @Override
    public void onUserAttacked(EntityLivingBase user, Entity attacker, int level) {
        Random random = user.func_70681_au();
        ItemStack itemStack = EnchantmentHelper.func_92099_a((Enchantment)EnchantmentRegistry.enchSpikes, (EntityLivingBase)user);
        ItemStack activeStack = user.func_184607_cu();
        if (activeStack != Reference.STACK_NULL && activeStack == itemStack) {
            if (EnchantmentSpikes.shouldHit(level, random)) {
                if (attacker != null) {
                    attacker.func_70097_a(DamageSource.func_92087_a((Entity)user), (float)EnchantmentSpikes.getDamage(level, random));
                }
                if (itemStack != Reference.STACK_NULL) {
                    itemStack.func_77972_a(9, user);
                }
            } else if (itemStack != Reference.STACK_NULL) {
                itemStack.func_77972_a(3, user);
            }
        }
    }

    public static boolean shouldHit(int level, Random rnd) {
        return level <= 0 ? false : rnd.nextFloat() < 0.2f * (float)level;
    }

    public static int getDamage(int level, Random rnd) {
        if (level == 1) {
            return 2;
        }
        return 2 + rnd.nextInt(level - 1);
    }
}

