/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanshields.item;

import cofh.api.energy.IEnergyContainerItem;
import com.oblivioussp.spartanshields.item.ItemShieldBase;
import com.oblivioussp.spartanshields.util.ConfigHandler;
import com.oblivioussp.spartanshields.util.StringHelper;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemShieldPoweredRF
extends ItemShieldBase
implements IEnergyContainerItem {
    protected int energyCapacity;
    protected int maxEnergyReceive;

    public ItemShieldPoweredRF(String unlocName, int capacity, int maxReceive) {
        super(unlocName);
        this.energyCapacity = capacity;
        this.maxEnergyReceive = maxReceive;
        this.func_185043_a(new ResourceLocation("disabled"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                return stack.func_77978_p().func_74762_e("Energy") <= 0 ? 1.0f : 0.0f;
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item itemIn, CreativeTabs tab, NonNullList<ItemStack> subItems) {
        ItemStack fullShield = new ItemStack(itemIn);
        fullShield.func_77982_d(new NBTTagCompound());
        fullShield.func_77978_p().func_74768_a("Energy", this.energyCapacity);
        subItems.add((Object)new ItemStack(itemIn));
        subItems.add((Object)fullShield);
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, 0);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        int energy = stack.func_77978_p().func_74762_e("Energy");
        return ((double)this.energyCapacity - (double)energy) / (double)this.energyCapacity;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 0xFF6969;
    }

    public int func_77612_l() {
        return this.energyCapacity;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        int energy;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return (energy = stack.func_77978_p().func_74762_e("Energy")) < this.energyCapacity;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        tooltip.add(StringHelper.translateFormattedString("rfPerDamage", "tooltip", ConfigHandler.damageToRFMultiplier * 2));
        tooltip.add(StringHelper.translateString("rfShield.desc", "tooltip"));
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.NONE;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        playerIn.func_184598_c(hand);
        ItemStack stack = playerIn.func_184586_b(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    @Override
    public void damageShield(ItemStack shieldStack, EntityPlayer player, Entity attacker, float damage) {
        int energyToUse = MathHelper.func_76141_d((float)(damage * (float)ConfigHandler.damageToRFMultiplier));
        if (!shieldStack.func_77942_o()) {
            shieldStack.func_77982_d(new NBTTagCompound());
        }
        int currentEnergy = shieldStack.func_77978_p().func_74762_e("Energy");
        int energyRemoved = Math.min(energyToUse, currentEnergy);
        shieldStack.func_77978_p().func_74768_a("Energy", currentEnergy -= energyRemoved);
        if (currentEnergy == 0) {
            player.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + player.field_70170_p.field_73012_v.nextFloat() * 0.4f);
        }
    }

    public ItemShieldPoweredRF setCapacity(int capacity) {
        this.energyCapacity = capacity;
        return this;
    }

    public ItemShieldPoweredRF setMaxReceive(int maxReceive) {
        this.maxEnergyReceive = maxReceive;
        return this;
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (!container.func_77942_o()) {
            container.func_77982_d(new NBTTagCompound());
        }
        int energy = container.func_77978_p().func_74762_e("Energy");
        int energyReceived = Math.min(this.energyCapacity - energy, Math.min(this.maxEnergyReceive, maxReceive));
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        if (container.func_77978_p() == null || !container.func_77978_p().func_74764_b("Energy")) {
            return 0;
        }
        return container.func_77978_p().func_74762_e("Energy");
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return this.energyCapacity;
    }
}

