/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.capability;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class QuiverCapabilityProvider
implements ICapabilitySerializable<CompoundNBT> {
    protected ItemStack quiver;
    protected final ItemStackHandler handler;
    protected final int inventorySize;

    public QuiverCapabilityProvider(ItemStack stack, int invSize, CompoundNBT nbt) {
        this.quiver = stack;
        this.inventorySize = invSize;
        this.handler = new ItemStackHandler(invSize);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.handler).cast();
        }
        return LazyOptional.empty();
    }

    public CompoundNBT serializeNBT() {
        return this.handler.serializeNBT();
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.handler.deserializeNBT(nbt);
    }
}

