/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.client;

import com.oblivioussp.spartanweaponry.client.gui.container.QuiverArrowScreen;
import com.oblivioussp.spartanweaponry.client.gui.container.QuiverBoltScreen;
import com.oblivioussp.spartanweaponry.client.render.entity.ArrowBaseRenderFactory;
import com.oblivioussp.spartanweaponry.client.render.entity.BoltRenderFactory;
import com.oblivioussp.spartanweaponry.client.render.entity.BoomerangRenderFactory;
import com.oblivioussp.spartanweaponry.client.render.entity.JavelinRenderFactory;
import com.oblivioussp.spartanweaponry.client.render.entity.SimpleArrowRenderFactory;
import com.oblivioussp.spartanweaponry.client.render.entity.ThrowingWeaponRenderFactory;
import com.oblivioussp.spartanweaponry.client.render.entity.TomahawkRenderFactory;
import com.oblivioussp.spartanweaponry.entity.projectile.DynamiteEntity;
import com.oblivioussp.spartanweaponry.init.ModContainers;
import com.oblivioussp.spartanweaponry.init.ModEntities;
import com.oblivioussp.spartanweaponry.init.ModItems;
import com.oblivioussp.spartanweaponry.item.HeavyCrossbowItem;
import com.oblivioussp.spartanweaponry.item.LongbowItem;
import com.oblivioussp.spartanweaponry.item.QuiverBaseItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.SpriteRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

@OnlyIn(value=Dist.CLIENT)
public class ClientHelper {
    public static void registerItemRenders() {
        ClientHelper.registerTippedProjectile((Item)ModItems.tippedArrowWood);
        ClientHelper.registerTippedProjectile((Item)ModItems.tippedArrowIron);
        ClientHelper.registerTippedProjectile((Item)ModItems.tippedArrowDiamond);
        ClientHelper.registerTippedProjectile(ModItems.tippedBolt);
        ClientHelper.registerTippedProjectile(ModItems.tippedBoltDiamond);
    }

    public static void registerHeavyCrossbowPropertyOverrides(HeavyCrossbowItem crossbow) {
        ItemModelsProperties.func_239418_a_((Item)crossbow, (ResourceLocation)new ResourceLocation("pull"), (stack, world, living) -> {
            if (living != null) {
                return crossbow.isLoaded(stack) ? 0.0f : (float)crossbow.getLoadingTicks(stack, living) / (float)crossbow.getFullLoadTicks(stack);
            }
            return 0.0f;
        });
        ItemModelsProperties.func_239418_a_((Item)crossbow, (ResourceLocation)new ResourceLocation("pulling"), (stack, world, living) -> living != null && living.func_184587_cr() && living.func_184607_cu() == stack ? 1.0f : 0.0f);
        ItemModelsProperties.func_239418_a_((Item)crossbow, (ResourceLocation)new ResourceLocation("charged"), (stack, world, living) -> crossbow.isLoaded(stack) ? 1.0f : 0.0f);
    }

    public static void registerLongbowPropertyOverrides(LongbowItem longbow) {
        ItemModelsProperties.func_239418_a_((Item)longbow, (ResourceLocation)new ResourceLocation("pulling"), (stack, world, living) -> living != null && living.func_184587_cr() && living.func_184607_cu() == stack ? 1.0f : 0.0f);
        ItemModelsProperties.func_239418_a_((Item)longbow, (ResourceLocation)new ResourceLocation("pull"), (stack, world, shooter) -> shooter != null && shooter.func_184607_cu() == stack ? longbow.getNockProgress(stack, shooter) : 0.0f);
    }

    public static void registerThrowingWeaponPropertyOverrides(Item throwingWeapon) {
        ItemModelsProperties.func_239418_a_((Item)throwingWeapon, (ResourceLocation)new ResourceLocation("throwing"), (stack, world, living) -> {
            if (living == null || !stack.func_77969_a(living.func_184607_cu())) {
                return 0.0f;
            }
            return living.func_184605_cv() > 0 ? 1.0f : 0.0f;
        });
    }

    public static void registerQuiverPropertyOverrides(QuiverBaseItem quiver) {
        ItemModelsProperties.func_239418_a_((Item)quiver, (ResourceLocation)new ResourceLocation("arrow"), (stack, world, living) -> quiver.getAmmoCount(stack));
    }

    public static void registerTippedProjectile(Item arrow) {
        Minecraft.func_71410_x().getItemColors().func_199877_a((stack, idx) -> idx == 1 ? PotionUtils.func_190932_c((ItemStack)stack) : 0xFFFFFF, new IItemProvider[]{arrow});
    }

    public static void registerEntityRenders() {
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.ARROW_SW, new ArrowBaseRenderFactory());
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.ARROW_EXPLOSIVE, new SimpleArrowRenderFactory("textures/entity/projectiles/arrow_explosive.png"));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.BOLT, new BoltRenderFactory());
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.BOLT_SPECTRAL, new BoltRenderFactory());
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.THROWING_WEAPON, new ThrowingWeaponRenderFactory());
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.TOMAHAWK, new TomahawkRenderFactory());
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.JAVELIN, new JavelinRenderFactory());
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.BOOMERANG, (IRenderFactory)new BoomerangRenderFactory());
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.DYNAMITE, (IRenderFactory)new IRenderFactory<DynamiteEntity>(){

            public EntityRenderer<? super DynamiteEntity> createRenderFor(EntityRendererManager manager) {
                return new SpriteRenderer(manager, Minecraft.func_71410_x().func_175599_af());
            }
        });
    }

    public static void registerScreens() {
        ScreenManager.func_216911_a(ModContainers.QUIVER_ARROW, QuiverArrowScreen::new);
        ScreenManager.func_216911_a(ModContainers.QUIVER_BOLT, QuiverBoltScreen::new);
    }
}

