/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.event;

import com.oblivioussp.spartanweaponry.api.IWeaponTraitContainer;
import com.oblivioussp.spartanweaponry.api.trait.IMeleeTraitCallback;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import com.oblivioussp.spartanweaponry.entity.projectile.ThrowingWeaponEntity;
import com.oblivioussp.spartanweaponry.init.ModEnchantments;
import com.oblivioussp.spartanweaponry.init.ModItems;
import com.oblivioussp.spartanweaponry.item.QuiverBaseItem;
import com.oblivioussp.spartanweaponry.merchant.villager.FletcherTrades;
import com.oblivioussp.spartanweaponry.merchant.villager.WeaponsmithTrades;
import com.oblivioussp.spartanweaponry.util.Config;
import com.oblivioussp.spartanweaponry.util.Log;
import com.oblivioussp.spartanweaponry.util.QuiverHelper;
import com.oblivioussp.spartanweaponry.util.WeaponHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CommonEventHandler {
    public static Random rand = new Random();

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent ev) {
        DamageSource src = ev.getSource();
        float dmgDealt = ev.getAmount();
        LivingEntity target = ev.getEntityLiving();
        if (dmgDealt == 0.0f || src.func_76352_a() || src.func_76347_k() || src.func_94541_c() || src.func_82725_o() || !src.func_76355_l().equals("player") && !src.func_76355_l().equals("mob")) {
            return;
        }
        if (src.func_76346_g() instanceof LivingEntity && target != null) {
            IMeleeTraitCallback callback;
            IWeaponTraitContainer container;
            LivingEntity attacker = (LivingEntity)src.func_76346_g();
            ItemStack attackerStack = attacker.func_184614_ca();
            ItemStack targetStack = target.func_184614_ca();
            if (!attackerStack.func_190926_b() && attackerStack.func_77973_b() instanceof IWeaponTraitContainer) {
                container = (IWeaponTraitContainer)attackerStack.func_77973_b();
                for (WeaponTrait trait : container.getAllWeaponTraits()) {
                    callback = trait.getMeleeCallback();
                    if (callback == null) continue;
                    dmgDealt = callback.modifyDamageDealt(container.getMaterial(), dmgDealt, src, attacker, target);
                }
                for (WeaponTrait trait : container.getMaterial().getAllWeaponTraits()) {
                    callback = trait.getMeleeCallback();
                    if (callback == null) continue;
                    dmgDealt = callback.modifyDamageDealt(container.getMaterial(), dmgDealt, src, attacker, target);
                }
                WeaponTrait trait = container.getFirstWeaponTraitWithType("armour_piercing");
                if (trait != null) {
                    dmgDealt = WeaponHelper.dealArmourPiercingDamage(attacker, trait.getMagnitude() / 100.0f, target, dmgDealt);
                }
            }
            if (!targetStack.func_190926_b() && targetStack.func_77973_b() instanceof IWeaponTraitContainer) {
                container = (IWeaponTraitContainer)targetStack.func_77973_b();
                for (WeaponTrait trait : container.getAllWeaponTraits()) {
                    callback = trait.getMeleeCallback();
                    if (callback == null) continue;
                    dmgDealt = callback.modifyDamageTaken(container.getMaterial(), dmgDealt, src, attacker, target);
                }
                for (WeaponTrait trait : container.getMaterial().getAllWeaponTraits()) {
                    callback = trait.getMeleeCallback();
                    if (callback == null) continue;
                    dmgDealt = callback.modifyDamageTaken(container.getMaterial(), dmgDealt, src, attacker, target);
                }
            }
        }
        if (dmgDealt != ev.getAmount()) {
            ev.setAmount(dmgDealt);
        }
    }

    @SubscribeEvent
    public static void modifyLootLevel(LootingLevelEvent ev) {
        Entity e = ev.getDamageSource().func_76364_f();
        if (e != null && e instanceof ThrowingWeaponEntity) {
            ThrowingWeaponEntity throwingWeapon = (ThrowingWeaponEntity)e;
            int luckLevel = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.THROWING_LUCK, (ItemStack)throwingWeapon.getWeaponStack());
            ev.setLootingLevel(luckLevel);
        }
    }

    @SubscribeEvent
    public static void onEquipmentChange(LivingEquipmentChangeEvent ev) {
        if ((ev.getSlot() == EquipmentSlotType.MAINHAND || ev.getSlot() == EquipmentSlotType.OFFHAND) && ev.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)ev.getEntityLiving();
            ItemStack fromStack = ev.getFrom();
            ItemStack toStack = ev.getTo();
            EquipmentSlotType oppositeHand = ev.getSlot() == EquipmentSlotType.OFFHAND ? EquipmentSlotType.MAINHAND : EquipmentSlotType.OFFHAND;
            ItemStack oppositeStack = player.func_184582_a(oppositeHand);
            if (!fromStack.func_77969_a(toStack) && !oppositeStack.func_190926_b()) {
                boolean toStackBlacklisted = false;
                String toName = toStack.func_77973_b().getRegistryName().toString();
                if (((List)Config.INSTANCE.quiverBowBlacklist.get()).contains(toName)) {
                    toStackBlacklisted = true;
                }
                for (QuiverHelper.IQuiverInfo quiverInfo : QuiverHelper.info) {
                    if (!quiverInfo.isWeapon(fromStack) || quiverInfo.isWeapon(toStack) && !toStackBlacklisted || !quiverInfo.isAmmo(oppositeStack)) continue;
                    ItemStack quiver = QuiverHelper.findFirstOfType(player, quiverInfo);
                    CommonEventHandler.placeAmmoIntoQuiver(player, quiver, oppositeHand);
                    oppositeStack = player.func_184582_a(oppositeHand);
                    if (!oppositeStack.func_190926_b()) continue;
                    CompoundNBT nbt = quiver.func_179543_a("OffhandMoved");
                    if (nbt == null) break;
                    String itemId = nbt.func_74779_i("Id");
                    int itemSlot = nbt.func_74762_e("Slot");
                    ItemStack offhandStack = player.field_71071_by.func_70301_a(itemSlot);
                    if (offhandStack.func_77973_b().getRegistryName().toString().equals(itemId)) {
                        player.func_184201_a(oppositeHand, offhandStack);
                        player.field_71071_by.func_70299_a(itemSlot, ItemStack.field_190927_a);
                    }
                    quiver.func_77978_p().func_82580_o("OffhandMoved");
                    break;
                }
            }
            if (!toStack.func_77969_a(fromStack)) {
                String regName = toStack.func_77973_b().getRegistryName().toString();
                if (((List)Config.INSTANCE.quiverBowBlacklist.get()).contains(regName)) {
                    return;
                }
                for (QuiverHelper.IQuiverInfo quiverInfo : QuiverHelper.info) {
                    if (!quiverInfo.isWeapon(toStack)) continue;
                    ItemStack quiver = QuiverHelper.findFirstOfType(player, quiverInfo);
                    if (!quiver.func_190926_b() && !oppositeStack.func_190926_b()) {
                        int emptySlot = -1;
                        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                            ItemStack playerStack = player.field_71071_by.func_70301_a(i);
                            if (!playerStack.func_190926_b()) continue;
                            emptySlot = i;
                            break;
                        }
                        if (emptySlot != -1) {
                            String itemId = oppositeStack.func_77973_b().getRegistryName().toString();
                            CompoundNBT nbt = quiver.func_190925_c("OffhandMoved");
                            nbt.func_74778_a("Id", itemId);
                            nbt.func_74768_a("Slot", emptySlot);
                            player.field_71071_by.func_70299_a(emptySlot, oppositeStack);
                            player.func_184201_a(oppositeHand, ItemStack.field_190927_a);
                        }
                    }
                    if (player.func_184582_a(oppositeHand).func_190926_b()) {
                        CommonEventHandler.takeAmmoFromQuiver(player, quiver, oppositeHand);
                    }
                    if ((oppositeStack = player.func_184582_a(oppositeHand)).func_190926_b()) continue;
                    break;
                }
            }
        }
    }

    protected static void placeAmmoIntoQuiver(PlayerEntity player, ItemStack quiver, EquipmentSlotType oppositeHandSlot) {
        if (!quiver.func_190926_b()) {
            IItemHandler quiverHandler = (IItemHandler)quiver.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElseThrow(QuiverBaseItem.CAPABILITY_EXCEPTION);
            ItemStack arrowStack = player.func_184582_a(oppositeHandSlot);
            for (int j = 0; j < quiverHandler.getSlots() && !(arrowStack = quiverHandler.insertItem(j, arrowStack, false)).func_190926_b(); ++j) {
            }
            player.func_184201_a(oppositeHandSlot, arrowStack);
        }
    }

    protected static void takeAmmoFromQuiver(PlayerEntity player, ItemStack quiver, EquipmentSlotType oppositeHandSlot) {
        if (!quiver.func_190926_b()) {
            IItemHandler quiverHandler = (IItemHandler)quiver.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElseThrow(QuiverBaseItem.CAPABILITY_EXCEPTION);
            ItemStack arrowStack = ItemStack.field_190927_a;
            for (int j = 0; j < quiverHandler.getSlots(); ++j) {
                arrowStack = quiverHandler.extractItem(j, 64, false);
                if (arrowStack.func_190926_b()) continue;
                player.func_184201_a(oppositeHandSlot, arrowStack);
                break;
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerPickup(EntityItemPickupEvent ev) {
        int beforeCount;
        ItemStack pickedUpStack = ev.getItem().func_92059_d().func_77946_l();
        int afterCount = beforeCount = pickedUpStack.func_190916_E();
        List<ItemStack> quivers = CommonEventHandler.findValidQuivers(ev.getPlayer());
        for (ItemStack quiver : quivers) {
            if (!pickedUpStack.func_190926_b() && !quiver.func_190926_b() && ((QuiverBaseItem)quiver.func_77973_b()).isAmmoValid(pickedUpStack, quiver) && quiver.func_196082_o().func_74767_n("ammoCollect")) {
                IItemHandler quiverHandler = (IItemHandler)quiver.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElseThrow(QuiverBaseItem.CAPABILITY_EXCEPTION);
                for (int i = 0; i < quiverHandler.getSlots() && !(pickedUpStack = quiverHandler.insertItem(i, pickedUpStack, false)).func_190926_b(); ++i) {
                }
            }
            if (!pickedUpStack.func_190926_b()) continue;
            break;
        }
        if ((afterCount = pickedUpStack.func_190916_E()) < beforeCount) {
            ev.getPlayer().func_71001_a((Entity)ev.getItem(), beforeCount - afterCount);
            ev.getItem().func_92059_d().func_190920_e(afterCount);
            ev.getPlayer().field_70170_p.func_184148_a((PlayerEntity)null, ev.getItem().func_226277_ct_(), ev.getItem().func_226278_cu_(), ev.getItem().func_226281_cx_(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, (rand.nextFloat() - rand.nextFloat()) * 0.7f + 0.0f);
        }
    }

    protected static List<ItemStack> findValidQuivers(PlayerEntity player) {
        Optional opt;
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        if (ModList.get().isLoaded("curios") && (opt = CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.func_77973_b() instanceof QuiverBaseItem, (LivingEntity)player)).isPresent()) {
            result.add((ItemStack)((ImmutableTriple)opt.get()).right);
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack stack2 = player.field_71071_by.func_70301_a(i);
            if (stack2.func_190926_b() || !(stack2.func_77973_b() instanceof QuiverBaseItem)) continue;
            result.add(stack2);
        }
        return result;
    }

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent ev) {
        if (((Boolean)Config.INSTANCE.addIronWeaponsToVillageWeaponsmith.get()).booleanValue() && ev.getName().toString().equals("minecraft:chests/village/village_weaponsmith")) {
            Log.info("Adding Iron Weapons to the Village Weaponsmith Loot Table!");
            ev.getTable().addPool(CommonEventHandler.generateLootPool("village_weaponsmith"));
        } else if (((Boolean)Config.INSTANCE.addDiamondWeaponsToEndCity.get()).booleanValue() && ev.getName().toString().equals("minecraft:chests/end_city_treasure")) {
            Log.info("Adding Diamond Weapons to the End City Treasure Loot Table!");
            ev.getTable().addPool(CommonEventHandler.generateLootPool("end_city_treasure"));
        }
    }

    private static LootPool generateLootPool(String lootName) {
        return LootPool.func_216096_a().func_216045_a(CommonEventHandler.generateLootEntry(lootName)).bonusRolls(0.0f, 1.0f).name("spartanweaponry_inject").func_216044_b();
    }

    private static LootEntry.Builder<?> generateLootEntry(String lootName) {
        return TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation("spartanweaponry", "inject/" + lootName)).func_216086_a(1);
    }

    @SubscribeEvent
    public static void onJoinWorld(EntityJoinWorldEvent ev) {
        if (((Boolean)Config.INSTANCE.disableSpawningZombieWithWeapon.get()).booleanValue() && ev.getEntity() instanceof ZombieEntity) {
            float chance;
            ZombieEntity entity = (ZombieEntity)ev.getEntity();
            float rand = entity.field_70170_p.field_73012_v.nextFloat();
            float f = chance = entity.field_70170_p.func_175659_aa() == Difficulty.HARD ? ((Double)Config.INSTANCE.zombieWithMeleeSpawnChanceHard.get()).floatValue() : ((Double)Config.INSTANCE.zombieWithMeleeSpawnChanceNormal.get()).floatValue();
            if (rand > 1.0f - chance) {
                ItemStack weapon = ItemStack.field_190927_a;
                Item[] possibleWeapons = new Item[]{ModItems.daggers.iron, ModItems.longswords.iron, ModItems.katanas.iron, ModItems.sabers.iron, ModItems.rapiers.iron, ModItems.greatswords.iron, ModItems.battleHammers.iron, ModItems.warhammers.iron, ModItems.battleaxes.iron, ModItems.flangedMaces.iron};
                weapon = CommonEventHandler.generateRandomItem(entity.field_70170_p, possibleWeapons);
                entity.func_184201_a(EquipmentSlotType.MAINHAND, weapon);
            }
        }
    }

    private static ItemStack generateRandomItem(World world, Item[] items) {
        float divider;
        float weaponRand = world.field_73012_v.nextFloat();
        int idx = MathHelper.func_76141_d((float)(weaponRand / (divider = 1.0f / (float)items.length)));
        idx = idx > items.length - 1 ? items.length - 1 : idx;
        return new ItemStack((IItemProvider)items[idx]);
    }

    @SubscribeEvent
    public static void addVillagerTrades(VillagerTradesEvent ev) {
        if (((Boolean)Config.INSTANCE.disableVillagerTrading.get()).booleanValue()) {
            return;
        }
        if (ev.getType() == VillagerProfession.field_221165_o) {
            List tradesLv1 = (List)ev.getTrades().get(1);
            List tradesLv2 = (List)ev.getTrades().get(2);
            List tradesLv3 = (List)ev.getTrades().get(3);
            List tradesLv4 = (List)ev.getTrades().get(4);
            List tradesLv5 = (List)ev.getTrades().get(5);
            if (!WeaponsmithTrades.LVL1_ITEMS.isEmpty()) {
                tradesLv1.add(WeaponsmithTrades.LVL1_TRADE);
            }
            if (!WeaponsmithTrades.LVL2_ITEMS.isEmpty()) {
                tradesLv2.add(WeaponsmithTrades.LVL2_TRADE);
            }
            if (!WeaponsmithTrades.LVL3_ITEMS.isEmpty()) {
                tradesLv3.add(WeaponsmithTrades.LVL3_TRADE);
            }
            if (!WeaponsmithTrades.LVL4_ITEMS.isEmpty()) {
                tradesLv4.add(WeaponsmithTrades.LVL4_TRADE);
            }
            if (!WeaponsmithTrades.LVL5_ITEMS.isEmpty()) {
                tradesLv5.add(WeaponsmithTrades.LVL5_TRADE);
            }
        } else if (ev.getType() == VillagerProfession.field_221158_h) {
            List tradesLv1 = (List)ev.getTrades().get(1);
            List tradesLv3 = (List)ev.getTrades().get(3);
            List tradesLv5 = (List)ev.getTrades().get(5);
            if (!((Boolean)Config.INSTANCE.longbows.disableRecipes.get()).booleanValue()) {
                tradesLv1.add(FletcherTrades.LONGBOW_WOOD_TRADE);
            }
            if (!((Boolean)Config.INSTANCE.longbows.disableRecipes.get()).booleanValue()) {
                tradesLv3.add(FletcherTrades.LONGBOW_IRON_TRADE);
            }
            if (!((Boolean)Config.INSTANCE.heavyCrossbows.disableRecipes.get()).booleanValue()) {
                tradesLv3.add(FletcherTrades.HEAVY_CROSSBOW_TRADE);
            }
            if (!((Boolean)Config.INSTANCE.heavyCrossbows.disableRecipes.get()).booleanValue()) {
                tradesLv3.add(FletcherTrades.BOLT_TRADE);
            }
            if (!((Boolean)Config.INSTANCE.longbows.disableRecipes.get()).booleanValue()) {
                tradesLv5.add(FletcherTrades.ENCHANTED_DIAMOND_LONGBOW_TRADE);
            }
            if (!((Boolean)Config.INSTANCE.heavyCrossbows.disableRecipes.get()).booleanValue()) {
                tradesLv5.add(FletcherTrades.ENCHANTED_DIAMOND_HEAVY_CROSSBOW_TRADE);
            }
        }
    }
}

