/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.item;

import com.oblivioussp.spartanweaponry.client.model.LargeBoltQuiverModel;
import com.oblivioussp.spartanweaponry.client.model.LightBoltQuiverModel;
import com.oblivioussp.spartanweaponry.client.model.MediumBoltQuiverModel;
import com.oblivioussp.spartanweaponry.client.model.QuiverModelBase;
import com.oblivioussp.spartanweaponry.inventory.QuiverBoltContainer;
import com.oblivioussp.spartanweaponry.item.BoltItem;
import com.oblivioussp.spartanweaponry.item.QuiverBaseItem;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class QuiverBoltItem
extends QuiverBaseItem {
    public static final ResourceLocation TEXTURE_SMALL = new ResourceLocation("spartanweaponry", "textures/model/quiver_bolt_small.png");
    public static final ResourceLocation TEXTURE_MEDIUM = new ResourceLocation("spartanweaponry", "textures/model/quiver_bolt_medium.png");
    public static final ResourceLocation TEXTURE_LARGE = new ResourceLocation("spartanweaponry", "textures/model/quiver_bolt_large.png");
    public static final ResourceLocation TEXTURE_HUGE = new ResourceLocation("spartanweaponry", "textures/model/quiver_bolt_huge.png");

    public QuiverBoltItem(String regName, int inventorySize) {
        super(regName, inventorySize);
    }

    @Override
    public void openGui(ItemStack stack, PlayerEntity player, QuiverBaseItem.SlotType slotType, int slot) {
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new ContainerProvider((ITextComponent)new TranslationTextComponent("gui.spartanweaponry.quiver_bolt.title"), stack), buf -> {
            buf.func_179249_a((Enum)slotType);
            buf.writeInt(slot);
        });
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.spartanweaponry.modifiers.ammo.type", new Object[]{I18n.func_135052_a((String)"tooltip.spartanweaponry.modifiers.ammo.bolt", (Object[])new Object[0])}).func_240699_a_(TextFormatting.GRAY));
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public boolean isAmmoValid(ItemStack pickedUpStack, ItemStack quiver) {
        return pickedUpStack.func_77973_b() instanceof BoltItem;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public QuiverModelBase getModel() {
        switch (this.ammoSlots) {
            case 9: 
            case 12: {
                return new LargeBoltQuiverModel();
            }
            case 6: {
                return new MediumBoltQuiverModel();
            }
        }
        return new LightBoltQuiverModel();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getModelTexture() {
        switch (this.ammoSlots) {
            case 12: {
                return TEXTURE_HUGE;
            }
            case 9: {
                return TEXTURE_LARGE;
            }
            case 6: {
                return TEXTURE_MEDIUM;
            }
        }
        return TEXTURE_SMALL;
    }

    protected class ContainerProvider
    implements INamedContainerProvider {
        private final ITextComponent displayName;
        private final ItemStack quiverStack;

        protected ContainerProvider(ITextComponent displayName, ItemStack quiverStack) {
            this.displayName = displayName;
            this.quiverStack = quiverStack;
        }

        public Container createMenu(int id, PlayerInventory inventory, PlayerEntity player) {
            return new QuiverBoltContainer(id, inventory, this.quiverStack);
        }

        public ITextComponent func_145748_c_() {
            return this.displayName;
        }
    }
}

