/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.item.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.oblivioussp.spartanweaponry.init.ModRecipeSerializers;
import com.oblivioussp.spartanweaponry.item.QuiverBaseItem;
import com.oblivioussp.spartanweaponry.util.Log;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.SmithingRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class QuiverUpgradeRecipe
extends SmithingRecipe {
    public QuiverUpgradeRecipe(ResourceLocation recipeId, Ingredient base, Ingredient addition, ItemStack result) {
        super(recipeId, base, addition, result);
    }

    public ItemStack func_77572_b(IInventory inv) {
        ItemStack inputStack = inv.func_70301_a(0);
        ItemStack outputStack = super.func_77572_b(inv);
        LazyOptional inputCap = inputStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        if (inputCap.isPresent()) {
            LazyOptional outputCap = outputStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
            if (outputCap.isPresent()) {
                IItemHandler inputHandler = (IItemHandler)inputCap.orElseThrow(QuiverBaseItem.CAPABILITY_EXCEPTION);
                IItemHandler outputHandler = (IItemHandler)outputCap.orElseThrow(QuiverBaseItem.CAPABILITY_EXCEPTION);
                for (int i = 0; i < inputHandler.getSlots(); ++i) {
                    ItemStack stack = inputHandler.getStackInSlot(i);
                    if (stack.func_190926_b()) continue;
                    outputHandler.insertItem(i, stack, false);
                }
            } else {
                Log.error("Output ItemStack: " + outputStack.func_200301_q().toString() + " doesn't contain an appropriate item handler capability to store output items to!");
            }
        }
        return outputStack;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return ModRecipeSerializers.QUIVER_UPGRADE_SMITHING;
    }

    public IRecipeType<?> func_222127_g() {
        return IRecipeType.field_234827_g_;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<QuiverUpgradeRecipe> {
        public Serializer() {
            this.setRegistryName(new ResourceLocation("spartanweaponry", "quiver_upgrade_smithing"));
        }

        public QuiverUpgradeRecipe read(ResourceLocation recipeId, JsonObject json) {
            Ingredient baseIngredient = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"base"));
            Ingredient additionIngredient = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"addition"));
            ItemStack resultStack = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            return new QuiverUpgradeRecipe(recipeId, baseIngredient, additionIngredient, resultStack);
        }

        public QuiverUpgradeRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            try {
                Ingredient baseIngredient = Ingredient.func_199566_b((PacketBuffer)buffer);
                Ingredient additionIngredient = Ingredient.func_199566_b((PacketBuffer)buffer);
                ItemStack resultStack = buffer.func_150791_c();
                return new QuiverUpgradeRecipe(recipeId, baseIngredient, additionIngredient, resultStack);
            }
            catch (Exception e) {
                Log.error("Failed to read a Quiver Upgrade Smithing Recipe from a packet!");
                throw e;
            }
        }

        public void write(PacketBuffer buffer, QuiverUpgradeRecipe recipe) {
            try {
                IRecipeSerializer.field_234826_u_.func_199427_a_(buffer, (IRecipe)recipe);
            }
            catch (Exception e) {
                Log.error("Failed to write a Quiver Upgrade Smithing Recipe from a packet!");
                throw e;
            }
        }
    }
}

