/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.util;

import com.electronwill.nightconfig.core.EnumGetMethod;
import com.oblivioussp.spartanweaponry.api.WeaponMaterial;
import com.oblivioussp.spartanweaponry.api.WeaponTraits;
import com.oblivioussp.spartanweaponry.client.gui.AlignmentHelper;
import com.oblivioussp.spartanweaponry.init.ModItems;
import com.oblivioussp.spartanweaponry.merchant.villager.WeaponsmithTrades;
import com.oblivioussp.spartanweaponry.util.Defaults;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    public static final Config INSTANCE;
    public static final ForgeConfigSpec CONFIG_SPEC;
    public WeaponCategory daggers;
    public WeaponCategory longswords;
    public WeaponCategory katanas;
    public WeaponCategory sabers;
    public WeaponCategory rapiers;
    public WeaponCategory greatswords;
    public WeaponCategory clubs;
    public WeaponCategory cestus;
    public WeaponCategory battleHammers;
    public WeaponCategory warhammers;
    public WeaponCategory spears;
    public WeaponCategory halberds;
    public WeaponCategory pikes;
    public WeaponCategory lances;
    public RangedWeaponCategory longbows;
    public RangedWeaponCategory heavyCrossbows;
    public WeaponCategory throwingKnives;
    public WeaponCategory tomahawks;
    public WeaponCategory javelins;
    public WeaponCategory boomerangs;
    public WeaponCategory battleaxes;
    public WeaponCategory flangedMaces;
    public WeaponCategory glaives;
    public WeaponCategory quarterstaves;
    public MaterialCategory copper;
    public MaterialCategory tin;
    public MaterialCategory bronze;
    public MaterialCategory steel;
    public MaterialCategory silver;
    public MaterialCategory invar;
    public MaterialCategory platinum;
    public MaterialCategory electrum;
    public MaterialCategory nickel;
    public MaterialCategory lead;
    public ForgeConfigSpec.BooleanValue disableRecipesExplosives;
    public ForgeConfigSpec.BooleanValue disableTerrainDamage;
    public ForgeConfigSpec.BooleanValue disableNewArrowRecipes;
    public ForgeConfigSpec.BooleanValue disableDiamondAmmoRecipes;
    public ForgeConfigSpec.BooleanValue disableQuiverRecipes;
    public ForgeConfigSpec.DoubleValue baseDamageArrowWood;
    public ForgeConfigSpec.DoubleValue baseDamageArrowIron;
    public ForgeConfigSpec.DoubleValue baseDamageArrowDiamond;
    public ForgeConfigSpec.DoubleValue baseDamageBolt;
    public ForgeConfigSpec.DoubleValue baseDamageBoltDiamond;
    public ForgeConfigSpec.ConfigValue<List<? extends String>> quiverBowBlacklist;
    public ForgeConfigSpec.BooleanValue addIronWeaponsToVillageWeaponsmith;
    public ForgeConfigSpec.BooleanValue addDiamondWeaponsToEndCity;
    public ForgeConfigSpec.BooleanValue disableSpawningZombieWithWeapon;
    public ForgeConfigSpec.DoubleValue zombieWithMeleeSpawnChanceNormal;
    public ForgeConfigSpec.DoubleValue zombieWithMeleeSpawnChanceHard;
    public ForgeConfigSpec.BooleanValue disableVillagerTrading;
    public ForgeConfigSpec.BooleanValue disableNewCrosshairsCrossbow;
    public ForgeConfigSpec.BooleanValue disableNewCrosshairsThrowingWeapon;
    public ForgeConfigSpec.BooleanValue forceCompatibilityCrosshairs;
    public ForgeConfigSpec.EnumValue<AlignmentHelper.Alignment> quiverHudAlignment;
    public ForgeConfigSpec.IntValue quiverHudOffsetX;
    public ForgeConfigSpec.IntValue quiverHudOffsetY;
    public ForgeConfigSpec.DoubleValue damageBonusChestMultiplier;
    public ForgeConfigSpec.DoubleValue damageBonusRidingMultiplier;
    public ForgeConfigSpec.DoubleValue damageBonusThrowMultiplier;
    public ForgeConfigSpec.DoubleValue damageBonusThrowJavelinMultiplier;
    public ForgeConfigSpec.DoubleValue damageBonusUnarmoredMultiplier;
    public ForgeConfigSpec.DoubleValue damageBonusUndeadMultiplier;
    public ForgeConfigSpec.DoubleValue damageAbsorptionFactor;
    public ForgeConfigSpec.DoubleValue reach1Value;
    public ForgeConfigSpec.DoubleValue reach2Value;
    public ForgeConfigSpec.DoubleValue sweep2Percentage;
    public ForgeConfigSpec.DoubleValue sweep3Percentage;
    public ForgeConfigSpec.DoubleValue armorPiercePercentage;
    public ForgeConfigSpec.IntValue quickStrikeHurtResistTicks;
    public List<String> disabledRecipeTypes = new ArrayList<String>();

    private Config(ForgeConfigSpec.Builder builder) {
        this.daggers = new WeaponCategory(builder, "dagger", "Daggers", 2.5f, 2.5f, 1.0f);
        this.longswords = new WeaponCategory(builder, "longsword", "Longswords", 1.4f, 4.5f, 1.5f);
        this.katanas = new WeaponCategory(builder, "katana", "Katanas", 2.0f, 3.5f, 0.5f);
        this.sabers = new WeaponCategory(builder, "saber", "Sabers", 1.6f, 3.5f, 0.5f);
        this.rapiers = new WeaponCategory(builder, "rapier", "Rapiers", 2.4f, 2.0f, 0.5f);
        this.greatswords = new WeaponCategory(builder, "greatsword", "Rapiers", 1.4f, 4.0f, 1.5f);
        this.clubs = new WeaponCategory(builder, "club", "Clubs", 1.3f, 4.0f, 1.0f);
        this.cestus = new WeaponCategory(builder, "cestus", "Cestusae", 3.5f, 2.0f, 0.5f);
        this.battleHammers = new WeaponCategory(builder, "battle_hammer", "Battle Hammers", 0.8f, 5.0f, 2.0f);
        this.warhammers = new WeaponCategory(builder, "warhammer", "Warhammers", 1.1f, 4.0f, 1.5f);
        this.spears = new WeaponCategory(builder, "spear", "Spears", 1.4f, 5.5f, 0.5f);
        this.halberds = new WeaponCategory(builder, "halberd", "Halberds", 1.2f, 5.0f, 1.5f);
        this.pikes = new WeaponCategory(builder, "pike", "Pikes", 1.4f, 4.0f, 1.0f);
        this.lances = new WeaponCategory(builder, "lance", "Lances", 1.0f, 4.0f, 1.0f);
        this.longbows = new RangedWeaponCategory(builder, "longbow", "Longbows");
        this.heavyCrossbows = new RangedWeaponCategory(builder, "heavy_crossbow", "Heavy Crossbows");
        this.throwingKnives = new WeaponCategory(builder, "throwing_knife", "Throwing Knives", 2.5f, 1.5f, 1.0f);
        this.tomahawks = new WeaponCategory(builder, "tomahawk", "Tomahawks", 0.9f, 2.0f, 1.5f);
        this.javelins = new WeaponCategory(builder, "javelin", "Javelins", 1.2f, 1.5f, 1.0f);
        this.boomerangs = new WeaponCategory(builder, "boomerang", "Boomerangs", 2.0f, 4.0f, 1.0f);
        this.battleaxes = new WeaponCategory(builder, "battleaxe", "Battleaxes", 1.0f, 4.0f, 2.0f);
        this.flangedMaces = new WeaponCategory(builder, "flanged_mace", "Flanged Maces", 1.2f, 3.0f, 1.5f);
        this.glaives = new WeaponCategory(builder, "glaive", "Glaives", 1.0f, 4.0f, 1.5f);
        this.quarterstaves = new WeaponCategory(builder, "quarterstaff", "Quarterstaves", 1.4f, 3.0f, 1.5f);
        this.copper = new MaterialCategory(builder, "copper", 1.5f, 200);
        this.tin = new MaterialCategory(builder, "tin", 1.75f, 180);
        this.bronze = new MaterialCategory(builder, "bronze", 2.0f, 320);
        this.steel = new MaterialCategory(builder, "steel", 2.5f, 480);
        this.silver = new MaterialCategory(builder, "silver", 1.5f, 48);
        this.invar = new MaterialCategory(builder, "invar", 2.2f, 440);
        this.platinum = new MaterialCategory(builder, "platinum", 3.5f, 1024);
        this.electrum = new MaterialCategory(builder, "electrum", 2.0f, 180);
        this.nickel = new MaterialCategory(builder, "nickel", 2.0f, 200);
        this.lead = new MaterialCategory(builder, "lead", 2.0f, 240);
        builder.push("explosives");
        this.disableRecipesExplosives = builder.comment("Disables all recipes for explosive related items").translation("config.spartanweaponry.explosive.disable_recipe").worldRestart().define("disable_recipe", false);
        this.disableTerrainDamage = builder.comment("Disables terrain damage for explosives in this mod such as Dynamite and Explosive Arrows. Is overridden by the 'mobGriefing' gamerule.").translation("config.spartanweaponry.explosive.disable_terrain_damage").define("disable_terrain_damage", false);
        builder.pop();
        builder.push("projectiles");
        this.disableNewArrowRecipes = builder.comment("Disables Recipes for all new Arrows.").translation("config.spartanweaponry.projectile.disable_new_arrow_recipes").worldRestart().define("disable_new_arrow_recipes", false);
        this.disableDiamondAmmoRecipes = builder.comment("Disables Recipes for both Diamond Arrows and Diamond Bolts.").translation("config.spartanweaponry.projectile.disable_diamond_ammo_recipes").worldRestart().define("disable_diamond_ammo_recipes", false);
        this.disableQuiverRecipes = builder.comment("Disables all variants of the Arrow Quiver and the Bolt Quiver in this mod").translation("config.spartanweaponry.projectile.disable_quiver_recipes").worldRestart().define("disable_quiver_recipes", false);
        this.baseDamageArrowWood = builder.comment("Base damage for Wooden Arrows.").translation("config.spartanweaponry.projectile.base_damage_wood_arrow").worldRestart().defineInRange("base_damage_wood_arrow", (double)0.2f, 0.1, 100.0);
        this.baseDamageArrowIron = builder.comment("Base damage for Iron Arrows.").translation("config.spartanweaponry.projectile.base_damage_iron_arrow").worldRestart().defineInRange("base_damage_iron_arrow", 3.0, 0.1, 100.0);
        this.baseDamageArrowDiamond = builder.comment("Base damage for Diamond Arrows.").translation("config.spartanweaponry.projectile.base_damage_diamond_arrow").worldRestart().defineInRange("base_damage_diamond_arrow", 3.5, 0.1, 100.0);
        this.baseDamageBolt = builder.comment("Base damage for Bolts.").translation("config.spartanweaponry.projectile.base_damage_bolt").worldRestart().defineInRange("base_damage_bolt", 4.0, 0.1, 100.0);
        this.baseDamageBoltDiamond = builder.comment("Base damage for Diamond Bolts.").translation("config.spartanweaponry.projectile.base_damage_diamond_bolt").worldRestart().defineInRange("base_damage_diamond_bolt", 5.0, 0.1, 100.0);
        this.quiverBowBlacklist = builder.comment("Bows in this blacklist will not get Arrows pulled out of the Arrow Quiver. Use the registry ID of the bow to add to this. e.g. \"minecraft:bow\"").translation("config.spartanweaponry.projectile.quiver_bow_blacklist").defineList("quiver_bow_blacklist", Defaults.QuiverArrowBlacklist, value -> true);
        builder.pop();
        builder.push("loot");
        this.addIronWeaponsToVillageWeaponsmith = builder.comment("Set to false to disable spawning Iron Weapons in Village Weaponsmith chests via loot table injection").translation("config.spartanweaponry.loot.add_iron_weapons_to_village_blacksmith").worldRestart().define("add_iron_weapons_to_village_blacksmith", true);
        this.addDiamondWeaponsToEndCity = builder.comment("Set to false to disable spawning Diamond Weapons in End City chests via loot table injection").translation("config.spartanweaponry.loot.add_diamond_weapons_to_end_city").worldRestart().define("add_diamond_weapons_to_end_city", true);
        this.zombieWithMeleeSpawnChanceNormal = builder.comment("Chance for Zombies to spawn with Iron Melee Weapons on all difficulties apart from Hard and Hardcore").translation("config.spartanweaponry.loot.zombie_with_melee_spawn_chance_normal").defineInRange("zombie_with_melee_spawn_chance_normal", (double)0.05f, 0.0, 1.0);
        this.zombieWithMeleeSpawnChanceHard = builder.comment("Chance for Zombies to spawn with Iron Melee Weapons on Hard or Hardcore difficulty").translation("config.spartanweaponry.loot.zombie_with_melee_spawn_chance_hard").defineInRange("zombie_with_melee_spawn_chance_hard", 0.25, 0.0, 1.0);
        this.disableSpawningZombieWithWeapon = builder.comment("Set to true to disable spawning a Zombie with any weapons from this mod").translation("config.spartanweaponry.loot.disable_spawning_zombie_with_weapon").define("disable_spawning_zombie_with_weapon", false);
        builder.pop();
        builder.push("trading");
        this.disableVillagerTrading = builder.comment("Set to true to disable Villagers (Weaponsmiths and Fletchers) from trading weapons from this mod").translation("config.spartanweaponry.trading.disabled").define("disable", false);
        builder.pop();
        builder.push("traits");
        this.damageBonusChestMultiplier = builder.comment("Changes the \"Chest Damage Bonus\" Weapon Trait multiplier value").translation("config.spartanweaponry.traits.damageBonusChestMultiplier").defineInRange("damageBonusChestMultiplier", 2.0, 1.0, 50.0);
        this.damageBonusRidingMultiplier = builder.comment("Changes the \"Riding Damage Bonus\" Weapon Trait multiplier value").translation("config.spartanweaponry.traits.damageBonusRidingMultiplier").defineInRange("damageBonusRidingMultiplier", 2.0, 1.0, 50.0);
        this.damageBonusThrowMultiplier = builder.comment("Changes the \"Throwing Damage Bonus\" Weapon Trait multiplier value").translation("config.spartanweaponry.traits.damageBonusThrowMultiplier").defineInRange("damageBonusThrowMultiplier", 2.0, 1.0, 50.0);
        this.damageBonusThrowJavelinMultiplier = builder.comment("Changes the \"Chest Damage Bonus\" Weapon Trait multiplier value").translation("config.spartanweaponry.traits.damageBonusThrowJavelinMultiplier").defineInRange("damageBonusThrowJavelinMultiplier", 3.0, 1.0, 50.0);
        this.damageBonusUnarmoredMultiplier = builder.comment("Changes the \"Chest Damage Bonus\" Weapon Trait multiplier value").translation("config.spartanweaponry.traits.damageBonusUnarmoredMultiplier").defineInRange("damageBonusUnarmoredMultiplier", 3.0, 1.0, 50.0);
        this.damageBonusUndeadMultiplier = builder.comment("Changes the \"Chest Damage Bonus\" Weapon Trait multiplier value").translation("config.spartanweaponry.traits.damageBonusUndeadMultiplier").defineInRange("damageBonusUndeadMultiplier", 1.5, 1.0, 50.0);
        this.damageAbsorptionFactor = builder.comment("Changes the percentage of damage absorbed by the \"Damage Absorption\" Weapon Trait").translation("config.spartanweaponry.traits.damageAbsorptionFactor").defineInRange("damageAbsorptionFactor", 0.25, 0.0, 1.0);
        this.reach1Value = builder.comment("Changes the reach of any weapons with the \"Reach I\" Weapon Trait").translation("config.spartanweaponry.traits.reach1Value").defineInRange("reach1Value", 6.0, 5.0, 15.0);
        this.reach2Value = builder.comment("Changes the reach of any weapons with the \"Reach II\" Weapon Trait").translation("config.spartanweaponry.traits.reach2Value").defineInRange("reach2Value", 7.0, 5.0, 15.0);
        this.sweep2Percentage = builder.comment("Changes the percentage of damage inflicted to enemies when sweep attacked on weapons with the \"Sweep II\" Weapon Trait").translation("config.spartanweaponry.traits.sweep2Percentage").defineInRange("sweep2Percentage", 50.0, 0.0, 100.0);
        this.sweep3Percentage = builder.comment("Changes the percentage of damage inflicted to enemies when sweep attacked on weapons with the \"Sweep III\" Weapon Trait").translation("config.spartanweaponry.traits.sweep3Percentage").defineInRange("sweep3Percentage", 100.0, 0.0, 100.0);
        this.armorPiercePercentage = builder.comment("Changes the percentage of damage that ignores armor on weapons with the \"Armor Piercing\" Weapon Trait").translation("config.spartanweaponry.traits.armorPiercePercentage").defineInRange("armorPiercePercentage", 50.0, 0.0, 100.0);
        this.quickStrikeHurtResistTicks = builder.comment("Tweaks the hurt resistance ticks for weapons that use the \"Quick Strike\" Weapon Trait").translation("config.spartanweaponry.traits.quick_strike.hurt_resistance_ticks").defineInRange("hurt_resistance_ticks", 14, 10, 20);
        builder.pop();
        builder.push("client");
        this.disableNewCrosshairsCrossbow = builder.comment("Set to true to disable a new Crosshair for the Crossbow which visually shows inaccuracy, using the default Crosshair instead; false otherwise").translation("config.spartanweaponry.client.disable_new_crosshairs_crossbow").define("disable_new_crosshairs_crossbow", false);
        this.disableNewCrosshairsThrowingWeapon = builder.comment("Set to true to disable a new Crosshair for Throwing Weapons which show the charge for them, using the default Crosshair instead; false otherwise").translation("config.spartanweaponry.client.disable_new_crosshairs_throwing_weapons").define("disable_new_crosshairs_throwing_weapons", false);
        this.forceCompatibilityCrosshairs = builder.comment("Set to force compatibility crosshairs for Crosshairs and Throwing Weapons. This won't work if the new crosshairs are disabled").translation("config.spartanweaponry.client.force_compatibility_crosshairs").define("force_compatibility_crosshairs", false);
        this.quiverHudAlignment = builder.comment("Sets where the Quiver HUD Element should be aligned").translation("config.spartanweaponry.client.quiver_hud_alignment").defineEnum("quiver_hud_alignment", (Enum)AlignmentHelper.Alignment.BOTTOM_CENTER, EnumGetMethod.NAME_IGNORECASE);
        this.quiverHudOffsetX = builder.comment("Sets where on the X-axis the Quiver HUD element should be off-set from it's alignment point").translation("config.spartanweaponry.client.quiver_hud_offset_x").defineInRange("quiver_hud_offset_x", -139, -400, 400);
        this.quiverHudOffsetY = builder.comment("Sets where on the Y-axis the Quiver HUD element should be off-set from it's alignment point").translation("config.spartanweaponry.client.quiver_hud_offset_y").defineInRange("quiver_hud_offset_y", 63, -400, 400);
        builder.pop();
    }

    @SubscribeEvent
    public static void onConfigLoad(ModConfig.ModConfigEvent ev) {
        Config.INSTANCE.disabledRecipeTypes.clear();
        Config.updateMaterialValues(WeaponMaterial.COPPER, ((Double)Config.INSTANCE.copper.damage.get()).floatValue(), (Integer)Config.INSTANCE.copper.durability.get());
        Config.INSTANCE.copper.updateDisabledRecipeList();
        Config.updateMaterialValues(WeaponMaterial.TIN, ((Double)Config.INSTANCE.tin.damage.get()).floatValue(), (Integer)Config.INSTANCE.tin.durability.get());
        Config.INSTANCE.tin.updateDisabledRecipeList();
        Config.updateMaterialValues(WeaponMaterial.BRONZE, ((Double)Config.INSTANCE.bronze.damage.get()).floatValue(), (Integer)Config.INSTANCE.bronze.durability.get());
        Config.INSTANCE.bronze.updateDisabledRecipeList();
        Config.updateMaterialValues(WeaponMaterial.STEEL, ((Double)Config.INSTANCE.steel.damage.get()).floatValue(), (Integer)Config.INSTANCE.steel.durability.get());
        Config.INSTANCE.steel.updateDisabledRecipeList();
        Config.updateMaterialValues(WeaponMaterial.SILVER, ((Double)Config.INSTANCE.silver.damage.get()).floatValue(), (Integer)Config.INSTANCE.silver.durability.get());
        Config.INSTANCE.silver.updateDisabledRecipeList();
        Config.updateMaterialValues(WeaponMaterial.INVAR, ((Double)Config.INSTANCE.invar.damage.get()).floatValue(), (Integer)Config.INSTANCE.invar.durability.get());
        Config.INSTANCE.invar.updateDisabledRecipeList();
        Config.updateMaterialValues(WeaponMaterial.PLATINUM, ((Double)Config.INSTANCE.platinum.damage.get()).floatValue(), (Integer)Config.INSTANCE.platinum.durability.get());
        Config.INSTANCE.platinum.updateDisabledRecipeList();
        Config.updateMaterialValues(WeaponMaterial.ELECTRUM, ((Double)Config.INSTANCE.electrum.damage.get()).floatValue(), (Integer)Config.INSTANCE.electrum.durability.get());
        Config.INSTANCE.electrum.updateDisabledRecipeList();
        Config.updateMaterialValues(WeaponMaterial.NICKEL, ((Double)Config.INSTANCE.nickel.damage.get()).floatValue(), (Integer)Config.INSTANCE.nickel.durability.get());
        Config.INSTANCE.nickel.updateDisabledRecipeList();
        Config.updateMaterialValues(WeaponMaterial.LEAD, ((Double)Config.INSTANCE.lead.damage.get()).floatValue(), (Integer)Config.INSTANCE.lead.durability.get());
        Config.INSTANCE.lead.updateDisabledRecipeList();
        ModItems.daggers.updateSettingsFromConfig(((Double)Config.INSTANCE.daggers.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.daggers.damageMultipler.get()).floatValue(), (Double)Config.INSTANCE.daggers.speed.get());
        Config.INSTANCE.daggers.updateDisabledRecipeList();
        ModItems.longswords.updateSettingsFromConfig(((Double)Config.INSTANCE.longswords.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.longswords.damageMultipler.get()).floatValue(), (Double)Config.INSTANCE.longswords.speed.get());
        Config.INSTANCE.longswords.updateDisabledRecipeList();
        ModItems.katanas.updateSettingsFromConfig(((Double)Config.INSTANCE.katanas.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.katanas.damageMultipler.get()).floatValue(), (Double)Config.INSTANCE.katanas.speed.get());
        Config.INSTANCE.katanas.updateDisabledRecipeList();
        ModItems.sabers.updateSettingsFromConfig(((Double)Config.INSTANCE.sabers.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.sabers.damageMultipler.get()).floatValue(), (Double)Config.INSTANCE.sabers.speed.get());
        Config.INSTANCE.sabers.updateDisabledRecipeList();
        ModItems.rapiers.updateSettingsFromConfig(((Double)Config.INSTANCE.rapiers.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.rapiers.damageMultipler.get()).floatValue(), (Double)Config.INSTANCE.rapiers.speed.get());
        Config.INSTANCE.rapiers.updateDisabledRecipeList();
        ModItems.greatswords.updateSettingsFromConfig(((Double)Config.INSTANCE.greatswords.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.greatswords.damageMultipler.get()).floatValue(), (Double)Config.INSTANCE.greatswords.speed.get());
        Config.INSTANCE.greatswords.updateDisabledRecipeList();
        Config.INSTANCE.clubs.updateDisabledRecipeList();
        Config.INSTANCE.cestus.updateDisabledRecipeList();
        ModItems.battleHammers.updateSettingsFromConfig(((Double)Config.INSTANCE.battleHammers.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.battleHammers.damageMultipler.get()).floatValue(), (Double)Config.INSTANCE.battleHammers.speed.get());
        Config.INSTANCE.battleHammers.updateDisabledRecipeList();
        ModItems.warhammers.updateSettingsFromConfig(((Double)Config.INSTANCE.warhammers.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.warhammers.damageMultipler.get()).floatValue(), (Double)Config.INSTANCE.warhammers.speed.get());
        Config.INSTANCE.warhammers.updateDisabledRecipeList();
        ModItems.spears.updateSettingsFromConfig(((Double)Config.INSTANCE.spears.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.spears.damageMultipler.get()).floatValue(), (Double)Config.INSTANCE.spears.speed.get());
        Config.INSTANCE.spears.updateDisabledRecipeList();
        ModItems.halberds.updateSettingsFromConfig(((Double)Config.INSTANCE.halberds.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.halberds.damageMultipler.get()).floatValue(), (Double)Config.INSTANCE.halberds.speed.get());
        Config.INSTANCE.halberds.updateDisabledRecipeList();
        ModItems.pikes.updateSettingsFromConfig(((Double)Config.INSTANCE.pikes.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.pikes.damageMultipler.get()).floatValue(), (Double)Config.INSTANCE.pikes.speed.get());
        Config.INSTANCE.pikes.updateDisabledRecipeList();
        ModItems.lances.updateSettingsFromConfig(((Double)Config.INSTANCE.lances.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.lances.damageMultipler.get()).floatValue(), (Double)Config.INSTANCE.lances.speed.get());
        Config.INSTANCE.lances.updateDisabledRecipeList();
        Config.INSTANCE.longbows.updateDisabledRecipeList();
        Config.INSTANCE.heavyCrossbows.updateDisabledRecipeList();
        ModItems.throwingKnives.updateSettingsFromConfig(((Double)Config.INSTANCE.throwingKnives.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.throwingKnives.damageMultipler.get()).floatValue(), (Double)Config.INSTANCE.throwingKnives.speed.get());
        Config.INSTANCE.throwingKnives.updateDisabledRecipeList();
        ModItems.tomahawks.updateSettingsFromConfig(((Double)Config.INSTANCE.tomahawks.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.tomahawks.damageMultipler.get()).floatValue(), (Double)Config.INSTANCE.tomahawks.speed.get());
        Config.INSTANCE.tomahawks.updateDisabledRecipeList();
        ModItems.javelins.updateSettingsFromConfig(((Double)Config.INSTANCE.javelins.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.javelins.damageMultipler.get()).floatValue(), (Double)Config.INSTANCE.javelins.speed.get());
        Config.INSTANCE.javelins.updateDisabledRecipeList();
        ModItems.boomerangs.updateSettingsFromConfig(((Double)Config.INSTANCE.boomerangs.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.boomerangs.damageMultipler.get()).floatValue(), (Double)Config.INSTANCE.boomerangs.speed.get());
        Config.INSTANCE.boomerangs.updateDisabledRecipeList();
        ModItems.battleaxes.updateSettingsFromConfig(((Double)Config.INSTANCE.battleaxes.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.battleaxes.damageMultipler.get()).floatValue(), (Double)Config.INSTANCE.battleaxes.speed.get());
        Config.INSTANCE.battleaxes.updateDisabledRecipeList();
        ModItems.flangedMaces.updateSettingsFromConfig(((Double)Config.INSTANCE.flangedMaces.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.flangedMaces.damageMultipler.get()).floatValue(), (Double)Config.INSTANCE.flangedMaces.speed.get());
        Config.INSTANCE.flangedMaces.updateDisabledRecipeList();
        ModItems.glaives.updateSettingsFromConfig(((Double)Config.INSTANCE.glaives.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.glaives.damageMultipler.get()).floatValue(), (Double)Config.INSTANCE.glaives.speed.get());
        Config.INSTANCE.glaives.updateDisabledRecipeList();
        ModItems.quarterstaves.updateSettingsFromConfig(((Double)Config.INSTANCE.quarterstaves.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.quarterstaves.damageMultipler.get()).floatValue(), (Double)Config.INSTANCE.quarterstaves.speed.get());
        Config.INSTANCE.quarterstaves.updateDisabledRecipeList();
        Config.updateDisabledRecipe("arrows", (Boolean)Config.INSTANCE.disableNewArrowRecipes.get());
        Config.updateDisabledRecipe("diamond_ammo", (Boolean)Config.INSTANCE.disableDiamondAmmoRecipes.get());
        Config.updateDisabledRecipe("quivers", (Boolean)Config.INSTANCE.disableQuiverRecipes.get());
        Config.updateDisabledRecipe("bolts", (Boolean)Config.INSTANCE.heavyCrossbows.disableRecipes.get());
        ModItems.arrowWood.setDamageModifier(((Double)Config.INSTANCE.baseDamageArrowWood.get()).floatValue());
        ModItems.tippedArrowWood.setDamageModifier(((Double)Config.INSTANCE.baseDamageArrowWood.get()).floatValue());
        ModItems.arrowIron.setDamageModifier(((Double)Config.INSTANCE.baseDamageArrowIron.get()).floatValue());
        ModItems.tippedArrowIron.setDamageModifier(((Double)Config.INSTANCE.baseDamageArrowIron.get()).floatValue());
        ModItems.arrowDiamond.setDamageModifier(((Double)Config.INSTANCE.baseDamageArrowDiamond.get()).floatValue());
        ModItems.tippedArrowDiamond.setDamageModifier(((Double)Config.INSTANCE.baseDamageArrowDiamond.get()).floatValue());
        ModItems.bolt.setDamageModifier(((Double)Config.INSTANCE.baseDamageBolt.get()).floatValue());
        ModItems.tippedBolt.setDamageModifier(((Double)Config.INSTANCE.baseDamageBolt.get()).floatValue());
        ModItems.spectralBolt.setDamageModifier(((Double)Config.INSTANCE.baseDamageBolt.get()).floatValue());
        ModItems.boltDiamond.setDamageModifier(((Double)Config.INSTANCE.baseDamageBoltDiamond.get()).floatValue());
        ModItems.tippedBoltDiamond.setDamageModifier(((Double)Config.INSTANCE.baseDamageBolt.get()).floatValue());
        Config.updateDisabledRecipe("explosive", (Boolean)Config.INSTANCE.disableRecipesExplosives.get());
        WeaponTraits.EXTRA_DAMAGE_2_CHEST.setMagnitude(((Double)Config.INSTANCE.damageBonusChestMultiplier.get()).floatValue());
        WeaponTraits.EXTRA_DAMAGE_2_RIDING.setMagnitude(((Double)Config.INSTANCE.damageBonusRidingMultiplier.get()).floatValue());
        WeaponTraits.EXTRA_DAMAGE_2_THROWN.setMagnitude(((Double)Config.INSTANCE.damageBonusThrowMultiplier.get()).floatValue());
        WeaponTraits.EXTRA_DAMAGE_3_THROWN.setMagnitude(((Double)Config.INSTANCE.damageBonusThrowJavelinMultiplier.get()).floatValue());
        WeaponTraits.EXTRA_DAMAGE_3_NO_ARMOUR.setMagnitude(((Double)Config.INSTANCE.damageBonusUnarmoredMultiplier.get()).floatValue());
        WeaponTraits.EXTRA_DAMAGE_50P_UNDEAD.setMagnitude(((Double)Config.INSTANCE.damageBonusUndeadMultiplier.get()).floatValue());
        WeaponTraits.DAMAGE_ABSORB_25.setMagnitude(((Double)Config.INSTANCE.damageAbsorptionFactor.get()).floatValue());
        WeaponTraits.REACH_1.setMagnitude(((Double)Config.INSTANCE.reach1Value.get()).floatValue());
        WeaponTraits.REACH_2.setMagnitude(((Double)Config.INSTANCE.reach2Value.get()).floatValue());
        WeaponTraits.SWEEP_DAMAGE_HALF.setMagnitude(((Double)Config.INSTANCE.sweep2Percentage.get()).floatValue());
        WeaponTraits.SWEEP_DAMAGE_FULL.setMagnitude(((Double)Config.INSTANCE.sweep3Percentage.get()).floatValue());
        WeaponTraits.ARMOUR_PIERCING_50.setMagnitude(((Double)Config.INSTANCE.armorPiercePercentage.get()).floatValue());
        WeaponsmithTrades.initTradeLists();
    }

    public static void updateDisabledRecipe(String type, boolean disabled) {
        boolean containsValue = Config.INSTANCE.disabledRecipeTypes.contains(type);
        if (!containsValue && disabled) {
            Config.INSTANCE.disabledRecipeTypes.add(type);
        } else if (containsValue) {
            Config.INSTANCE.disabledRecipeTypes.remove(type);
        }
    }

    private static void updateMaterialValues(WeaponMaterial material, float baseDamage, int durability) {
        material.setAttackDamage(baseDamage);
        material.setMaxUses(durability);
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
        INSTANCE = (Config)specPair.getLeft();
        CONFIG_SPEC = (ForgeConfigSpec)specPair.getRight();
    }

    public class MaterialCategory {
        public ForgeConfigSpec.DoubleValue damage;
        public ForgeConfigSpec.IntValue durability;
        public ForgeConfigSpec.BooleanValue disableRecipes;
        private String materialName;

        private MaterialCategory(ForgeConfigSpec.Builder builder, String materialName, float damage, int durability) {
            builder.push(materialName);
            this.materialName = materialName;
            this.damage = builder.comment("Base Damage for " + materialName + " weapons").translation("config.spartanweaponry.material.base_damage").defineInRange("base_damage", (double)damage, 0.1, 100.0);
            this.durability = builder.comment("Durability for " + materialName + " weapons").translation("config.spartanweaponry.material.durability").defineInRange("durability", durability, 1, 100000);
            this.disableRecipes = builder.comment("Set to true to disable " + materialName + " weapons").translation("config.spartanweaponry.material.disable").worldRestart().define("disable", false);
            builder.pop();
        }

        public void updateDisabledRecipeList() {
            Config.updateDisabledRecipe(this.materialName, (Boolean)this.disableRecipes.get());
        }
    }

    public class RangedWeaponCategory {
        public ForgeConfigSpec.BooleanValue disableRecipes;
        private String weaponName;

        private RangedWeaponCategory(ForgeConfigSpec.Builder builder, String weaponClass, String weaponPlural) {
            builder.push(weaponClass);
            this.weaponName = weaponClass;
            this.disableRecipes = builder.comment("Disables all recipes for all " + weaponPlural + ".").translation("config.spartanweaponry.weapon.disable").worldRestart().define("disable", false);
            builder.pop();
        }

        public void updateDisabledRecipeList() {
            Config.updateDisabledRecipe(this.weaponName, (Boolean)this.disableRecipes.get());
        }
    }

    public class WeaponCategory {
        public ForgeConfigSpec.BooleanValue disableRecipes;
        public ForgeConfigSpec.DoubleValue speed;
        public ForgeConfigSpec.DoubleValue baseDamage;
        public ForgeConfigSpec.DoubleValue damageMultipler;
        private String weaponName;

        private WeaponCategory(ForgeConfigSpec.Builder builder, String weaponClass, String weaponPlural, float defaultSpeed, float defaultBaseDamage, float defaultDamageMuliplier) {
            builder.push(weaponClass);
            this.weaponName = weaponClass;
            this.disableRecipes = builder.comment("Disables all recipes for all " + weaponPlural + ".").translation("config.spartanweaponry.weapon.disable").worldRestart().define("disable", false);
            this.speed = builder.comment("Attack speed of " + weaponPlural + ".").translation("config.spartanweaponry.weapon.speed").defineInRange("speed", (double)defaultSpeed, 0.0, 4.0);
            this.baseDamage = builder.comment("Base Damage of " + weaponPlural + ".").translation("config.spartanweaponry.weapon.base_damage").defineInRange("base_damage", (double)defaultBaseDamage, 0.1, 100.0);
            this.damageMultipler = builder.comment("Damage Multiplier for " + weaponPlural + ".").translation("config.spartanweaponry.weapon.damage_multiplier").defineInRange("damage_multiplier", (double)defaultDamageMuliplier, 0.1, 10.0);
            builder.pop();
        }

        public void updateDisabledRecipeList() {
            Config.updateDisabledRecipe(this.weaponName, (Boolean)this.disableRecipes.get());
        }
    }
}

