/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.util;

import com.google.gson.stream.JsonWriter;
import com.oblivioussp.spartanweaponry.api.WeaponMaterial;
import com.oblivioussp.spartanweaponry.init.ModItems;
import com.oblivioussp.spartanweaponry.util.Log;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.tags.ItemTags;

public class RecipeJsonGenerator {
    public static int newFilesGenerated = 0;
    public static int oldFilesOverwritten = 0;

    public static void generate() {
        newFilesGenerated = 0;
        oldFilesOverwritten = 0;
        String subDir = "recipes";
        File dir = new File(subDir);
        if (!dir.exists()) {
            Log.info("Recipe subfolder doesn't exist! Making directory.");
            dir.mkdirs();
        }
        List<WeaponMaterial> materials = Arrays.asList(WeaponMaterial.WOOD, WeaponMaterial.STONE, WeaponMaterial.IRON, WeaponMaterial.GOLD, WeaponMaterial.DIAMOND, WeaponMaterial.LEATHER, WeaponMaterial.COPPER, WeaponMaterial.TIN, WeaponMaterial.BRONZE, WeaponMaterial.STEEL, WeaponMaterial.SILVER, WeaponMaterial.INVAR, WeaponMaterial.PLATINUM, WeaponMaterial.ELECTRUM, WeaponMaterial.NICKEL, WeaponMaterial.LEAD);
        KeyEntry keyHandle = new KeyEntry('h', ModItems.handle.getItem().getRegistryName().toString(), false);
        KeyEntry keyPole = new KeyEntry('e', ModItems.pole.getItem().getRegistryName().toString(), false);
        KeyEntry keyWoodLog = new KeyEntry('w', ItemTags.field_200038_h.func_230234_a_().toString(), true);
        KeyEntry keyWoodPlank = new KeyEntry('p', ItemTags.field_199905_b.func_230234_a_().toString(), true);
        KeyEntry keyWoodStick = new KeyEntry('s', "forge:rods/wooden", true);
        KeyEntry keyIronIngot = new KeyEntry('i', "forge:ingots/iron", true);
        KeyEntry keyIronNugget = new KeyEntry('n', "forge:nuggets/iron", true);
        KeyEntry keyGoldIngot = new KeyEntry('g', "forge:ingots/gold", true);
        KeyEntry keyDiamond = new KeyEntry('d', "forge:gems/diamond", true);
        KeyEntry keyString = new KeyEntry('t', "forge:string", true);
        KeyEntry keyLeather = new KeyEntry('l', "forge:leather", true);
        KeyEntry keyWool = new KeyEntry('o', ItemTags.field_199904_a.func_230234_a_().toString(), true);
        KeyEntry keyBow = new KeyEntry('b', Items.field_151031_f.getRegistryName().toString(), false);
        KeyEntry keyTripwireHook = new KeyEntry('k', Items.field_221737_dE.getRegistryName().toString(), false);
        KeyEntry keyFeather = new KeyEntry('f', "forge:feathers", true);
        KeyEntry keyGlowstone = new KeyEntry('g', "forge:dusts/glowstone", true);
        KeyEntry keyGunpowder = new KeyEntry('u', "forge:gunpowder", true);
        KeyEntry keyArrow = new KeyEntry('a', Items.field_151032_g.getRegistryName().toString(), false);
        KeyEntry keyArrowTagged = new KeyEntry('a', "minecraft:arrows", true);
        KeyEntry keyBoltTagged = new KeyEntry('b', "spartanweaponry:bolts", true);
        KeyEntry keyExplosiveCharge = new KeyEntry('x', ModItems.explosiveCharge.getRegistryName().toString(), false);
        for (WeaponMaterial material : materials) {
            KeyEntry keyIngot = new KeyEntry('i', material.getTagName().toString(), true);
            Log.info("Generating recipes for material " + material.getMaterialName());
            RecipeJsonGenerator.generateOneRecipe("dagger", dir, material, new String[]{"i", "h"}, new KeyEntry[]{keyIngot, keyHandle}, "spartanweaponry:dagger_" + material.getMaterialName(), 1, new String[]{"dagger"}, material != WeaponMaterial.LEATHER);
            RecipeJsonGenerator.generateOneRecipe("longsword", dir, material, new String[]{" i ", " i ", "ihi"}, new KeyEntry[]{keyIngot, keyHandle}, "spartanweaponry:longsword_" + material.getMaterialName(), 1, new String[]{"longsword"}, material != WeaponMaterial.LEATHER);
            RecipeJsonGenerator.generateOneRecipe("katana", dir, material, new String[]{"  i", " i ", "h  "}, new KeyEntry[]{keyIngot, keyHandle}, "spartanweaponry:katana_" + material.getMaterialName(), 1, new String[]{"katana"}, material != WeaponMaterial.LEATHER);
            RecipeJsonGenerator.generateOneRecipe("saber", dir, material, new String[]{" i", " i", "ih"}, new KeyEntry[]{keyIngot, keyHandle}, "spartanweaponry:saber_" + material.getMaterialName(), 1, new String[]{"saber"}, material != WeaponMaterial.LEATHER);
            RecipeJsonGenerator.generateOneRecipe("rapier", dir, material, new String[]{"  i", "ii ", "hi "}, new KeyEntry[]{keyIngot, keyHandle}, "spartanweaponry:rapier_" + material.getMaterialName(), 1, new String[]{"rapier"}, material != WeaponMaterial.LEATHER);
            RecipeJsonGenerator.generateOneRecipe("greatsword", dir, material, new String[]{" i ", "iii", "ihi"}, new KeyEntry[]{keyIngot, keyHandle}, "spartanweaponry:greatsword_" + material.getMaterialName(), 1, new String[]{"greatsword"}, material != WeaponMaterial.LEATHER);
            RecipeJsonGenerator.generateOneRecipe("battle_hammer", dir, material, new String[]{"iii", "iii", " h "}, new KeyEntry[]{keyIngot, keyHandle}, "spartanweaponry:hammer_" + material.getMaterialName(), 1, new String[]{"battle_hammer"}, material != WeaponMaterial.LEATHER);
            RecipeJsonGenerator.generateOneRecipe("warhammer", dir, material, new String[]{" i ", "ii ", " h "}, new KeyEntry[]{keyIngot, keyHandle}, "spartanweaponry:warhammer_" + material.getMaterialName(), 1, new String[]{"warhammer"}, material != WeaponMaterial.LEATHER);
            RecipeJsonGenerator.generateOneRecipe("spear", dir, material, new String[]{"i", "e"}, new KeyEntry[]{keyIngot, keyPole}, "spartanweaponry:spear_" + material.getMaterialName(), 1, new String[]{"spear"}, material != WeaponMaterial.LEATHER);
            RecipeJsonGenerator.generateOneRecipe("halberd", dir, material, new String[]{" i", "ii", "ie"}, new KeyEntry[]{keyIngot, keyPole}, "spartanweaponry:halberd_" + material.getMaterialName(), 1, new String[]{"halberd"}, material != WeaponMaterial.LEATHER);
            RecipeJsonGenerator.generateOneRecipe("pike", dir, material, new String[]{"i", "e", "e"}, new KeyEntry[]{keyIngot, keyPole}, "spartanweaponry:pike_" + material.getMaterialName(), 1, new String[]{"pike"}, material != WeaponMaterial.LEATHER);
            RecipeJsonGenerator.generateOneRecipe("lance", dir, material, new String[]{"  i", "ie ", "hi "}, new KeyEntry[]{keyIngot, keyHandle, keyPole}, "spartanweaponry:lance_" + material.getMaterialName(), 1, new String[]{"lance"}, material != WeaponMaterial.LEATHER);
            RecipeJsonGenerator.generateOneRecipe("longbow", dir, material, new String[]{"hsi", "s t", "itt"}, new KeyEntry[]{keyIngot, keyHandle, keyWoodStick, keyString}, "spartanweaponry:longbow_" + material.getMaterialName(), 1, new String[]{"longbow"}, material != WeaponMaterial.STONE);
            RecipeJsonGenerator.generateOneRecipe("heavy_crossbow", dir, material, new String[]{"ibi", "pkp", " h "}, new KeyEntry[]{keyIngot, keyHandle, keyWoodPlank, keyBow, keyTripwireHook}, "spartanweaponry:heavy_crossbow_" + material.getMaterialName(), 1, new String[]{"heavy_crossbow"}, material != WeaponMaterial.STONE);
            RecipeJsonGenerator.generateOneRecipe("throwing_knife", dir, material, new String[]{"hi"}, new KeyEntry[]{keyIngot, keyHandle}, "spartanweaponry:throwing_knife_" + material.getMaterialName(), 1, new String[]{"throwing_knife"}, material != WeaponMaterial.LEATHER);
            RecipeJsonGenerator.generateOneRecipe("tomahawk", dir, material, new String[]{"hi", " i"}, new KeyEntry[]{keyIngot, keyHandle}, "spartanweaponry:tomahawk_" + material.getMaterialName(), 1, new String[]{"tomahawk"}, material != WeaponMaterial.LEATHER);
            RecipeJsonGenerator.generateOneRecipe("javelin", dir, material, new String[]{"ei"}, new KeyEntry[]{keyIngot, keyPole}, "spartanweaponry:javelin_" + material.getMaterialName(), 1, new String[]{"javelin"}, material != WeaponMaterial.LEATHER);
            RecipeJsonGenerator.generateOneRecipe("boomerang", dir, material, new String[]{"ipp", "p  ", "p  "}, new KeyEntry[]{keyIngot, keyWoodPlank}, "spartanweaponry:boomerang_" + material.getMaterialName(), 1, new String[]{"boomerang"}, material != WeaponMaterial.LEATHER);
            RecipeJsonGenerator.generateOneRecipe("battleaxe", dir, material, new String[]{"iii", "isi", " h "}, new KeyEntry[]{keyIngot, keyHandle, keyWoodStick}, "spartanweaponry:battleaxe_" + material.getMaterialName(), 1, new String[]{"battleaxe"}, material != WeaponMaterial.LEATHER);
            RecipeJsonGenerator.generateOneRecipe("flanged_mace", dir, material, new String[]{" ii", " si", "h  "}, new KeyEntry[]{keyIngot, keyHandle, keyWoodStick}, "spartanweaponry:flanged_mace_" + material.getMaterialName(), 1, new String[]{"flanged_mace"}, material != WeaponMaterial.LEATHER);
            RecipeJsonGenerator.generateOneRecipe("glaive", dir, material, new String[]{" i", " i", " e"}, new KeyEntry[]{keyIngot, keyPole}, "spartanweaponry:glaive_" + material.getMaterialName(), 1, new String[]{"glaive"}, material != WeaponMaterial.LEATHER);
            RecipeJsonGenerator.generateOneRecipe("quarterstaff", dir, material, new String[]{"e", "i"}, new KeyEntry[]{keyIngot, keyPole}, "spartanweaponry:quarterstaff_" + material.getMaterialName(), 1, new String[]{"quarterstaff"}, material != WeaponMaterial.LEATHER);
        }
        RecipeJsonGenerator.generateOneRecipe("handle", dir, null, null, new KeyEntry[]{keyWoodStick, keyString}, ModItems.handle.getRegistryName().toString(), 1, null, true);
        RecipeJsonGenerator.generateOneRecipe("handle_wool", dir, null, null, new KeyEntry[]{keyWoodStick, keyWoodStick, keyWoodStick, keyWoodStick, keyWool}, ModItems.handle.getRegistryName().toString(), 4, null, true);
        RecipeJsonGenerator.generateOneRecipe("handle_leather", dir, null, null, new KeyEntry[]{keyWoodStick, keyWoodStick, keyWoodStick, keyWoodStick, keyLeather}, ModItems.handle.getRegistryName().toString(), 4, null, true);
        RecipeJsonGenerator.generateOneRecipe("pole", dir, null, new String[]{"s ", "st", "s "}, new KeyEntry[]{keyWoodStick, keyWoodStick, keyWoodStick, keyString}, ModItems.pole.getRegistryName().toString(), 1, null, true);
        RecipeJsonGenerator.generateOneRecipe("pole_wool", dir, null, new String[]{"sss", "sss", "sso"}, new KeyEntry[]{keyWoodStick, keyWoodStick, keyWoodStick, keyWoodStick, keyWoodStick, keyWoodStick, keyWoodStick, keyWoodStick, keyWool}, ModItems.pole.getRegistryName().toString(), 4, null, true);
        RecipeJsonGenerator.generateOneRecipe("pole_leather", dir, null, new String[]{"sss", "sss", "ssl"}, new KeyEntry[]{keyWoodStick, keyLeather}, ModItems.pole.getRegistryName().toString(), 4, null, true);
        RecipeJsonGenerator.generateOneRecipe("explosive_charge", dir, null, new String[]{"uuu", "nnn", "uuu"}, new KeyEntry[]{keyGunpowder, keyIronNugget}, ModItems.explosiveCharge.getRegistryName().toString(), 4, null, true);
        RecipeJsonGenerator.generateOneRecipe("club", dir, null, new String[]{" w", "w "}, new KeyEntry[]{keyWoodLog}, ModItems.clubWood.getRegistryName().toString(), 1, new String[]{"club"}, true);
        RecipeJsonGenerator.generateOneRecipe("club_studded", dir, null, new String[]{"ci"}, new KeyEntry[]{new KeyEntry('c', ModItems.clubWood.getRegistryName().toString(), false), keyIronIngot}, ModItems.clubStudded.getRegistryName().toString(), 1, new String[]{"club"}, true);
        RecipeJsonGenerator.generateOneRecipe("cestus", dir, null, new String[]{"lo"}, new KeyEntry[]{keyLeather, keyWool}, ModItems.cestus.getRegistryName().toString(), 1, new String[]{"cestus"}, true);
        RecipeJsonGenerator.generateOneRecipe("cestus_studded", dir, null, new String[]{"ci"}, new KeyEntry[]{new KeyEntry('c', ModItems.cestus.getRegistryName().toString(), false), keyIronIngot}, ModItems.cestusStudded.getRegistryName().toString(), 1, new String[]{"cestus"}, true);
        RecipeJsonGenerator.generateOneRecipe("arrow_wood", dir, null, new String[]{"p", "s", "f"}, new KeyEntry[]{keyWoodPlank, keyWoodStick, keyFeather}, ModItems.arrowWood.getRegistryName().toString(), 4, new String[]{"arrows"}, true);
        RecipeJsonGenerator.generateOneRecipe("arrow_iron", dir, null, new String[]{"i", "s", "f"}, new KeyEntry[]{keyIronIngot, keyWoodStick, keyFeather}, ModItems.arrowIron.getRegistryName().toString(), 4, new String[]{"arrows"}, true);
        RecipeJsonGenerator.generateOneRecipe("arrow_diamond", dir, null, new String[]{"d", "s", "f"}, new KeyEntry[]{keyDiamond, keyWoodStick, keyFeather}, ModItems.arrowDiamond.getRegistryName().toString(), 4, new String[]{"arrows"}, true);
        RecipeJsonGenerator.generateOneRecipe("arrow_explosive", dir, null, null, new KeyEntry[]{keyArrow, keyExplosiveCharge}, ModItems.arrowExplosive.getRegistryName().toString(), 1, new String[]{"arrows"}, true);
        RecipeJsonGenerator.generateOneRecipe("bolt", dir, null, new String[]{"  i", " n ", "f  "}, new KeyEntry[]{keyIronIngot, keyIronNugget, keyFeather}, ModItems.bolt.getRegistryName().toString(), 4, new String[]{"bolts"}, true);
        RecipeJsonGenerator.generateOneRecipe("bolt_spectral", dir, null, null, new KeyEntry[]{new KeyEntry('b', ModItems.bolt.getRegistryName().toString(), false), keyGlowstone, keyGlowstone}, ModItems.spectralBolt.getRegistryName().toString(), 1, new String[]{"bolts"}, true);
        RecipeJsonGenerator.generateOneRecipe("bolt_diamond", dir, null, new String[]{"  d", " n ", "f  "}, new KeyEntry[]{keyDiamond, keyIronNugget, keyFeather}, ModItems.boltDiamond.getRegistryName().toString(), 4, new String[]{"bolts"}, true);
        RecipeJsonGenerator.generateTippedProjectileRecipe("arrow_wood_tipped", (Item)ModItems.arrowWood, (Item)ModItems.tippedArrowWood);
        RecipeJsonGenerator.generateTippedProjectileRecipe("arrow_iron_tipped", (Item)ModItems.arrowIron, (Item)ModItems.tippedArrowIron);
        RecipeJsonGenerator.generateTippedProjectileRecipe("arrow_diamond_tipped", (Item)ModItems.arrowDiamond, (Item)ModItems.tippedArrowDiamond);
        RecipeJsonGenerator.generateTippedProjectileRecipe("bolt_tipped", ModItems.bolt, ModItems.tippedBolt);
        RecipeJsonGenerator.generateTippedProjectileRecipe("bolt_diamond_tipped", ModItems.boltDiamond, ModItems.tippedBoltDiamond);
        RecipeJsonGenerator.generateOneRecipe("quiver_arrow_small", dir, null, new String[]{"ltl", "lal", "iii"}, new KeyEntry[]{keyLeather, keyString, keyArrowTagged, keyIronIngot}, ModItems.quiverArrowSmall.getRegistryName().toString(), 1, new String[]{"quivers"}, true);
        RecipeJsonGenerator.generateOneRecipe("quiver_arrow_medium", dir, null, new String[]{"ltl", "lal", "ggg"}, new KeyEntry[]{keyLeather, keyString, keyArrowTagged, keyGoldIngot}, ModItems.quiverArrowMedium.getRegistryName().toString(), 1, new String[]{"quivers"}, true);
        RecipeJsonGenerator.generateOneRecipe("quiver_arrow_large", dir, null, new String[]{"ltl", "lal", "ddd"}, new KeyEntry[]{keyLeather, keyString, keyArrowTagged, keyDiamond}, ModItems.quiverArrowLarge.getRegistryName().toString(), 1, new String[]{"quivers"}, true);
        RecipeJsonGenerator.generateOneRecipe("quiver_bolt_small", dir, null, new String[]{"ltl", "lbl", "iii"}, new KeyEntry[]{keyLeather, keyString, keyBoltTagged, keyIronIngot}, ModItems.quiverBoltSmall.getRegistryName().toString(), 1, new String[]{"quivers", "bolts"}, true);
        RecipeJsonGenerator.generateOneRecipe("quiver_bolt_medium", dir, null, new String[]{"ltl", "lbl", "ggg"}, new KeyEntry[]{keyLeather, keyString, keyBoltTagged, keyGoldIngot}, ModItems.quiverBoltMedium.getRegistryName().toString(), 1, new String[]{"quivers", "bolts"}, true);
        RecipeJsonGenerator.generateOneRecipe("quiver_bolt_large", dir, null, new String[]{"ltl", "lbl", "ddd"}, new KeyEntry[]{keyLeather, keyString, keyBoltTagged, keyDiamond}, ModItems.quiverBoltLarge.getRegistryName().toString(), 1, new String[]{"quivers", "bolts"}, true);
        RecipeJsonGenerator.generateOneRecipe("dynamite", dir, null, new String[]{"  t", " x ", "x  "}, new KeyEntry[]{keyString, keyExplosiveCharge}, ModItems.dynamite.getRegistryName().toString(), 2, new String[]{"explosive"}, true);
        Log.info(String.format("Finished generating recipes! %d new; %d overwritten", newFilesGenerated, oldFilesOverwritten));
    }

    public static void generateOneRecipe(String weaponType, File dir, WeaponMaterial material, String[] pattern, KeyEntry[] keys, String result, int count, String[] recipeTypes, boolean writeToFile) {
        File file;
        if (!writeToFile) {
            return;
        }
        String weaponName = weaponType;
        if (material != null) {
            weaponName = weaponName + "_" + material.getMaterialName();
        }
        if ((file = new File(dir, weaponName + ".json")).exists()) {
            ++oldFilesOverwritten;
        } else {
            ++newFilesGenerated;
        }
        boolean isModdedMaterial = material != null && material != WeaponMaterial.WOOD && material != WeaponMaterial.STONE && material != WeaponMaterial.IRON && material != WeaponMaterial.GOLD && material != WeaponMaterial.DIAMOND && material != WeaponMaterial.LEATHER;
        try {
            JsonWriter json = new JsonWriter((Writer)new FileWriter(file));
            json.setIndent("  ");
            json.beginObject();
            if (pattern != null) {
                json.name("type").value("minecraft:crafting_shaped");
                json.name("pattern").beginArray();
                for (String string : pattern) {
                    json.value(string);
                }
                json.endArray();
                json.name("key").beginObject();
                for (KeyEntry keyEntry : keys) {
                    json.name(Character.toString(keyEntry.getKey())).beginObject();
                    if (keyEntry.isTag()) {
                        json.name("tag").value(keyEntry.getValue());
                    } else {
                        json.name("item").value(keyEntry.getValue());
                    }
                    json.endObject();
                }
                json.endObject();
            } else {
                json.name("type").value("minecraft:crafting_shapeless");
                json.name("ingredients").beginArray();
                for (KeyEntry keyEntry : keys) {
                    json.beginArray();
                    json.beginObject();
                    if (keyEntry.isTag()) {
                        json.name("tag").value(keyEntry.getValue());
                    } else {
                        json.name("item").value(keyEntry.getValue());
                    }
                    json.endObject();
                    json.endArray();
                }
                json.endArray();
            }
            json.name("result").beginObject();
            json.name("item").value(result);
            if (count > 1) {
                json.name("count").value((long)count);
            }
            json.endObject();
            if (recipeTypes != null) {
                json.name("conditions").beginArray();
                json.beginObject();
                json.name("type").value("spartanweaponry:type_disabled");
                json.name("disabled").beginArray();
                for (String string : recipeTypes) {
                    json.value(string);
                }
                if (isModdedMaterial) {
                    json.value(material.getMaterialName());
                }
                json.endArray();
                json.endObject();
                if (isModdedMaterial) {
                    json.beginObject();
                    json.name("type").value("forge:not");
                    json.name("value").beginObject();
                    json.name("type").value("forge:tag_empty");
                    String tagName = material.getTagName().toString();
                    json.name("tag").value(tagName);
                    json.endObject();
                    json.endObject();
                }
                json.endArray();
            }
            json.endObject();
            json.close();
        }
        catch (IOException e) {
            Log.error("Couldn't properly close file: " + file.getName() + " - " + e.getMessage());
        }
        catch (Exception e) {
            Log.error("Couldn't generate recipe file: \"" + file.getName() + "\" - " + e.getMessage());
        }
    }

    public static void generateTippedProjectileRecipe(String name, Item projIn, Item projOut) {
        File file = new File("recipes", name + ".json");
        if (file.exists()) {
            ++oldFilesOverwritten;
        } else {
            ++newFilesGenerated;
        }
        try {
            JsonWriter json = new JsonWriter((Writer)new FileWriter(file));
            json.setIndent("  ");
            json.beginObject();
            json.name("type").value("spartanweaponry:tipped_projectile");
            json.name("projectile").value(projIn.getRegistryName().toString());
            json.name("result").value(projOut.getRegistryName().toString());
            json.endObject();
            json.close();
        }
        catch (IOException e) {
            Log.error("Couldn't properly close file: " + file.getName() + " - " + e.getMessage());
        }
    }

    private static class KeyEntry {
        private char key;
        private String value;
        private boolean isTag;

        private KeyEntry(char key, String value, boolean isTag) {
            this.key = key;
            this.value = value;
            this.isTag = isTag;
        }

        public char getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isTag() {
            return this.isTag;
        }
    }
}

