/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.util;

import com.oblivioussp.spartanweaponry.api.WeaponTraits;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import com.oblivioussp.spartanweaponry.item.SwordBaseItem;
import com.oblivioussp.spartanweaponry.util.DamageSourcesSW;
import com.oblivioussp.spartanweaponry.util.Log;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.boss.dragon.EnderDragonPartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class WeaponHelper {
    public static float dealArmourPiercingDamage(LivingEntity attacker, float piercingFactor, LivingEntity victim, float dmgAmount) {
        float piercingDamage = dmgAmount * piercingFactor;
        if (attacker instanceof PlayerEntity) {
            WeaponHelper.dealExtraDamageIngoringArmour(victim, DamageSourcesSW.causeArmourPiercingPlayerDamage((PlayerEntity)attacker), piercingDamage);
            Log.debug("Dealing " + piercingDamage + " armour-piercing damage as a player!");
        } else {
            WeaponHelper.dealExtraDamageIngoringArmour(victim, DamageSourcesSW.causeArmourPiercingMobDamage(attacker), piercingDamage);
            Log.debug("Dealing " + piercingDamage + " armour-piercing damage as a mob!");
        }
        Log.debug("Dealing " + (dmgAmount - piercingDamage) + " normal damage!");
        return dmgAmount - piercingDamage;
    }

    public static void dealExtraDamageIngoringArmour(LivingEntity entity, DamageSource dmgSrc, float dmgAmount) {
        if (!entity.func_180431_b(dmgSrc)) {
            if (dmgAmount <= 0.0f) {
                return;
            }
            float f = dmgAmount = WeaponHelper.applyPotionDamageCalculations(entity, dmgSrc, dmgAmount);
            dmgAmount = Math.max(dmgAmount - entity.func_110139_bj(), 0.0f);
            entity.func_110149_m(entity.func_110139_bj() - (f - dmgAmount));
            if (dmgAmount != 0.0f) {
                float f1 = entity.func_110143_aJ();
                entity.func_70606_j(f1 - dmgAmount);
                entity.func_110142_aN().func_94547_a(dmgSrc, f1, dmgAmount);
                entity.func_110149_m(entity.func_110139_bj() - dmgAmount);
            }
        }
    }

    public static float applyPotionDamageCalculations(LivingEntity entity, DamageSource source, float damage) {
        if (source.func_151517_h()) {
            return damage;
        }
        if (entity.func_70644_a(Effects.field_76429_m) && source != DamageSource.field_76380_i) {
            int i = (entity.func_70660_b(Effects.field_76429_m).func_76458_c() + 1) * 5;
            int j = 25 - i;
            float f = damage * (float)j;
            damage = f / 25.0f;
        }
        if (damage <= 0.0f) {
            return 0.0f;
        }
        int k = EnchantmentHelper.func_77508_a((Iterable)entity.func_184193_aE(), (DamageSource)source);
        if (k > 0) {
            damage = CombatRules.func_188401_b((float)damage, (float)k);
        }
        return damage;
    }

    public static void inflictAttackDamage(SwordBaseItem item, PlayerEntity player, Entity targetEntity) {
        if (targetEntity != null && player != null && targetEntity.func_70075_an() && !targetEntity.func_85031_j((Entity)player)) {
            float f = (float)player.func_110148_a(Attributes.field_233823_f_).func_111126_e();
            if (f <= 0.0f) {
                f = 0.4f;
            }
            float f1 = targetEntity instanceof LivingEntity ? EnchantmentHelper.func_152377_a((ItemStack)player.func_184614_ca(), (CreatureAttribute)((LivingEntity)targetEntity).func_70668_bt()) : EnchantmentHelper.func_152377_a((ItemStack)player.func_184614_ca(), (CreatureAttribute)CreatureAttribute.field_223222_a_);
            float f2 = player.func_184825_o(0.5f);
            f1 *= f2;
            player.func_184821_cY();
            if ((f *= 0.2f + f2 * f2 * 0.8f) > 0.0f || f1 > 0.0f) {
                ItemStack itemstack;
                boolean flag = f2 > 0.9f;
                boolean flag1 = false;
                int i = 0;
                i += EnchantmentHelper.func_77501_a((LivingEntity)player);
                if (player.func_70051_ag() && flag) {
                    player.field_70170_p.func_184148_a((PlayerEntity)null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187721_dT, player.func_184176_by(), 1.0f, 1.0f);
                    ++i;
                    flag1 = true;
                }
                boolean flag2 = flag && player.field_70143_R > 0.0f && !player.func_233570_aj_() && !player.func_70617_f_() && !player.func_70090_H() && !player.func_70644_a(Effects.field_76440_q) && !player.func_184218_aH() && targetEntity instanceof LivingEntity;
                boolean bl = flag2 = flag2 && !player.func_70051_ag();
                if (flag2) {
                    f *= 1.5f;
                }
                f += f1;
                boolean flag3 = false;
                double d0 = player.field_70140_Q - player.field_70141_P;
                if (flag && !flag2 && !flag1 && d0 < (double)player.func_70689_ay() && !(itemstack = player.func_184586_b(Hand.MAIN_HAND)).func_190926_b() && itemstack.func_77973_b() == item) {
                    flag3 = true;
                }
                float f4 = 0.0f;
                boolean flag4 = false;
                int j = EnchantmentHelper.func_90036_a((LivingEntity)player);
                if (targetEntity instanceof LivingEntity) {
                    f4 = ((LivingEntity)targetEntity).func_110143_aJ();
                    if (j > 0 && !targetEntity.func_70027_ad()) {
                        flag4 = true;
                        targetEntity.func_70015_d(1);
                    }
                }
                Vector3d motionVec = targetEntity.func_213322_ci();
                boolean flag5 = targetEntity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), f);
                if (flag5) {
                    if (i > 0) {
                        if (targetEntity instanceof LivingEntity) {
                            ((LivingEntity)targetEntity).func_233627_a_((float)i * 0.5f, (double)MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)))));
                        } else {
                            targetEntity.func_70024_g((double)(-MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))) * (float)i * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180))) * (float)i * 0.5f));
                        }
                        player.func_213317_d(player.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
                        player.func_70031_b(false);
                    }
                    WeaponTrait sweepProp = item.getFirstWeaponTraitWithType("sweep_damage");
                    if (flag3 && sweepProp != null) {
                        float sweepDamage = item.getDirectAttackDamage() * (sweepProp.getMagnitude() / 100.0f);
                        for (LivingEntity entitylivingbase : player.field_70170_p.func_217357_a(LivingEntity.class, targetEntity.func_174813_aQ().func_72321_a(1.0, 0.25, 1.0))) {
                            float reach;
                            WeaponTrait reachTrait = item.getFirstWeaponTraitWithType("reach");
                            float f3 = reach = reachTrait != null ? reachTrait.getMagnitude() : 3.0f;
                            if (entitylivingbase == player || entitylivingbase == targetEntity || player.func_184191_r((Entity)entitylivingbase) || !(player.func_70068_e((Entity)entitylivingbase) < (double)(reach * reach))) continue;
                            entitylivingbase.func_233627_a_(0.4f, (double)MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)))));
                            entitylivingbase.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), sweepDamage);
                        }
                        player.field_70170_p.func_184148_a((PlayerEntity)null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187730_dW, player.func_184176_by(), 1.0f, 1.0f);
                        player.func_184810_cG();
                    }
                    if (targetEntity instanceof ServerPlayerEntity && targetEntity.field_70133_I) {
                        ((ServerPlayerEntity)targetEntity).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket(targetEntity));
                        targetEntity.field_70133_I = false;
                        targetEntity.func_213317_d(motionVec);
                    }
                    if (flag2) {
                        player.field_70170_p.func_184148_a((PlayerEntity)null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187718_dS, player.func_184176_by(), 1.0f, 1.0f);
                        player.func_71009_b(targetEntity);
                    }
                    if (!flag2 && !flag3) {
                        if (flag) {
                            player.field_70170_p.func_184148_a((PlayerEntity)null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187727_dV, player.func_184176_by(), 1.0f, 1.0f);
                        } else {
                            player.field_70170_p.func_184148_a((PlayerEntity)null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187733_dX, player.func_184176_by(), 1.0f, 1.0f);
                        }
                    }
                    if (f1 > 0.0f) {
                        player.func_71047_c(targetEntity);
                    }
                    player.func_130011_c(targetEntity);
                    if (targetEntity instanceof LivingEntity) {
                        EnchantmentHelper.func_151384_a((LivingEntity)((LivingEntity)targetEntity), (Entity)player);
                    }
                    EnchantmentHelper.func_151385_b((LivingEntity)player, (Entity)targetEntity);
                    ItemStack itemstack1 = player.func_184614_ca();
                    Entity entity = targetEntity;
                    if (targetEntity instanceof EnderDragonPartEntity) {
                        entity = ((EnderDragonPartEntity)targetEntity).field_213852_b;
                    }
                    if (!itemstack1.func_190926_b() && entity instanceof LivingEntity) {
                        itemstack1.func_77961_a((LivingEntity)entity, player);
                        if (itemstack1.func_190916_E() <= 0) {
                            ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)player, (ItemStack)itemstack1, (Hand)Hand.MAIN_HAND);
                            player.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                        }
                    }
                    if (targetEntity instanceof LivingEntity) {
                        float f5 = f4 - ((LivingEntity)targetEntity).func_110143_aJ();
                        player.func_195067_a(Stats.field_188111_y, Math.round(f5 * 10.0f));
                        if (j > 0) {
                            targetEntity.func_70015_d(j * 4);
                        }
                        if (player.field_70170_p instanceof ServerWorld && f5 > 2.0f) {
                            int k = (int)((double)f5 * 0.5);
                            ((ServerWorld)player.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197615_h, targetEntity.func_226277_ct_(), targetEntity.func_226278_cu_() + (double)(targetEntity.func_213302_cg() * 0.5f), targetEntity.func_226281_cx_(), k, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                    player.func_71020_j(0.3f);
                } else {
                    player.field_70170_p.func_184148_a((PlayerEntity)null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187724_dU, player.func_184176_by(), 1.0f, 1.0f);
                    if (flag4) {
                        targetEntity.func_70066_B();
                    }
                }
                if (item.hasWeaponTrait(WeaponTraits.QUICK_STRIKE)) {
                    targetEntity.field_70172_ad = 14;
                }
            }
        }
    }
}

