/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.EnumKeyType;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityController;
import com.jaquadro.minecraft.storagedrawers.config.CommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class BlockController
extends HorizontalDirectionalBlock
implements INetworked,
EntityBlock {
    public BlockController(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Direction blockDir = (Direction)state.m_61143_((Property)f_54117_);
        TileEntityController te = this.getTileEntitySafe(world, pos);
        ItemStack item = player.m_150109_().m_36056_();
        if (!item.m_41619_() && this.toggle(world, pos, player, item.m_41720_())) {
            return InteractionResult.SUCCESS;
        }
        if (blockDir != hit.m_82434_()) {
            return InteractionResult.CONSUME;
        }
        if (!world.f_46443_) {
            if (((Boolean)CommonConfig.GENERAL.debugTrace.get()).booleanValue() && item.m_41619_()) {
                te.printDebugInfo();
            }
            te.interactPutItemsIntoInventory(player);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean toggle(Level world, BlockPos pos, Player player, Item item) {
        if (world.f_46443_ || item == null) {
            return false;
        }
        if (item == ModItems.DRAWER_KEY) {
            this.toggle(world, pos, player, EnumKeyType.DRAWER);
        } else if (item == ModItems.SHROUD_KEY) {
            this.toggle(world, pos, player, EnumKeyType.CONCEALMENT);
        } else if (item == ModItems.QUANTIFY_KEY) {
            this.toggle(world, pos, player, EnumKeyType.QUANTIFY);
        } else {
            return false;
        }
        return true;
    }

    public void toggle(Level world, BlockPos pos, Player player, EnumKeyType keyType) {
        if (world.f_46443_) {
            return;
        }
        TileEntityController te = this.getTileEntitySafe(world, pos);
        if (te == null) {
            return;
        }
        switch (keyType) {
            case DRAWER: {
                te.toggleLock(EnumSet.allOf(LockAttribute.class), LockAttribute.LOCK_POPULATED, player.m_36316_());
                break;
            }
            case CONCEALMENT: {
                te.toggleShroud(player.m_36316_());
                break;
            }
            case QUANTIFY: {
                te.toggleQuantified(player.m_36316_());
            }
        }
    }

    public void m_7458_(BlockState state, ServerLevel world, BlockPos pos, Random rand) {
        if (world.f_46443_) {
            return;
        }
        TileEntityController te = this.getTileEntitySafe((Level)world, pos);
        if (te == null) {
            return;
        }
        te.updateCache();
        world.m_6219_().m_5945_(pos, (Object)this, 100);
    }

    public TileEntityController newBlockEntity(BlockPos pos, BlockState state) {
        return new TileEntityController(pos, state);
    }

    public TileEntityController getTileEntity(BlockGetter blockAccess, BlockPos pos) {
        BlockEntity tile = blockAccess.m_7702_(pos);
        return tile instanceof TileEntityController ? (TileEntityController)tile : null;
    }

    public TileEntityController getTileEntitySafe(Level world, BlockPos pos) {
        TileEntityController tile = this.getTileEntity((BlockGetter)world, pos);
        if (tile == null) {
            tile = this.newBlockEntity(pos, world.m_8055_(pos));
            world.m_151523_((BlockEntity)tile);
        }
        return tile;
    }
}

