/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.TileDataShim;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.extensions.IForgeBlockEntity;

public class ChamTileEntity
extends BlockEntity
implements IForgeBlockEntity {
    private CompoundTag failureSnapshot;
    private List<TileDataShim> fixedShims;
    private List<TileDataShim> portableShims;

    public ChamTileEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public boolean hasDataPacket() {
        return true;
    }

    public boolean dataPacketRequiresRenderUpdate() {
        return false;
    }

    public void injectData(TileDataShim shim) {
        if (this.fixedShims == null) {
            this.fixedShims = new ArrayList<TileDataShim>();
        }
        this.fixedShims.add(shim);
    }

    public void injectPortableData(TileDataShim shim) {
        if (this.portableShims == null) {
            this.portableShims = new ArrayList<TileDataShim>();
        }
        this.portableShims.add(shim);
    }

    public final void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.failureSnapshot = null;
        try {
            this.readFixed(tag);
            this.readPortable(tag);
        }
        catch (Throwable t) {
            this.trapLoadFailure(t, tag);
        }
    }

    public final void read(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public final CompoundTag m_6945_(CompoundTag tag) {
        super.m_6945_(tag);
        if (this.failureSnapshot != null) {
            this.restoreLoadFailure(tag);
            return tag;
        }
        try {
            tag = this.writeFixed(tag);
            tag = this.writePortable(tag);
        }
        catch (Throwable t) {
            StorageDrawers.log.error("Tile Save Failure.", t);
        }
        return tag;
    }

    public void readPortable(CompoundTag tag) {
        if (this.portableShims != null) {
            for (TileDataShim shim : this.portableShims) {
                shim.read(tag);
            }
        }
    }

    public CompoundTag writePortable(CompoundTag tag) {
        if (this.portableShims != null) {
            for (TileDataShim shim : this.portableShims) {
                tag = shim.write(tag);
            }
        }
        return tag;
    }

    protected void readFixed(CompoundTag tag) {
        if (this.fixedShims != null) {
            for (TileDataShim shim : this.fixedShims) {
                shim.read(tag);
            }
        }
    }

    protected CompoundTag writeFixed(CompoundTag tag) {
        if (this.fixedShims != null) {
            for (TileDataShim shim : this.fixedShims) {
                tag = shim.write(tag);
            }
        }
        return tag;
    }

    private void trapLoadFailure(Throwable t, CompoundTag tag) {
        this.failureSnapshot = tag.m_6426_();
        StorageDrawers.log.error("Tile Load Failure.", t);
    }

    private void restoreLoadFailure(CompoundTag tag) {
        for (String key : this.failureSnapshot.m_128431_()) {
            if (tag.m_128441_(key)) continue;
            tag.m_128365_(key, this.failureSnapshot.m_128423_(key).m_6426_());
        }
    }

    protected boolean loadDidFail() {
        return this.failureSnapshot != null;
    }

    public final CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_6945_(tag);
        return tag;
    }

    public final ClientboundBlockEntityDataPacket m_7033_() {
        return this.hasDataPacket() ? new ClientboundBlockEntityDataPacket(this.m_58899_(), 0, this.m_5995_()) : null;
    }

    public final void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (pkt != null && pkt.m_131708_() != null) {
            this.read(pkt.m_131708_());
        }
        if (this.dataPacketRequiresRenderUpdate() && this.m_58904_().f_46443_) {
            BlockState state = this.m_58904_().m_8055_(this.m_58899_());
            this.m_58904_().m_7260_(this.m_58899_(), state, state, 3);
        }
    }

    public void markBlockForUpdate() {
        if (this.m_58904_() != null && !this.m_58904_().f_46443_) {
            BlockState state = this.m_58904_().m_8055_(this.f_58858_);
            this.m_58904_().m_7260_(this.f_58858_, state, state, 3);
        }
    }

    public void markBlockForUpdateClient() {
        if (this.m_58904_() != null && this.m_58904_().f_46443_) {
            BlockState state = this.m_58904_().m_8055_(this.f_58858_);
            this.m_58904_().m_7260_(this.f_58858_, state, state, 3);
        }
    }

    public void markBlockForRenderUpdate() {
        if (this.m_58904_() == null) {
            return;
        }
        BlockState state = this.m_58904_().m_8055_(this.f_58858_);
        this.m_58904_().m_7260_(this.f_58858_, state, state, 2);
    }
}

