/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.core;

import com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockController;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockSlave;
import com.jaquadro.minecraft.storagedrawers.block.BlockStandardDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockTrim;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityController;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawersComp;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawersStandard;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntitySlave;
import com.jaquadro.minecraft.storagedrawers.client.renderer.TileEntityDrawersRenderer;
import com.jaquadro.minecraft.storagedrawers.core.ModItemGroup;
import com.jaquadro.minecraft.storagedrawers.item.ItemDrawers;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="storagedrawers")
public class ModBlocks {
    public static final BlockDrawers OAK_FULL_DRAWERS_1 = null;
    public static final BlockDrawers OAK_FULL_DRAWERS_2 = null;
    public static final BlockDrawers OAK_FULL_DRAWERS_4 = null;
    public static final BlockDrawers OAK_HALF_DRAWERS_1 = null;
    public static final BlockDrawers OAK_HALF_DRAWERS_2 = null;
    public static final BlockDrawers OAK_HALF_DRAWERS_4 = null;
    public static final BlockDrawers SPRUCE_FULL_DRAWERS_1 = null;
    public static final BlockDrawers SPRUCE_FULL_DRAWERS_2 = null;
    public static final BlockDrawers SPRUCE_FULL_DRAWERS_4 = null;
    public static final BlockDrawers SPRUCE_HALF_DRAWERS_1 = null;
    public static final BlockDrawers SPRUCE_HALF_DRAWERS_2 = null;
    public static final BlockDrawers SPRUCE_HALF_DRAWERS_4 = null;
    public static final BlockDrawers BIRCH_FULL_DRAWERS_1 = null;
    public static final BlockDrawers BIRCH_FULL_DRAWERS_2 = null;
    public static final BlockDrawers BIRCH_FULL_DRAWERS_4 = null;
    public static final BlockDrawers BIRCH_HALF_DRAWERS_1 = null;
    public static final BlockDrawers BIRCH_HALF_DRAWERS_2 = null;
    public static final BlockDrawers BIRCH_HALF_DRAWERS_4 = null;
    public static final BlockDrawers JUNGLE_FULL_DRAWERS_1 = null;
    public static final BlockDrawers JUNGLE_FULL_DRAWERS_2 = null;
    public static final BlockDrawers JUNGLE_FULL_DRAWERS_4 = null;
    public static final BlockDrawers JUNGLE_HALF_DRAWERS_1 = null;
    public static final BlockDrawers JUNGLE_HALF_DRAWERS_2 = null;
    public static final BlockDrawers JUNGLE_HALF_DRAWERS_4 = null;
    public static final BlockDrawers ACACIA_FULL_DRAWERS_1 = null;
    public static final BlockDrawers ACACIA_FULL_DRAWERS_2 = null;
    public static final BlockDrawers ACACIA_FULL_DRAWERS_4 = null;
    public static final BlockDrawers ACACIA_HALF_DRAWERS_1 = null;
    public static final BlockDrawers ACACIA_HALF_DRAWERS_2 = null;
    public static final BlockDrawers ACACIA_HALF_DRAWERS_4 = null;
    public static final BlockDrawers DARK_OAK_FULL_DRAWERS_1 = null;
    public static final BlockDrawers DARK_OAK_FULL_DRAWERS_2 = null;
    public static final BlockDrawers DARK_OAK_FULL_DRAWERS_4 = null;
    public static final BlockDrawers DARK_OAK_HALF_DRAWERS_1 = null;
    public static final BlockDrawers DARK_OAK_HALF_DRAWERS_2 = null;
    public static final BlockDrawers DARK_OAK_HALF_DRAWERS_4 = null;
    public static final BlockDrawers CRIMSON_FULL_DRAWERS_1 = null;
    public static final BlockDrawers CRIMSON_FULL_DRAWERS_2 = null;
    public static final BlockDrawers CRIMSON_FULL_DRAWERS_4 = null;
    public static final BlockDrawers CRIMSON_HALF_DRAWERS_1 = null;
    public static final BlockDrawers CRIMSON_HALF_DRAWERS_2 = null;
    public static final BlockDrawers CRIMSON_HALF_DRAWERS_4 = null;
    public static final BlockDrawers WARPED_FULL_DRAWERS_1 = null;
    public static final BlockDrawers WARPED_FULL_DRAWERS_2 = null;
    public static final BlockDrawers WARPED_FULL_DRAWERS_4 = null;
    public static final BlockDrawers WARPED_HALF_DRAWERS_1 = null;
    public static final BlockDrawers WARPED_HALF_DRAWERS_2 = null;
    public static final BlockDrawers WARPED_HALF_DRAWERS_4 = null;
    public static final BlockDrawers COMPACTING_DRAWERS_3 = null;
    public static final Block OAK_TRIM = null;
    public static final Block SPRUCE_TRIM = null;
    public static final Block BIRCH_TRIM = null;
    public static final Block JUNGLE_TRIM = null;
    public static final Block ACACIA_TRIM = null;
    public static final Block DARK_OAK_TRIM = null;
    public static final Block CRIMSON_TRIM = null;
    public static final Block WARPED_TRIM = null;
    public static final BlockController CONTROLLER = null;
    public static final BlockSlave CONTROLLER_SLAVE = null;

    @Mod.EventBusSubscriber(modid="storagedrawers", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class Registration {
        private static List<Block> blockList = new ArrayList<Block>();

        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            Registration.registerDrawerBlock(event, "oak_full_drawers_1", 1, false);
            Registration.registerDrawerBlock(event, "oak_full_drawers_2", 2, false);
            Registration.registerDrawerBlock(event, "oak_full_drawers_4", 4, false);
            Registration.registerDrawerBlock(event, "oak_half_drawers_1", 1, true);
            Registration.registerDrawerBlock(event, "oak_half_drawers_2", 2, true);
            Registration.registerDrawerBlock(event, "oak_half_drawers_4", 4, true);
            Registration.registerTrimBlock(event, "oak_trim");
            Registration.registerDrawerBlock(event, "spruce_full_drawers_1", 1, false);
            Registration.registerDrawerBlock(event, "spruce_full_drawers_2", 2, false);
            Registration.registerDrawerBlock(event, "spruce_full_drawers_4", 4, false);
            Registration.registerDrawerBlock(event, "spruce_half_drawers_1", 1, true);
            Registration.registerDrawerBlock(event, "spruce_half_drawers_2", 2, true);
            Registration.registerDrawerBlock(event, "spruce_half_drawers_4", 4, true);
            Registration.registerTrimBlock(event, "spruce_trim");
            Registration.registerDrawerBlock(event, "birch_full_drawers_1", 1, false);
            Registration.registerDrawerBlock(event, "birch_full_drawers_2", 2, false);
            Registration.registerDrawerBlock(event, "birch_full_drawers_4", 4, false);
            Registration.registerDrawerBlock(event, "birch_half_drawers_1", 1, true);
            Registration.registerDrawerBlock(event, "birch_half_drawers_2", 2, true);
            Registration.registerDrawerBlock(event, "birch_half_drawers_4", 4, true);
            Registration.registerTrimBlock(event, "birch_trim");
            Registration.registerDrawerBlock(event, "jungle_full_drawers_1", 1, false);
            Registration.registerDrawerBlock(event, "jungle_full_drawers_2", 2, false);
            Registration.registerDrawerBlock(event, "jungle_full_drawers_4", 4, false);
            Registration.registerDrawerBlock(event, "jungle_half_drawers_1", 1, true);
            Registration.registerDrawerBlock(event, "jungle_half_drawers_2", 2, true);
            Registration.registerDrawerBlock(event, "jungle_half_drawers_4", 4, true);
            Registration.registerTrimBlock(event, "jungle_trim");
            Registration.registerDrawerBlock(event, "acacia_full_drawers_1", 1, false);
            Registration.registerDrawerBlock(event, "acacia_full_drawers_2", 2, false);
            Registration.registerDrawerBlock(event, "acacia_full_drawers_4", 4, false);
            Registration.registerDrawerBlock(event, "acacia_half_drawers_1", 1, true);
            Registration.registerDrawerBlock(event, "acacia_half_drawers_2", 2, true);
            Registration.registerDrawerBlock(event, "acacia_half_drawers_4", 4, true);
            Registration.registerTrimBlock(event, "acacia_trim");
            Registration.registerDrawerBlock(event, "dark_oak_full_drawers_1", 1, false);
            Registration.registerDrawerBlock(event, "dark_oak_full_drawers_2", 2, false);
            Registration.registerDrawerBlock(event, "dark_oak_full_drawers_4", 4, false);
            Registration.registerDrawerBlock(event, "dark_oak_half_drawers_1", 1, true);
            Registration.registerDrawerBlock(event, "dark_oak_half_drawers_2", 2, true);
            Registration.registerDrawerBlock(event, "dark_oak_half_drawers_4", 4, true);
            Registration.registerTrimBlock(event, "dark_oak_trim");
            Registration.registerDrawerBlock(event, "crimson_full_drawers_1", 1, false);
            Registration.registerDrawerBlock(event, "crimson_full_drawers_2", 2, false);
            Registration.registerDrawerBlock(event, "crimson_full_drawers_4", 4, false);
            Registration.registerDrawerBlock(event, "crimson_half_drawers_1", 1, true);
            Registration.registerDrawerBlock(event, "crimson_half_drawers_2", 2, true);
            Registration.registerDrawerBlock(event, "crimson_half_drawers_4", 4, true);
            Registration.registerTrimBlock(event, "crimson_trim");
            Registration.registerDrawerBlock(event, "warped_full_drawers_1", 1, false);
            Registration.registerDrawerBlock(event, "warped_full_drawers_2", 2, false);
            Registration.registerDrawerBlock(event, "warped_full_drawers_4", 4, false);
            Registration.registerDrawerBlock(event, "warped_half_drawers_1", 1, true);
            Registration.registerDrawerBlock(event, "warped_half_drawers_2", 2, true);
            Registration.registerDrawerBlock(event, "warped_half_drawers_4", 4, true);
            Registration.registerTrimBlock(event, "warped_trim");
            Registration.registerCompactingDrawerBlock(event, "compacting_drawers_3");
            Registration.registerBlock(event, "controller", (Block)new BlockController(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60978_(5.0f)));
            Registration.registerBlock(event, "controller_slave", new BlockSlave(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60978_(5.0f)));
        }

        @SubscribeEvent
        public static void registerTileEntities(RegistryEvent.Register<BlockEntityType<?>> event) {
            Registration.registerTileEntity(event, "standard_drawers_1", TileEntityDrawersStandard.Slot1::new, new Block[]{OAK_FULL_DRAWERS_1, OAK_HALF_DRAWERS_1, SPRUCE_FULL_DRAWERS_1, SPRUCE_HALF_DRAWERS_1, BIRCH_FULL_DRAWERS_1, BIRCH_HALF_DRAWERS_1, JUNGLE_FULL_DRAWERS_1, JUNGLE_HALF_DRAWERS_1, ACACIA_FULL_DRAWERS_1, ACACIA_HALF_DRAWERS_1, DARK_OAK_FULL_DRAWERS_1, DARK_OAK_HALF_DRAWERS_1, CRIMSON_FULL_DRAWERS_1, CRIMSON_HALF_DRAWERS_1, WARPED_FULL_DRAWERS_1, WARPED_HALF_DRAWERS_1});
            Registration.registerTileEntity(event, "standard_drawers_2", TileEntityDrawersStandard.Slot2::new, new Block[]{OAK_FULL_DRAWERS_2, OAK_HALF_DRAWERS_2, SPRUCE_FULL_DRAWERS_2, SPRUCE_HALF_DRAWERS_2, BIRCH_FULL_DRAWERS_2, BIRCH_HALF_DRAWERS_2, JUNGLE_FULL_DRAWERS_2, JUNGLE_HALF_DRAWERS_2, ACACIA_FULL_DRAWERS_2, ACACIA_HALF_DRAWERS_2, DARK_OAK_FULL_DRAWERS_2, DARK_OAK_HALF_DRAWERS_2, CRIMSON_FULL_DRAWERS_2, CRIMSON_HALF_DRAWERS_2, WARPED_FULL_DRAWERS_2, WARPED_HALF_DRAWERS_2});
            Registration.registerTileEntity(event, "standard_drawers_4", TileEntityDrawersStandard.Slot4::new, new Block[]{OAK_FULL_DRAWERS_4, OAK_HALF_DRAWERS_4, SPRUCE_FULL_DRAWERS_4, SPRUCE_HALF_DRAWERS_4, BIRCH_FULL_DRAWERS_4, BIRCH_HALF_DRAWERS_4, JUNGLE_FULL_DRAWERS_4, JUNGLE_HALF_DRAWERS_4, ACACIA_FULL_DRAWERS_4, ACACIA_HALF_DRAWERS_4, DARK_OAK_FULL_DRAWERS_4, DARK_OAK_HALF_DRAWERS_4, CRIMSON_FULL_DRAWERS_4, CRIMSON_HALF_DRAWERS_4, WARPED_FULL_DRAWERS_4, WARPED_HALF_DRAWERS_4});
            Registration.registerTileEntity(event, "fractional_drawers_3", TileEntityDrawersComp.Slot3::new, new Block[]{COMPACTING_DRAWERS_3});
            Registration.registerTileEntity(event, "controller", TileEntityController::new, new Block[]{CONTROLLER});
            Registration.registerTileEntity(event, "controller_slave", TileEntitySlave::new, CONTROLLER_SLAVE);
        }

        private static Block registerDrawerBlock(RegistryEvent.Register<Block> event, String name, int drawerCount, boolean halfDepth) {
            return Registration.registerBlock(event, name, (Block)new BlockStandardDrawers(drawerCount, halfDepth, BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(3.0f, 5.0f).m_60918_(SoundType.f_56736_).m_60960_(Registration::predFalse).m_60924_(Registration::predFalse)));
        }

        private static Block registerTrimBlock(RegistryEvent.Register<Block> event, String name) {
            return Registration.registerBlock(event, name, new BlockTrim(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60918_(SoundType.f_56736_).m_60978_(5.0f)));
        }

        private static Block registerCompactingDrawerBlock(RegistryEvent.Register<Block> event, String name) {
            return Registration.registerBlock(event, name, (Block)new BlockCompDrawers(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60978_(10.0f).m_60960_(Registration::predFalse).m_60924_(Registration::predFalse)));
        }

        private static Block registerBlock(RegistryEvent.Register<Block> event, String name, Block block) {
            return Registration.registerBlock(event, name, block, blockList);
        }

        private static Block registerBlock(RegistryEvent.Register<Block> event, String name, Block block, List<Block> group) {
            block.setRegistryName(name);
            event.getRegistry().register((IForgeRegistryEntry)block);
            group.add(block);
            return block;
        }

        private static <T extends BlockEntity> void registerTileEntity(RegistryEvent.Register<BlockEntityType<?>> event, String name, BlockEntityType.BlockEntitySupplier<? extends T> factory, Block ... blocks) {
            event.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)BlockEntityType.Builder.m_155273_(factory, (Block[])blocks).m_58966_(null).setRegistryName(new ResourceLocation("storagedrawers", name))));
        }

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            for (Block block : blockList) {
                ItemDrawers itemBlock = null;
                itemBlock = block instanceof BlockDrawers ? new ItemDrawers(block, new Item.Properties().m_41491_(ModItemGroup.STORAGE_DRAWERS)) : new BlockItem(block, new Item.Properties().m_41491_(ModItemGroup.STORAGE_DRAWERS));
                itemBlock.setRegistryName(block.getRegistryName());
                event.getRegistry().register((IForgeRegistryEntry)itemBlock);
            }
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer(Tile.STANDARD_DRAWERS_1, TileEntityDrawersRenderer::new);
            event.registerBlockEntityRenderer(Tile.STANDARD_DRAWERS_2, TileEntityDrawersRenderer::new);
            event.registerBlockEntityRenderer(Tile.STANDARD_DRAWERS_4, TileEntityDrawersRenderer::new);
            event.registerBlockEntityRenderer(Tile.FRACTIONAL_DRAWERS_3, TileEntityDrawersRenderer::new);
        }

        @OnlyIn(value=Dist.CLIENT)
        public static void bindRenderTypes() {
            for (Block block : blockList) {
                if (!(block instanceof BlockDrawers)) continue;
                ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110457_());
            }
        }

        private static boolean predFalse(BlockState p_235436_0_, BlockGetter p_235436_1_, BlockPos p_235436_2_) {
            return false;
        }
    }

    @ObjectHolder(value="storagedrawers")
    public static final class Tile {
        public static final BlockEntityType<TileEntityDrawersStandard> STANDARD_DRAWERS_1 = null;
        public static final BlockEntityType<TileEntityDrawersStandard> STANDARD_DRAWERS_2 = null;
        public static final BlockEntityType<TileEntityDrawersStandard> STANDARD_DRAWERS_4 = null;
        public static final BlockEntityType<TileEntityDrawersComp> FRACTIONAL_DRAWERS_3 = null;
        public static final BlockEntityType<TileEntityController> CONTROLLER = null;
        public static final BlockEntityType<TileEntitySlave> CONTROLLER_SLAVE = null;
    }
}

