/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.api.event.DrawerPopulatedEvent;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.StandardDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.core.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BlockEntityDrawersStandard
extends BlockEntityDrawers {
    static Capability<IDrawerAttributes> DRAWER_ATTRIBUTES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IDrawerAttributes>(){});

    public BlockEntityDrawersStandard(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    public static BlockEntityDrawersStandard createEntity(int slotCount, BlockPos pos, BlockState state) {
        return switch (slotCount) {
            case 1 -> new Slot1(pos, state);
            case 2 -> new Slot2(pos, state);
            case 4 -> new Slot4(pos, state);
            default -> null;
        };
    }

    public static class Slot1
    extends BlockEntityDrawersStandard {
        private final GroupData groupData = new GroupData(1);

        public Slot1(BlockPos pos, BlockState state) {
            super((BlockEntityType)ModBlockEntities.STANDARD_DRAWERS_1.get(), pos, state);
            this.groupData.setCapabilityProvider(this);
            this.injectPortableData(this.groupData);
        }

        @Override
        @NotNull
        public IDrawerGroup getGroup() {
            return this.groupData;
        }

        @Override
        protected void onAttributeChanged() {
            super.onAttributeChanged();
            this.groupData.syncAttributes();
        }
    }

    public static class Slot2
    extends BlockEntityDrawersStandard {
        private final GroupData groupData = new GroupData(2);

        public Slot2(BlockPos pos, BlockState state) {
            super((BlockEntityType)ModBlockEntities.STANDARD_DRAWERS_2.get(), pos, state);
            this.groupData.setCapabilityProvider(this);
            this.injectPortableData(this.groupData);
        }

        @Override
        @NotNull
        public IDrawerGroup getGroup() {
            return this.groupData;
        }

        @Override
        protected void onAttributeChanged() {
            super.onAttributeChanged();
            this.groupData.syncAttributes();
        }
    }

    public static class Slot4
    extends BlockEntityDrawersStandard {
        private final GroupData groupData = new GroupData(4);

        public Slot4(BlockPos pos, BlockState state) {
            super((BlockEntityType)ModBlockEntities.STANDARD_DRAWERS_4.get(), pos, state);
            this.groupData.setCapabilityProvider(this);
            this.injectPortableData(this.groupData);
        }

        @Override
        @NotNull
        public IDrawerGroup getGroup() {
            return this.groupData;
        }

        @Override
        protected void onAttributeChanged() {
            super.onAttributeChanged();
            this.groupData.syncAttributes();
        }
    }

    private class StandardDrawerData
    extends StandardDrawerGroup.DrawerData {
        private final int slot;

        public StandardDrawerData(StandardDrawerGroup group, int slot) {
            super(group);
            this.slot = slot;
        }

        @Override
        protected int getStackCapacity() {
            return BlockEntityDrawersStandard.this.upgrades().getStorageMultiplier() * BlockEntityDrawersStandard.this.getEffectiveDrawerCapacity();
        }

        @Override
        protected void onItemChanged() {
            DrawerPopulatedEvent event = new DrawerPopulatedEvent(this);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (BlockEntityDrawersStandard.this.m_58904_() != null && !BlockEntityDrawersStandard.this.m_58904_().f_46443_) {
                BlockEntityDrawersStandard.this.m_6596_();
                BlockEntityDrawersStandard.this.markBlockForUpdate();
            }
        }

        @Override
        protected void onAmountChanged() {
            if (BlockEntityDrawersStandard.this.m_58904_() != null && !BlockEntityDrawersStandard.this.m_58904_().f_46443_) {
                BlockEntityDrawersStandard.this.syncClientCount(this.slot, this.getStoredItemCount());
                BlockEntityDrawersStandard.this.m_6596_();
            }
        }
    }

    private class GroupData
    extends StandardDrawerGroup {
        private final LazyOptional<IDrawerAttributes> attributesHandler;

        public GroupData(int slotCount) {
            super(slotCount);
            this.attributesHandler = LazyOptional.of(BlockEntityDrawersStandard.this::getDrawerAttributes);
        }

        @Override
        @NotNull
        protected StandardDrawerGroup.DrawerData createDrawer(int slot) {
            return new StandardDrawerData(this, slot);
        }

        @Override
        public boolean isGroupValid() {
            return BlockEntityDrawersStandard.this.isGroupValid();
        }

        @Override
        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction facing) {
            if (capability == DRAWER_ATTRIBUTES_CAPABILITY) {
                return this.attributesHandler.cast();
            }
            return super.getCapability(capability, facing);
        }

        @Override
        public void invalidateCaps() {
            super.invalidateCaps();
            this.attributesHandler.invalidate();
        }
    }
}

