/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.client.renderer.StorageRenderItem;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawers;
import com.jaquadro.minecraft.storagedrawers.inventory.SlotStorage;
import com.jaquadro.minecraft.storagedrawers.inventory.SlotUpgrade;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class DrawerScreen
extends AbstractContainerScreen<ContainerDrawers> {
    private static final ResourceLocation guiTextures1 = StorageDrawers.rl("textures/gui/drawers_1.png");
    private static final ResourceLocation guiTextures2 = StorageDrawers.rl("textures/gui/drawers_2.png");
    private static final ResourceLocation guiTextures4 = StorageDrawers.rl("textures/gui/drawers_4.png");
    private static final ResourceLocation guiTexturesComp = StorageDrawers.rl("textures/gui/drawers_comp.png");
    private static final int smDisabledX = 176;
    private static final int smDisabledY = 0;
    private static StorageRenderItem storageItemRender;
    private final ResourceLocation background;
    private final Inventory inventory;

    public DrawerScreen(ContainerDrawers container, Inventory playerInv, Component name, ResourceLocation bg) {
        super((AbstractContainerMenu)container, playerInv, name);
        this.f_97726_ = 176;
        this.f_97727_ = 199;
        this.background = bg;
        this.inventory = playerInv;
    }

    protected void m_7856_() {
        super.m_7856_();
        if (storageItemRender == null && this.f_96541_ != null) {
            ItemRenderer defaultRenderItem = this.f_96541_.m_91291_();
            storageItemRender = new StorageRenderItem(this.f_96541_.m_91097_(), defaultRenderItem.m_115103_().m_109393_(), this.f_96541_.getItemColors());
        }
    }

    public void m_86412_(@NotNull PoseStack stack, int p_render_1_, int p_render_2_, float p_render_3_) {
        ItemRenderer ri = this.setItemRender(storageItemRender);
        ((ContainerDrawers)this.f_97732_).activeRenderItem = storageItemRender;
        this.m_7333_(stack);
        super.m_86412_(stack, p_render_1_, p_render_2_, p_render_3_);
        this.m_7025_(stack, p_render_1_, p_render_2_);
        ((ContainerDrawers)this.f_97732_).activeRenderItem = null;
        DrawerScreen.storageItemRender.overrideStack = ItemStack.f_41583_;
        this.setItemRender(ri);
    }

    protected void m_7027_(@NotNull PoseStack stack, int mouseX, int mouseY) {
        this.f_96547_.m_92883_(stack, this.f_96539_.getString(), 8.0f, 6.0f, 0x404040);
        this.f_96547_.m_92883_(stack, I18n.m_118938_((String)"container.storagedrawers.upgrades", (Object[])new Object[0]), 8.0f, 75.0f, 0x404040);
        this.f_96547_.m_92883_(stack, this.inventory.m_5446_().getString(), 8.0f, (float)(this.f_97727_ - 96 + 2), 0x404040);
    }

    protected void m_7286_(@NotNull PoseStack stack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.background);
        int guiX = (this.f_96543_ - this.f_97726_) / 2;
        int guiY = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(stack, guiX, guiY, 0, 0, this.f_97726_, this.f_97727_);
        List<Slot> storageSlots = ((ContainerDrawers)this.f_97732_).getStorageSlots();
        for (Slot slot : storageSlots) {
            this.m_93228_(stack, guiX + slot.f_40220_, guiY + slot.f_40221_, 176, 0, 16, 16);
        }
        List<Slot> upgradeSlots = ((ContainerDrawers)this.f_97732_).getUpgradeSlots();
        for (Slot slot : upgradeSlots) {
            if (!(slot instanceof SlotUpgrade) || ((SlotUpgrade)slot).canTakeStack((Player)Minecraft.m_91087_().f_91074_)) continue;
            this.m_93228_(stack, guiX + slot.f_40220_, guiY + slot.f_40221_, 176, 0, 16, 16);
        }
    }

    protected boolean m_6774_(int x, int y, int width, int height, double originX, double originY) {
        List<Slot> storageSlots = ((ContainerDrawers)this.f_97732_).getStorageSlots();
        for (Slot slot : storageSlots) {
            if (!(slot instanceof SlotStorage) || slot.f_40220_ != x || slot.f_40221_ != y) continue;
            return false;
        }
        return super.m_6774_(x, y, width, height, originX, originY);
    }

    private ItemRenderer setItemRender(ItemRenderer renderItem) {
        ItemRenderer prev = this.f_96542_;
        this.f_96542_ = renderItem;
        return prev;
    }

    public static class Compacting
    extends DrawerScreen {
        public Compacting(ContainerDrawers container, Inventory playerInv, Component name) {
            super(container, playerInv, name, guiTexturesComp);
        }
    }

    public static class Slot4
    extends DrawerScreen {
        public Slot4(ContainerDrawers container, Inventory playerInv, Component name) {
            super(container, playerInv, name, guiTextures4);
        }
    }

    public static class Slot2
    extends DrawerScreen {
        public Slot2(ContainerDrawers container, Inventory playerInv, Component name) {
            super(container, playerInv, name, guiTextures2);
        }
    }

    public static class Slot1
    extends DrawerScreen {
        public Slot1(ContainerDrawers container, Inventory playerInv, Component name) {
            super(container, playerInv, name, guiTextures1);
        }
    }
}

