/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.renderer;

import com.jaquadro.minecraft.storagedrawers.inventory.ItemStackHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class StorageRenderItem
extends ItemRenderer {
    private final ItemRenderer parent = Minecraft.m_91087_().m_91291_();
    @NotNull
    public ItemStack overrideStack = ItemStack.f_41583_;

    public StorageRenderItem(Minecraft mc, TextureManager texManager, ModelManager modelManager, ItemColors colors) {
        super(mc, texManager, modelManager, colors, null);
    }

    @NotNull
    public ItemModelShaper m_115103_() {
        return this.parent.m_115103_();
    }

    public void m_115143_(@NotNull ItemStack itemStackIn, ItemDisplayContext displayContext, boolean leftHand, @NotNull PoseStack matrixStackIn, @NotNull MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, @NotNull BakedModel modelIn) {
        this.parent.m_115143_(itemStackIn, displayContext, leftHand, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, modelIn);
    }

    public void m_269491_(@Nullable LivingEntity livingEntityIn, @NotNull ItemStack itemStackIn, ItemDisplayContext displayContext, boolean leftHand, @NotNull PoseStack matrixStackIn, @NotNull MultiBufferSource bufferIn, @Nullable Level worldIn, int combinedLightIn, int combinedOverlayIn, int p_174252_) {
        this.parent.m_269491_(livingEntityIn, itemStackIn, displayContext, leftHand, matrixStackIn, bufferIn, worldIn, combinedLightIn, combinedOverlayIn, p_174252_);
    }

    public void m_269128_(@NotNull ItemStack itemStackIn, ItemDisplayContext displayContext, int combinedLightIn, int combinedOverlayIn, @NotNull PoseStack matrixStackIn, @NotNull MultiBufferSource bufferIn, @Nullable Level worldIn, int p_174276_) {
        this.parent.m_269128_(itemStackIn, displayContext, combinedLightIn, combinedOverlayIn, matrixStackIn, bufferIn, worldIn, p_174276_);
    }

    public void m_115162_(@NotNull PoseStack matrixStackIn, @NotNull VertexConsumer bufferIn, @NotNull List<BakedQuad> quadsIn, @NotNull ItemStack itemStackIn, int combinedLightIn, int combinedOverlayIn) {
        this.parent.m_115162_(matrixStackIn, bufferIn, quadsIn, itemStackIn, combinedLightIn, combinedOverlayIn);
    }

    @NotNull
    public BakedModel m_174264_(@NotNull ItemStack stack, Level world, LivingEntity entity, int p_174268_) {
        return this.parent.m_174264_(stack, world, entity, p_174268_);
    }

    public void m_274569_(PoseStack poseStack, @NotNull ItemStack stack, int x, int y) {
        this.parent.m_274569_(poseStack, stack, x, y);
    }

    public void m_274369_(PoseStack poseStack, @NotNull ItemStack stack, int xPosition, int yPosition) {
        this.parent.m_274369_(poseStack, stack, xPosition, yPosition);
    }

    public void m_274301_(PoseStack poseStack, @NotNull LivingEntity entityIn, @NotNull ItemStack itemIn, int x, int y, int p_174234_) {
        this.parent.m_274301_(poseStack, entityIn, itemIn, x, y, p_174234_);
    }

    public void m_274412_(PoseStack poseStack, @NotNull Font fr, @NotNull ItemStack stack, int xPosition, int yPosition) {
        this.parent.m_274412_(poseStack, fr, stack, xPosition, yPosition);
    }

    public void m_274364_(PoseStack poseStack, @NotNull Font font, @NotNull ItemStack item, int x, int y, String text) {
        if (item != this.overrideStack) {
            super.m_274364_(poseStack, font, item, x, y, text);
            return;
        }
        if (!item.m_41619_()) {
            LocalPlayer clientplayerentity;
            float f3;
            item = ItemStackHelper.decodeItemStack(item);
            float scale = 0.5f;
            float xoff = 0.0f;
            int stackSize = item.m_41613_();
            if (ItemStackHelper.isStackEncoded(item)) {
                stackSize = 0;
            }
            poseStack.m_85836_();
            if (stackSize >= 0 || text != null) {
                text = stackSize >= 100000000 ? (text == null ? String.format("%.0fM", Float.valueOf((float)stackSize / 1000000.0f)) : text) : (stackSize >= 1000000 ? (text == null ? String.format("%.1fM", Float.valueOf((float)stackSize / 1000000.0f)) : text) : (stackSize >= 100000 ? (text == null ? String.format("%.0fK", Float.valueOf((float)stackSize / 1000.0f)) : text) : (stackSize >= 10000 ? (text == null ? String.format("%.1fK", Float.valueOf((float)stackSize / 1000.0f)) : text) : (text == null ? String.valueOf(stackSize) : text))));
                int textX = (int)(((float)(x + 16) + xoff - (float)font.m_92895_(text) * scale) / scale) - 1;
                int textY = (int)(((float)(y + 16) - 7.0f * scale) / scale) - 1;
                int color = 0xFFFFFF;
                if (stackSize == 0) {
                    color = 0xFF6060;
                }
                poseStack.m_85841_(scale, scale, 1.0f);
                poseStack.m_85837_(0.0, 0.0, 200.0);
                MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
                font.m_271703_(text, (float)textX, (float)textY, color, true, poseStack.m_85850_().m_252922_(), (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                buffer.m_109911_();
            }
            if (item.m_41720_().m_142522_(item)) {
                RenderSystem.m_69465_();
                int barWidth = item.m_41720_().m_142158_(item);
                int j = item.m_41720_().m_142159_(item);
                int x1 = x + 2;
                int y1 = y + 13;
                GuiComponent.m_93172_((PoseStack)poseStack, (int)x1, (int)y1, (int)(x1 + 13), (int)(y1 + 2), (int)-16777216);
                GuiComponent.m_93172_((PoseStack)poseStack, (int)x1, (int)y1, (int)(x1 + barWidth), (int)(y1 + 1), (int)-16777215);
                RenderSystem.m_69482_();
            }
            float f = f3 = (clientplayerentity = Minecraft.m_91087_().f_91074_) == null ? 0.0f : clientplayerentity.m_36335_().m_41521_(item.m_41720_(), Minecraft.m_91087_().m_91296_());
            if (f3 > 0.0f) {
                RenderSystem.m_69465_();
                int y1 = y + Mth.m_14143_((float)(16.0f * (1.0f - f3)));
                int y2 = y1 + Mth.m_14167_((float)(16.0f * f3));
                GuiComponent.m_93172_((PoseStack)poseStack, (int)x, (int)y1, (int)(x + 16), (int)y2, (int)Integer.MAX_VALUE);
                RenderSystem.m_69482_();
            }
            poseStack.m_85849_();
        }
    }

    public void m_6213_(@NotNull ResourceManager p_195410_1_) {
        this.parent.m_6213_(p_195410_1_);
    }

    private void draw(BufferBuilder tessellator, int x, int y, int w, int h, int r, int g, int b, int a) {
        tessellator.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        tessellator.m_5483_((double)(x + 0), (double)(y + 0), 0.0).m_6122_(r, g, b, a).m_5752_();
        tessellator.m_5483_((double)(x + 0), (double)(y + h), 0.0).m_6122_(r, g, b, a).m_5752_();
        tessellator.m_5483_((double)(x + w), (double)(y + h), 0.0).m_6122_(r, g, b, a).m_5752_();
        tessellator.m_5483_((double)(x + w), (double)(y + 0), 0.0).m_6122_(r, g, b, a).m_5752_();
        Tesselator.m_85913_().m_85914_();
    }
}

