/*
 * Decompiled with CFR 0.152.
 */
package melonslise.subwild.common.block;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Random;
import melonslise.subwild.common.init.SubWildProperties;
import melonslise.subwild.common.init.SubWildTags;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import org.apache.commons.lang3.tuple.Pair;

public class FoxfireBlock
extends Block
implements IPlantable {
    public static final VoxelShape SHAPE_NORTH = Block.func_208617_a((double)5.0, (double)5.0, (double)10.0, (double)11.0, (double)11.0, (double)16.0);
    public static final VoxelShape SHAPE_EAST = Block.func_208617_a((double)0.0, (double)5.0, (double)5.0, (double)6.0, (double)11.0, (double)11.0);
    public static final VoxelShape SHAPE_SOUTH = Block.func_208617_a((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)6.0);
    public static final VoxelShape SHAPE_WEST = Block.func_208617_a((double)10.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0);
    public static final VoxelShape SHAPE_UP = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0);
    public static final VoxelShape SHAPE_DOWN = Block.func_208617_a((double)5.0, (double)10.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    public static final int GLOWING_THRESHOLD = 7;

    public FoxfireBlock(AbstractBlock.Properties properties) {
        super(properties.func_200944_c().func_235838_a_(state -> (Boolean)state.func_177229_b((Property)SubWildProperties.GLOWING) != false ? 4 : 0));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)SubWildProperties.GLOWING, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.NORTH));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{SubWildProperties.GLOWING, BlockStateProperties.field_208155_H});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        switch ((Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H)) {
            case NORTH: {
                return SHAPE_NORTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case WEST: {
                return SHAPE_WEST;
            }
            case UP: {
                return SHAPE_UP;
            }
            case DOWN: {
                return SHAPE_DOWN;
            }
        }
        return VoxelShapes.func_197880_a();
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        boolean glowing = (Boolean)state.func_177229_b((Property)SubWildProperties.GLOWING);
        if (world.func_226659_b_(pos, 0) < 7 != glowing) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)SubWildProperties.GLOWING, (Comparable)Boolean.valueOf(!glowing)));
        }
        if (rand.nextInt(250) == 0) {
            ArrayList orients = Lists.newArrayList();
            int shrooms = 5;
            for (BlockPos pos1 : BlockPos.func_191531_b((int)(pos.func_177958_n() - 3), (int)(pos.func_177956_o() - 3), (int)(pos.func_177952_p() - 3), (int)(pos.func_177958_n() + 3), (int)(pos.func_177956_o() + 3), (int)(pos.func_177952_p() + 3))) {
                BlockState state1 = world.func_180495_p(pos1);
                if (SubWildTags.FOXFIRE.func_230235_a_((Object)state1.func_177230_c()) && --shrooms <= 0) {
                    return;
                }
                if (!this.isValidGround(state1, (IWorldReader)world, pos1)) continue;
                for (Direction side : Direction.values()) {
                    if (!world.func_175623_d(pos1.func_177972_a(side))) continue;
                    orients.add(Pair.of((Object)pos1.func_177972_a(side), (Object)side));
                }
            }
            if (orients.size() <= 0) {
                return;
            }
            Pair orient = (Pair)orients.get(rand.nextInt(orients.size()));
            world.func_180501_a((BlockPos)orient.getLeft(), (BlockState)((Block)SubWildTags.FOXFIRE.func_205596_a(rand)).func_176223_P().func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)orient.getRight()), 2);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((Property)SubWildProperties.GLOWING)).booleanValue() && rand.nextInt(15) == 0) {
            world.func_195594_a((IParticleData)ParticleTypes.field_197632_y, (double)pos.func_177958_n() + rand.nextDouble(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + rand.nextDouble(), 0.0, 0.0, 0.0);
        }
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)SubWildProperties.GLOWING, (Comparable)Boolean.valueOf(ctx.func_195991_k().func_226659_b_(ctx.func_195995_a(), 0) < 7))).func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)ctx.func_196000_l());
    }

    public BlockState func_196271_a(BlockState state, Direction side, BlockState adjState, IWorld world, BlockPos pos, BlockPos adjPos) {
        return state.func_196955_c((IWorldReader)world, pos) ? super.func_196271_a(state, side, adjState, world, pos, adjPos) : Blocks.field_150350_a.func_176223_P();
    }

    public boolean isValidGround(BlockState state, IWorldReader world, BlockPos pos) {
        return state.func_185904_a() == Material.field_151575_d && state.func_200015_d((IBlockReader)world, pos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        BlockPos adjPos = pos.func_177972_a(((Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H)).func_176734_d());
        return this.isValidGround(world.func_180495_p(adjPos), world, adjPos);
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    public boolean func_196266_a(BlockState state, IBlockReader world, BlockPos pos, PathType type) {
        return type == PathType.AIR && !this.field_235688_at_ ? true : super.func_196266_a(state, world, pos, type);
    }

    public PlantType getPlantType(IBlockReader world, BlockPos pos) {
        return PlantType.CAVE;
    }

    public BlockState getPlant(IBlockReader world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return state.func_177230_c() != this ? this.func_176223_P() : state;
    }
}

