/*
 * Decompiled with CFR 0.152.
 */
package melonslise.subwild.common.init;

import com.google.common.collect.Maps;
import java.util.HashMap;
import melonslise.subwild.common.init.SubWildConfiguredFeatures;
import melonslise.subwild.common.world.gen.feature.CaveDecoFeature;
import melonslise.subwild.common.world.gen.feature.CaveRangeConfig;
import melonslise.subwild.common.world.gen.feature.cavetype.BasicCaveType;
import melonslise.subwild.common.world.gen.feature.cavetype.CaveType;
import melonslise.subwild.common.world.gen.feature.cavetype.CoralCaveType;
import melonslise.subwild.common.world.gen.feature.cavetype.DeadCoralCaveType;
import melonslise.subwild.common.world.gen.feature.cavetype.FungalCaveType;
import melonslise.subwild.common.world.gen.feature.cavetype.IcyCaveType;
import melonslise.subwild.common.world.gen.feature.cavetype.IcyRockyCaveType;
import melonslise.subwild.common.world.gen.feature.cavetype.LushCaveType;
import melonslise.subwild.common.world.gen.feature.cavetype.LushVolcanicCaveType;
import melonslise.subwild.common.world.gen.feature.cavetype.MesaCaveType;
import melonslise.subwild.common.world.gen.feature.cavetype.MossyCaveType;
import melonslise.subwild.common.world.gen.feature.cavetype.MossyRockyCaveType;
import melonslise.subwild.common.world.gen.feature.cavetype.MuddyCaveType;
import melonslise.subwild.common.world.gen.feature.cavetype.PodzolCaveType;
import melonslise.subwild.common.world.gen.feature.cavetype.RockyCaveType;
import melonslise.subwild.common.world.gen.feature.cavetype.SandyCaveType;
import melonslise.subwild.common.world.gen.feature.cavetype.SandyRockyCaveType;
import melonslise.subwild.common.world.gen.feature.cavetype.SandyVolcanicCaveType;
import melonslise.subwild.common.world.gen.feature.cavetype.VolcanicCaveType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public final class SubWildFeatures {
    public static final HashMap<ResourceLocation, CaveType> CAVE_TYPES = Maps.newHashMap();
    public static final CaveType BASIC_CAVE = new BasicCaveType("subwild", "basic");
    public static final CaveType DEAD_CORAL_CAVE = new DeadCoralCaveType("subwild", "dead_coral");
    public static final CaveType SANDY_CAVE = new SandyCaveType("subwild", "sandy", false);
    public static final CaveType SANDY_RED_CAVE = new SandyCaveType("subwild", "sandy_red", true);
    public static final CaveType SANDY_ROCKY_CAVE = new SandyRockyCaveType("subwild", "sandy_rocky", false);
    public static final CaveType SANDY_RED_ROCKY_CAVE = new SandyRockyCaveType("subwild", "sandy_red_rocky", true);
    public static final CaveType MESA_CAVE = new MesaCaveType("subwild", "mesa");
    public static final CaveType LUSH_CAVE = new LushCaveType("subwild", "lush");
    public static final CaveType LUSH_VOLCANIC_CAVE = new LushVolcanicCaveType("subwild", "lush_volcanic");
    public static final CaveType ROCKY_CAVE = new RockyCaveType("subwild", "rocky");
    public static final CaveType ICY_CAVE = new IcyCaveType("subwild", "icy");
    public static final CaveType ICY_ROCKY_CAVE = new IcyRockyCaveType("subwild", "icy_rocky");
    public static final CaveType FUNGAL_CAVE = new FungalCaveType("subwild", "fungal");
    public static final CaveType MUDDY_CAVE = new MuddyCaveType("subwild", "muddy");
    public static final CaveType PODZOL_CAVE = new PodzolCaveType("subwild", "podzol");
    public static final CaveType MOSSY_CAVE = new MossyCaveType("subwild", "mossy");
    public static final CaveType MOSSY_ROCKY_CAVE = new MossyRockyCaveType("subwild", "mossy_rocky");
    public static final CaveType VOLCANIC_CAVE = new VolcanicCaveType("subwild", "volcanic");
    public static final CaveType SANDY_VOLCANIC_CAVE = new SandyVolcanicCaveType("subwild", "sandy_volcanic", false);
    public static final CaveType SANDY_RED_VOLCANIC_CAVE = new SandyVolcanicCaveType("subwild", "sandy_red_volcanic", true);
    public static final CaveType CORAL_CAVE = new CoralCaveType("subwild", "coral");
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"subwild");
    public static final RegistryObject<Feature<CaveRangeConfig>> CAVE_DECO = SubWildFeatures.add("cave", new CaveDecoFeature(CaveRangeConfig.CODEC));

    private SubWildFeatures() {
    }

    public static void register() {
        FEATURES.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    public static void addFeatures(BiomeLoadingEvent event) {
        GenerationStage.Decoration stage = GenerationStage.Decoration.UNDERGROUND_DECORATION;
        switch (event.getCategory()) {
            case BEACH: 
            case OCEAN: 
            case RIVER: {
                event.getGeneration().func_242513_a(stage, SubWildConfiguredFeatures.CONFIGURED_WET_AIR_CAVE_DECO);
                event.getGeneration().func_242513_a(stage, SubWildConfiguredFeatures.CONFIGURED_WET_LIQUID_CAVE_DECO);
                break;
            }
            case TAIGA: {
                event.getGeneration().func_242513_a(stage, SubWildConfiguredFeatures.CONFIGURED_TAIGA_CAVE_DECO);
                break;
            }
            case EXTREME_HILLS: {
                event.getGeneration().func_242513_a(stage, SubWildConfiguredFeatures.CONFIGURED_EXTREME_HILLS_CAVE_DECO);
                break;
            }
            case JUNGLE: {
                event.getGeneration().func_242513_a(stage, SubWildConfiguredFeatures.CONFIGURED_JUNGLE_CAVE_DECO);
                break;
            }
            case MESA: {
                event.getGeneration().func_242513_a(stage, SubWildConfiguredFeatures.CONFIGURED_MESA_CAVE_DECO);
                break;
            }
            case PLAINS: {
                event.getGeneration().func_242513_a(stage, SubWildConfiguredFeatures.CONFIGURED_PLAINS_CAVE_DECO);
                break;
            }
            case SAVANNA: {
                event.getGeneration().func_242513_a(stage, SubWildConfiguredFeatures.CONFIGURED_SAVANNA_CAVE_DECO);
                break;
            }
            case ICY: {
                event.getGeneration().func_242513_a(stage, SubWildConfiguredFeatures.CONFIGURED_ICY_CAVE_DECO);
                break;
            }
            case FOREST: {
                event.getGeneration().func_242513_a(stage, SubWildConfiguredFeatures.CONFIGURED_FOREST_CAVE_DECO);
                break;
            }
            case DESERT: {
                event.getGeneration().func_242513_a(stage, SubWildConfiguredFeatures.CONFIGURED_DESERT_CAVE_DECO);
                break;
            }
            case SWAMP: {
                event.getGeneration().func_242513_a(stage, SubWildConfiguredFeatures.CONFIGURED_SWAMP_CAVE_DECO);
                break;
            }
            case MUSHROOM: {
                event.getGeneration().func_242513_a(stage, SubWildConfiguredFeatures.CONFIGURED_MUSHROOM_CAVE_DECO);
                break;
            }
            default: {
                event.getGeneration().func_242513_a(stage, SubWildConfiguredFeatures.CONFIGURED_ROCKY_CAVE_DECO);
            }
        }
    }

    public static <T extends IFeatureConfig> RegistryObject<Feature<T>> add(String name, Feature<T> feature) {
        return FEATURES.register(name, () -> feature);
    }

    public static CaveType addCaveType(CaveType type) {
        CAVE_TYPES.put(type.name, type);
        return type;
    }
}

