/*
 * Decompiled with CFR 0.152.
 */
package melonslise.subwild.common.world.gen.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import melonslise.subwild.common.capability.INoise;
import melonslise.subwild.common.init.SubWildCapabilities;
import melonslise.subwild.common.world.gen.feature.CaveRangeConfig;
import melonslise.subwild.common.world.gen.feature.cavetype.CaveType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;

public class CaveDecoFeature
extends Feature<CaveRangeConfig> {
    public CaveDecoFeature(Codec<CaveRangeConfig> codec) {
        super(codec);
    }

    public boolean func_241855_a(ISeedReader world, ChunkGenerator gen, Random rand, BlockPos pos, CaveRangeConfig cfg) {
        INoise noise = (INoise)world.func_201672_e().getCapability(SubWildCapabilities.NOISE_CAPABILITY).orElse(null);
        if (noise == null) {
            return false;
        }
        float depth = CaveDecoFeature.depthAt((IWorld)world, pos);
        if (depth < 0.0f) {
            return false;
        }
        CaveType type = cfg.getCaveTypeAt(depth);
        if (type == null) {
            return false;
        }
        BlockPos.Mutable adjPos = new BlockPos.Mutable();
        for (int pass = 0; pass < type.getPasses(); ++pass) {
            block9: for (Direction dir : type.getGenOrder(pass)) {
                adjPos.func_189533_g((Vector3i)pos).func_189536_c(dir);
                if (type.canGenSide(world, (BlockPos)adjPos, world.func_180495_p((BlockPos)adjPos), depth, pass, dir)) {
                    switch (dir) {
                        case UP: {
                            type.genCeil(world, noise, (BlockPos)adjPos, depth, pass, rand);
                            break;
                        }
                        case DOWN: {
                            type.genFloor(world, noise, (BlockPos)adjPos, depth, pass, rand);
                            break;
                        }
                        default: {
                            type.genWall(world, noise, (BlockPos)adjPos, depth, pass, rand);
                        }
                    }
                }
                if (!type.canGenExtra(world, pos, world.func_180495_p(pos), (BlockPos)adjPos, world.func_180495_p((BlockPos)adjPos), depth, pass, dir)) continue;
                switch (dir) {
                    case UP: {
                        type.genCeilExtra(world, noise, pos, depth, pass, rand);
                        continue block9;
                    }
                    case DOWN: {
                        type.genFloorExtra(world, noise, pos, depth, pass, rand);
                        continue block9;
                    }
                }
                type.genWallExtra(world, noise, pos, dir, depth, pass, rand);
            }
            if (!type.canGenFill(world, pos, world.func_180495_p(pos), depth, pass)) continue;
            type.genFill(world, noise, pos, depth, pass, rand);
        }
        return false;
    }

    public static float depthAt(IWorld world, BlockPos pos) {
        return 1.0f - (float)pos.func_177956_o() / (float)world.func_201676_a(Heightmap.Type.MOTION_BLOCKING, pos.func_177958_n(), pos.func_177952_p());
    }
}

