/*
 * Decompiled with CFR 0.152.
 */
package melonslise.subwild.common.world.gen.feature;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import melonslise.subwild.common.world.gen.feature.cavetype.CaveType;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class CaveRangeConfig
implements IFeatureConfig {
    public static final Codec<CaveRangeConfig> CODEC = RecordCodecBuilder.create(record -> record.group((App)CaveRange.CODEC.listOf().fieldOf("cave_ranges").forGetter(inst -> inst.caveRanges)).apply((Applicative)record, CaveRangeConfig::new));
    public final List<CaveRange> caveRanges;

    public CaveRangeConfig(List<CaveRange> caveRanges) {
        this.caveRanges = caveRanges;
    }

    public CaveType getCaveTypeAt(double depth) {
        for (CaveRange caveDepth : this.caveRanges) {
            if (!caveDepth.contains(depth)) continue;
            return caveDepth.type;
        }
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        public final List<CaveRange> caveRanges = Lists.newArrayList();

        public Builder addCaveType(CaveType type, double min, double max) {
            this.caveRanges.add(new CaveRange(type, min, max));
            return this;
        }

        public CaveRangeConfig build() {
            return new CaveRangeConfig(this.caveRanges);
        }
    }

    public static class CaveRange {
        public static final Codec<CaveRange> CODEC = RecordCodecBuilder.create(record -> record.group((App)CaveType.CODEC.fieldOf("cave_type").forGetter(inst -> inst.type), (App)Codec.FLOAT.fieldOf("min").forGetter(inst -> Float.valueOf((float)inst.min)), (App)Codec.FLOAT.fieldOf("max").forGetter(inst -> Float.valueOf((float)inst.max))).apply((Applicative)record, CaveRange::new));
        public final CaveType type;
        public final double min;
        public final double max;

        public CaveRange(CaveType inst, double min, double max) {
            this.type = inst;
            this.min = Math.min(min, max);
            this.max = Math.max(min, max);
        }

        public boolean contains(double depth) {
            return this.min <= depth && depth < this.max;
        }
    }
}

