/*
 * Decompiled with CFR 0.152.
 */
package melonslise.subwild.common.world.gen.feature.cavetype;

import com.google.common.collect.ImmutableSet;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import melonslise.subwild.common.capability.INoise;
import melonslise.subwild.common.config.SubWildConfig;
import melonslise.subwild.common.init.SubWildBlocks;
import melonslise.subwild.common.init.SubWildLookups;
import melonslise.subwild.common.init.SubWildProperties;
import melonslise.subwild.common.world.gen.feature.cavetype.CaveType;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraftforge.common.Tags;

public class BasicCaveType
extends CaveType {
    public static final Supplier<Block>[] FOXFIRE = new Supplier[]{SubWildBlocks.SHORT_FOXFIRE, SubWildBlocks.LONG_FOXFIRE};
    public ImmutableSet<Direction> dirs = ImmutableSet.of((Object)Direction.NORTH, (Object)Direction.EAST, (Object)Direction.SOUTH, (Object)Direction.WEST, (Object)Direction.UP, (Object)Direction.DOWN, (Object[])new Direction[0]);
    public float floorCh = 2.0f;
    public float ceilCh = 3.0f;
    public Supplier<Block> defSpel = SubWildBlocks.STONE_SPELEOTHEM;
    public Supplier<Block> defStairs = () -> Blocks.field_222438_lb;
    public Supplier<Block> defSlab = () -> Blocks.field_150333_U;

    public BasicCaveType(ResourceLocation name) {
        super(name);
    }

    public BasicCaveType(String domain, String path) {
        super(domain, path);
    }

    @Override
    public void genFloor(ISeedReader world, INoise noise, BlockPos pos, float depth, int pass, Random rand) {
    }

    @Override
    public void genFloorExtra(ISeedReader world, INoise noise, BlockPos pos, float depth, int pass, Random rand) {
        if (pass == 1) {
            BlockState support = world.func_180495_p(pos.func_177977_b());
            if (support.func_185904_a() == Material.field_151575_d) {
                if (this.getNoise(noise, pos, 0.1) > 0.6) {
                    this.genBlock(world, pos, (BlockState)((BlockState)FOXFIRE[rand.nextInt(FOXFIRE.length)].get().func_176223_P().func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.UP)).func_206870_a((Property)SubWildProperties.GLOWING, (Comparable)Boolean.valueOf(true)));
                }
            } else if ((double)depth > 0.0 && !support.func_235714_a_((ITag)Tags.Blocks.DIRT) && this.getSpelChance(depth, this.floorCh, rand)) {
                this.genRandSpel(world, pos, (BlockState)SubWildLookups.SPELEOS.getOrDefault(support.func_177230_c(), this.defSpel.get()).func_176223_P().func_206870_a((Property)SubWildProperties.VERTICAL_FACING, (Comparable)Direction.UP), depth, rand);
            }
        }
    }

    @Override
    public void genCeil(ISeedReader world, INoise noise, BlockPos pos, float depth, int pass, Random rand) {
    }

    @Override
    public void genCeilExtra(ISeedReader world, INoise noise, BlockPos pos, float depth, int pass, Random rand) {
        if (pass == 1) {
            BlockState support = world.func_180495_p(pos.func_177984_a());
            if (support.func_185904_a() == Material.field_151575_d) {
                if (this.getNoise(noise, pos, 0.1) > 0.6) {
                    this.genBlock(world, pos, (BlockState)((BlockState)FOXFIRE[rand.nextInt(FOXFIRE.length)].get().func_176223_P().func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.DOWN)).func_206870_a((Property)SubWildProperties.GLOWING, (Comparable)Boolean.valueOf(true)));
                }
            } else if (!support.func_235714_a_((ITag)Tags.Blocks.DIRT)) {
                if ((double)depth > 0.0 && this.getSpelChance(depth, this.ceilCh, rand)) {
                    this.genRandSpel(world, pos, (BlockState)SubWildLookups.SPELEOS.getOrDefault(support.func_177230_c(), this.defSpel.get()).func_176223_P().func_206870_a((Property)SubWildProperties.VERTICAL_FACING, (Comparable)Direction.DOWN), depth, rand);
                }
            } else if (this.getNoise(noise, pos, 0.125) > 0.4) {
                this.genRoots(world, noise, pos);
            }
        }
    }

    @Override
    public void genWall(ISeedReader world, INoise noise, BlockPos pos, float depth, int pass, Random rand) {
    }

    @Override
    public void genWallExtra(ISeedReader world, INoise noise, BlockPos pos, Direction wallDir, float depth, int pass, Random rand) {
        if (pass == 1) {
            if (world.func_180495_p(pos.func_177972_a(wallDir)).func_185904_a() == Material.field_151575_d) {
                if (this.getNoise(noise, pos, 0.1) > 0.6) {
                    this.genBlock(world, pos, (BlockState)((BlockState)FOXFIRE[rand.nextInt(FOXFIRE.length)].get().func_176223_P().func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)wallDir.func_176734_d())).func_206870_a((Property)SubWildProperties.GLOWING, (Comparable)Boolean.valueOf(true)));
                }
            } else {
                this.genSlope(world, pos, wallDir, rand);
            }
        }
    }

    @Override
    public void genFill(ISeedReader world, INoise noise, BlockPos pos, float depth, int pass, Random rand) {
    }

    @Override
    public boolean canGenSide(ISeedReader world, BlockPos pos, BlockState state, float depth, int pass, Direction dir) {
        return pass == 0 && (state.func_235714_a_((ITag)Tags.Blocks.STONE) || state.func_235714_a_((ITag)Tags.Blocks.DIRT) || state.func_235714_a_((ITag)Tags.Blocks.GRAVEL)) || state.func_235714_a_((ITag)Tags.Blocks.ORES);
    }

    @Override
    public boolean canGenExtra(ISeedReader world, BlockPos pos, BlockState state, BlockPos sidePos, BlockState sideState, float depth, int pass, Direction dir) {
        return pass == 1 && state.func_196958_f() && (sideState.func_235714_a_((ITag)Tags.Blocks.ORES) || sideState.func_185904_a() == Material.field_151575_d || this.isNatural(world, sidePos, sideState));
    }

    @Override
    public boolean canGenFill(ISeedReader world, BlockPos pos, BlockState state, float depth, int pass) {
        return pass == 1 && state.func_196958_f();
    }

    @Override
    public Set<Direction> getGenOrder(int pass) {
        return this.dirs;
    }

    @Override
    public int getPasses() {
        return 2;
    }

    public boolean getSpelChance(float depth, float baseCh, Random rand) {
        return (float)rand.nextInt(100) < baseCh + depth * 3.0f;
    }

    public void genRandSpel(ISeedReader world, BlockPos pos, BlockState state, float depth, Random rand) {
        this.genSpel(world, pos, state, 1 + rand.nextInt(2) + rand.nextInt((int)(depth * 10.0f) + 1));
    }

    public void genSlope(ISeedReader world, BlockPos pos, Direction wallDir, Random rand) {
        int air;
        BlockPos.Mutable mutPos = new BlockPos.Mutable().func_189533_g((Vector3i)pos);
        Block wall = world.func_180495_p((BlockPos)mutPos.func_189533_g((Vector3i)pos).func_189536_c(wallDir)).func_177230_c();
        boolean isDown = this.isNatural(world, (BlockPos)mutPos.func_189533_g((Vector3i)pos).func_196234_d(0, -1, 0), world.func_180495_p((BlockPos)mutPos));
        boolean isUp = this.isNatural(world, (BlockPos)mutPos.func_189533_g((Vector3i)pos).func_196234_d(0, 1, 0), world.func_180495_p((BlockPos)mutPos));
        if (!isDown && !isUp) {
            return;
        }
        mutPos.func_189533_g((Vector3i)pos);
        Direction oppDir = wallDir.func_176734_d();
        for (air = 0; air < 16 && !world.func_180495_p((BlockPos)mutPos.func_189536_c(oppDir)).func_224755_d((IBlockReader)world, (BlockPos)mutPos, wallDir); ++air) {
        }
        int chance = 6;
        if (air <= (Integer)SubWildConfig.SLOPE_THRESHOLD.get()) {
            chance = 2;
        }
        if (rand.nextInt(10) >= chance) {
            return;
        }
        if (rand.nextInt(5) <= 2) {
            this.genBlock(world, pos, (BlockState)((BlockState)SubWildLookups.STAIRS.getOrDefault(wall, this.defStairs.get()).func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)wallDir)).func_206870_a((Property)BlockStateProperties.field_208164_Q, (Comparable)(isDown ? Half.BOTTOM : Half.TOP)));
        } else {
            this.genBlock(world, pos, (BlockState)SubWildLookups.SLABS.getOrDefault(wall, this.defSlab.get()).func_176223_P().func_206870_a((Property)BlockStateProperties.field_208145_at, (Comparable)(isDown ? SlabType.BOTTOM : SlabType.TOP)));
        }
    }
}

