/*
 * Decompiled with CFR 0.152.
 */
package melonslise.subwild.common.world.gen.feature.cavetype;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import melonslise.subwild.common.capability.INoise;
import melonslise.subwild.common.init.SubWildBlocks;
import melonslise.subwild.common.init.SubWildFeatures;
import melonslise.subwild.common.init.SubWildLookups;
import melonslise.subwild.common.init.SubWildProperties;
import melonslise.subwild.common.init.SubWildTags;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.Tags;

public abstract class CaveType {
    public static final Codec<CaveType> CODEC = RecordCodecBuilder.create(record -> record.group((App)Codec.STRING.fieldOf("name").forGetter(inst -> inst.name.toString())).apply((Applicative)record, str -> SubWildFeatures.CAVE_TYPES.get(new ResourceLocation(str))));
    public final ResourceLocation name;
    public static final Supplier<Block>[] ROOTS = new Supplier[]{SubWildBlocks.LIGHT_BROWN_ROOTS, SubWildBlocks.BROWN_ROOTS, SubWildBlocks.WHITE_ROOTS, SubWildBlocks.LIGHT_ORANGE_ROOTS, SubWildBlocks.ORANGE_ROOTS, SubWildBlocks.DARK_BROWN_ROOTS};

    public CaveType(ResourceLocation name) {
        this.name = name;
    }

    public CaveType(String domain, String path) {
        this(new ResourceLocation(domain, path));
    }

    public abstract void genFloor(ISeedReader var1, INoise var2, BlockPos var3, float var4, int var5, Random var6);

    public abstract void genFloorExtra(ISeedReader var1, INoise var2, BlockPos var3, float var4, int var5, Random var6);

    public abstract void genCeil(ISeedReader var1, INoise var2, BlockPos var3, float var4, int var5, Random var6);

    public abstract void genCeilExtra(ISeedReader var1, INoise var2, BlockPos var3, float var4, int var5, Random var6);

    public abstract void genWall(ISeedReader var1, INoise var2, BlockPos var3, float var4, int var5, Random var6);

    public abstract void genWallExtra(ISeedReader var1, INoise var2, BlockPos var3, Direction var4, float var5, int var6, Random var7);

    public abstract void genFill(ISeedReader var1, INoise var2, BlockPos var3, float var4, int var5, Random var6);

    public abstract boolean canGenSide(ISeedReader var1, BlockPos var2, BlockState var3, float var4, int var5, Direction var6);

    public abstract boolean canGenExtra(ISeedReader var1, BlockPos var2, BlockState var3, BlockPos var4, BlockState var5, float var6, int var7, Direction var8);

    public abstract boolean canGenFill(ISeedReader var1, BlockPos var2, BlockState var3, float var4, int var5);

    public abstract Set<Direction> getGenOrder(int var1);

    public abstract int getPasses();

    public boolean isNatural(ISeedReader world, BlockPos pos, BlockState state) {
        return state.func_235714_a_((ITag)Tags.Blocks.STONE) || state.func_177230_c() == Blocks.field_235406_np_ || state.func_177230_c() == Blocks.field_196814_hQ || state.func_235714_a_((ITag)Tags.Blocks.COBBLESTONE) || state.func_235714_a_((ITag)BlockTags.field_205598_B) || state.func_177230_c() == Blocks.field_196604_cC || state.func_177230_c() == Blocks.field_180397_cI || state.func_235714_a_((ITag)BlockTags.field_205213_E) || state.func_235714_a_((ITag)Tags.Blocks.SANDSTONE) || state.func_235714_a_(SubWildTags.TERRACOTTA) || state.func_235714_a_((ITag)Tags.Blocks.SAND) || state.func_235714_a_((ITag)Tags.Blocks.GRAVEL) || state.func_235714_a_((ITag)Tags.Blocks.DIRT) || state.func_235714_a_((ITag)Tags.Blocks.OBSIDIAN);
    }

    public boolean genBlock(ISeedReader world, BlockPos pos, BlockState state) {
        if (!state.func_196955_c((IWorldReader)world, pos)) {
            return false;
        }
        world.func_180501_a(pos, state, 2);
        return true;
    }

    public boolean replaceBlock(ISeedReader world, BlockPos pos, BlockState state) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (!block.func_203417_a((ITag)Tags.Blocks.ORES)) {
            return this.genBlock(world, pos, state);
        }
        return Optional.ofNullable(SubWildLookups.ORE_TABLE.get(state.func_177230_c())).map(lookup -> (Block)lookup.get(block)).map(newBlock -> this.genBlock(world, pos, newBlock.func_176223_P())).orElse(false);
    }

    public boolean modifyBlock(ISeedReader world, BlockPos pos, Map<Block, Block> lookup) {
        Block block = world.func_180495_p(pos).func_177230_c();
        Block newBlock = lookup.get(block);
        if (newBlock == null) {
            return false;
        }
        return this.replaceBlock(world, pos, newBlock.func_176223_P());
    }

    public boolean genLayer(ISeedReader world, BlockPos pos, BlockState state, double noise, double min, double max, int maxHgt) {
        if (noise < min || noise > max) {
            return false;
        }
        double nrm = (noise - min) / (max - min);
        this.genBlock(world, pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208129_ad, (Comparable)Integer.valueOf((int)((1.0 - 2.0 * Math.abs(nrm - 0.5)) * (double)maxHgt) + 1)));
        return true;
    }

    public void genRoots(ISeedReader world, INoise noise, BlockPos pos) {
        this.genBlock(world, pos, ROOTS[(int)(this.getClampedNoise(noise, pos, 0.0625) * (double)ROOTS.length)].get().func_176223_P());
    }

    public void genVines(ISeedReader world, BlockPos pos, Direction mainDir, int len) {
        BlockPos.Mutable next = new BlockPos.Mutable().func_189533_g((Vector3i)pos);
        for (int a = 0; a < len; ++a) {
            BlockState newState = world.func_180495_p((BlockPos)next);
            if (newState.func_177230_c() != Blocks.field_150395_bd) {
                newState = Blocks.field_150395_bd.func_176223_P();
            }
            newState = (BlockState)newState.func_206870_a((Property)SubWildProperties.FACING_LOOKUP.get(mainDir), (Comparable)Boolean.valueOf(true));
            this.genBlock(world, (BlockPos)next, newState);
            newState = world.func_180495_p((BlockPos)next.func_189536_c(Direction.DOWN));
            if (!newState.func_196958_f() && newState.func_177230_c() != Blocks.field_150395_bd || world.func_180495_p((BlockPos)next.func_189536_c(Direction.DOWN)).func_177230_c() == Blocks.field_150353_l || world.func_180495_p((BlockPos)next.func_189536_c(Direction.DOWN)).func_177230_c() == Blocks.field_150353_l) {
                return;
            }
            next.func_189534_c(Direction.UP, 2);
        }
    }

    public void genKelp(ISeedReader world, BlockPos pos, int len) {
        BlockPos.Mutable next = new BlockPos.Mutable().func_189533_g((Vector3i)pos);
        for (int a = 0; a < len; ++a) {
            this.genBlock(world, (BlockPos)next, (a == len - 1 ? Blocks.field_203214_jx : Blocks.field_203215_jy).func_176223_P());
            BlockState newState = world.func_180495_p((BlockPos)next.func_189536_c(Direction.UP));
            if (newState.func_177230_c() == Blocks.field_150355_j || newState.func_177230_c() == Blocks.field_203214_jx || newState.func_177230_c() == Blocks.field_203215_jy) continue;
            return;
        }
    }

    public void genSpel(ISeedReader world, BlockPos pos, BlockState state, int size) {
        Direction dir = (Direction)state.func_177229_b((Property)SubWildProperties.VERTICAL_FACING);
        BlockPos.Mutable next = new BlockPos.Mutable().func_189533_g((Vector3i)pos);
        for (int a = 0; a < size; ++a) {
            BlockState nextState = world.func_180495_p((BlockPos)next.func_189536_c(dir));
            BlockState newState = state;
            if (nextState.func_196958_f()) {
                newState = (BlockState)newState.func_206870_a((Property)SubWildProperties.FACING_LOOKUP.get(dir), (Comparable)Boolean.valueOf(a != size - 1));
            } else if (a > 0 && this.isNatural(world, (BlockPos)next, nextState)) {
                newState = (BlockState)newState.func_206870_a((Property)SubWildProperties.VERTICAL_FACING, (Comparable)dir.func_176734_d());
            }
            if (a > 0) {
                newState = (BlockState)newState.func_206870_a((Property)SubWildProperties.FACING_LOOKUP.get(dir.func_176734_d()), (Comparable)Boolean.valueOf(true));
            }
            this.genBlock(world, (BlockPos)next.func_189536_c(dir.func_176734_d()), newState);
            next.func_189536_c(dir);
            if (nextState.func_196958_f()) continue;
            return;
        }
    }

    public void genBigBrownShroom(ISeedReader world, BlockPos pos, int len) {
        int a;
        if (len < 1) {
            len = 1;
        }
        BlockPos.Mutable next = new BlockPos.Mutable().func_189533_g((Vector3i)pos).func_196234_d(0, -1, 0);
        for (a = 0; a < len + 1; ++a) {
            this.genBlock(world, (BlockPos)next.func_189536_c(Direction.UP), Blocks.field_196706_do.func_176223_P());
        }
        next.func_189533_g((Vector3i)pos).func_196234_d(-2, len, 0);
        for (a = 0; a < 8; ++a) {
            int i;
            if (world.func_180495_p((BlockPos)next).func_196957_g((IBlockReader)world, (BlockPos)next, PathType.LAND)) {
                this.genBlock(world, (BlockPos)next, Blocks.field_150420_aW.func_176223_P());
            }
            next.func_196234_d((i = a / 2) == 0 || i == 1 ? 1 : -1, 0, i == 0 || i == 3 ? 1 : -1);
        }
        next.func_189533_g((Vector3i)pos).func_196234_d(-1, len + 1, 0);
        for (a = 0; a < 4; ++a) {
            if (world.func_180495_p((BlockPos)next).func_196957_g((IBlockReader)world, (BlockPos)next, PathType.LAND)) {
                this.genBlock(world, (BlockPos)next, Blocks.field_150420_aW.func_176223_P());
            }
            next.func_196234_d(a == 0 || a == 1 ? 1 : -1, 0, a == 0 || a == 3 ? 1 : -1);
        }
        next.func_189533_g((Vector3i)pos).func_196234_d(0, len + 1, 0);
        if (world.func_180495_p((BlockPos)next).func_196957_g((IBlockReader)world, (BlockPos)next, PathType.LAND)) {
            this.genBlock(world, (BlockPos)next, Blocks.field_150420_aW.func_176223_P());
        }
    }

    public void genBigRedShroom(ISeedReader world, BlockPos pos, int len) {
        int a;
        if (len < 1) {
            len = 1;
        }
        BlockPos.Mutable next = new BlockPos.Mutable().func_189533_g((Vector3i)pos).func_196234_d(0, -1, 0);
        for (a = 0; a < len + 2; ++a) {
            this.genBlock(world, (BlockPos)next.func_189536_c(Direction.UP), Blocks.field_196706_do.func_176223_P());
        }
        next.func_189533_g((Vector3i)pos).func_196234_d(-1, len, 0);
        for (a = 0; a < 4; ++a) {
            for (int b = 0; b < 2; ++b) {
                BlockPos next1 = next.func_177982_a(0, b, 0);
                if (!world.func_180495_p(next1).func_196957_g((IBlockReader)world, (BlockPos)next, PathType.LAND)) continue;
                this.genBlock(world, next1, Blocks.field_150419_aX.func_176223_P());
            }
            next.func_196234_d(a == 0 || a == 1 ? 1 : -1, 0, a == 0 || a == 3 ? 1 : -1);
        }
        next.func_189533_g((Vector3i)pos).func_196234_d(0, len + 2, 0);
        if (world.func_180495_p((BlockPos)next).func_196957_g((IBlockReader)world, (BlockPos)next, PathType.LAND)) {
            this.genBlock(world, (BlockPos)next, Blocks.field_150419_aX.func_176223_P());
        }
    }

    public double getNoise(INoise noise, BlockPos pos, double frequency) {
        return noise.sample((double)pos.func_177958_n() * frequency, (double)pos.func_177956_o() * frequency, (double)pos.func_177952_p() * frequency);
    }

    public double getClampedNoise(INoise noise, BlockPos pos, double frequency) {
        return this.getNoise(noise, pos, frequency) / 2.0 + 0.5;
    }
}

