/*
 * Decompiled with CFR 0.152.
 */
package melonslise.subwild.common.world.gen.feature.cavetype;

import com.google.common.collect.ImmutableSet;
import java.util.Random;
import melonslise.subwild.common.capability.INoise;
import melonslise.subwild.common.world.gen.feature.cavetype.BasicCaveType;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;

public class FungalCaveType
extends BasicCaveType {
    public FungalCaveType(String domain, String path) {
        super(domain, path);
        this.dirs = ImmutableSet.of((Object)Direction.DOWN, (Object)Direction.NORTH, (Object)Direction.EAST, (Object)Direction.SOUTH, (Object)Direction.WEST, (Object)Direction.UP, (Object[])new Direction[0]);
    }

    @Override
    public void genFloor(ISeedReader world, INoise noise, BlockPos pos, float depth, int pass, Random rand) {
        if (pass == 0) {
            double d = this.getNoise(noise, pos, 0.125);
            if (d > -0.5) {
                this.replaceBlock(world, pos, Blocks.field_150391_bh.func_176223_P());
            } else if (d > 0.8) {
                this.replaceBlock(world, pos, Blocks.field_150346_d.func_176223_P());
            } else {
                this.replaceBlock(world, pos, Blocks.field_196660_k.func_176223_P());
            }
        }
        super.genFloor(world, noise, pos, depth, pass, rand);
    }

    @Override
    public void genFloorExtra(ISeedReader world, INoise noise, BlockPos pos, float depth, int pass, Random rand) {
        if (pass == 1 && rand.nextInt(34) == 0) {
            int len = -2;
            BlockPos.Mutable next = new BlockPos.Mutable().func_189533_g((Vector3i)pos);
            for (int a = 0; a < 6; ++a) {
                if (!world.func_180495_p((BlockPos)next.func_196234_d(0, 1, 0)).func_196958_f()) continue;
                ++len;
            }
            if (len < 1) {
                return;
            }
            if (rand.nextBoolean()) {
                this.genBigBrownShroom(world, pos, 2 + rand.nextInt(len));
            } else {
                this.genBigRedShroom(world, pos, 1 + rand.nextInt(len));
            }
        } else {
            if (pass == 1 && rand.nextInt(6) == 0) {
                this.genBlock(world, pos, (rand.nextBoolean() ? Blocks.field_150337_Q : Blocks.field_150338_P).func_176223_P());
            }
            super.genFloorExtra(world, noise, pos, depth, pass, rand);
        }
    }

    @Override
    public void genCeil(ISeedReader world, INoise noise, BlockPos pos, float depth, int pass, Random rand) {
        if (pass == 0) {
            double d = this.getNoise(noise, pos, 0.125);
            if (d > 0.0) {
                this.replaceBlock(world, pos, Blocks.field_150405_ch.func_176223_P());
            } else if (d > -0.5) {
                this.replaceBlock(world, pos, Blocks.field_196791_fw.func_176223_P());
            } else if (d > -0.8) {
                this.replaceBlock(world, pos, Blocks.field_150346_d.func_176223_P());
            } else {
                this.replaceBlock(world, pos, Blocks.field_196660_k.func_176223_P());
            }
        }
        super.genCeil(world, noise, pos, depth, pass, rand);
    }

    @Override
    public void genWall(ISeedReader world, INoise noise, BlockPos pos, float depth, int pass, Random rand) {
        if (pass == 0) {
            double d = this.getNoise(noise, pos, 0.125);
            if (d > 0.0) {
                this.replaceBlock(world, pos, Blocks.field_150405_ch.func_176223_P());
            } else if (d > -0.5) {
                this.replaceBlock(world, pos, Blocks.field_196791_fw.func_176223_P());
            } else if (d > -0.8) {
                this.replaceBlock(world, pos, Blocks.field_150346_d.func_176223_P());
            } else {
                this.replaceBlock(world, pos, Blocks.field_196660_k.func_176223_P());
            }
        }
        super.genWall(world, noise, pos, depth, pass, rand);
    }

    @Override
    public void genWallExtra(ISeedReader world, INoise noise, BlockPos pos, Direction wallDir, float depth, int pass, Random rand) {
        if (pass == 1) {
            int len = 1 + rand.nextInt(3);
            float ch = 0.1f;
            if (world.func_180495_p(pos.func_177977_b()).func_196958_f()) {
                ch += 0.1f;
                len += rand.nextInt(6);
            }
            if (rand.nextFloat() < ch) {
                this.genVines(world, pos, wallDir, len);
            }
        }
    }
}

